/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.appuserdb.api;

import java.util.HashMap;
import java.util.Map;

public enum UserRole {
    GUEST(1, "Guest", false, false),
    BROWSER(2, "Browser", true, false),
    EXPERT(3, "Expert", true, true),
    PROCESSOR(4, "Processor", true, true);

    private static final Map<Integer, UserRole> mapById;
    private static final Map<String, UserRole> mapByName;
    private final int id;
    private final String name;
    private final boolean authenticatedAccess;
    private final boolean writeAccess;

    static {
        mapById = new HashMap<Integer, UserRole>();
        mapByName = new HashMap<String, UserRole>();
        UserRole[] userRoleArray = UserRole.values();
        int n = userRoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            UserRole userRole = userRoleArray[n2];
            if (mapById.put(userRole.getId(), userRole) != null) {
                throw new RuntimeException("design error: duplicated id " + userRole.getId());
            }
            if (mapByName.put(userRole.getName().toLowerCase(), userRole) != null) {
                throw new RuntimeException("design error: duplicated name " + userRole.getName());
            }
            ++n2;
        }
    }

    private UserRole(int id, String name, boolean authenticatedAccess, boolean writeAccess) {
        this.id = id;
        this.name = name;
        this.authenticatedAccess = authenticatedAccess;
        this.writeAccess = writeAccess;
    }

    public String getName() {
        return this.name;
    }

    public boolean getAuthenticatedAccess() {
        return this.authenticatedAccess;
    }

    public boolean getWriteAccess() {
        return this.writeAccess;
    }

    public int getId() {
        return this.id;
    }

    public boolean adequateAuthentication(boolean applicationNeed) {
        return !applicationNeed || this.authenticatedAccess;
    }

    public boolean adequateWriteAccess(boolean applicationNeed) {
        return !applicationNeed || this.writeAccess;
    }

    public boolean matchingAccess(boolean authenticationNeed, boolean realTimeNeed, boolean writeNeed) {
        return this.adequateAuthentication(authenticationNeed) && this.adequateWriteAccess(writeNeed);
    }

    public static UserRole get(int id) {
        return mapById.get(id);
    }

    public static UserRole get(String name) {
        return mapByName.get(name.toLowerCase());
    }
}

