/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.appuserdb.constants;

import edu.uml.lgdc.database.DatabaseContents;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum Application {
    GAMBIT_COEFF_SERVLET(1, "GambitCoefficients_Servlet", DatabaseContents.IRTAM.getId()),
    TIDX_BACKEND(2, "TIDExplorer_Backend", DatabaseContents.TID.getId() + DatabaseContents.IRTAM.getId()),
    GAMBIT_EXPLORER_USERAPP(3, "GambitExplorer_UserApp", DatabaseContents.IRTAM.getId()),
    GAMBIT_EXPLORER_MASTERAPP(4, "GambitExplorer_MasterApp", DatabaseContents.IRTAM.getId()),
    RAYTRIX_OI_IONOGRAM_SERVLET(5, "Raytrix_ObliqIonoSynth_Servlet", DatabaseContents.IRTAM.getId()),
    RAYTRIX_AOA_FF_SERVLET(6, "Raytrix_AOA_FF_Servlet", DatabaseContents.IRTAM.getId() + DatabaseContents.SKY_VI.getId()),
    TID_DETECTOR_SERVLET(7, "TID_Detector_Servlet", DatabaseContents.TID.getId()),
    TID_TRACKINFO_SERVLET(8, "TID_TrackInfo_Servlet", DatabaseContents.TID.getId()),
    TID_FINDTRACKS_SERVLET(9, "TID_FindTracks_Servlet", DatabaseContents.TID.getId()),
    TID_PROCESSOR_APP(10, "TID_Processor_App", DatabaseContents.TID.getId() + DatabaseContents.IRTAM.getId()),
    TID_REANALYSIS_APP(11, "TID_Reanalysis_App", DatabaseContents.TID.getId() + DatabaseContents.IRTAM.getId()),
    SKY6_APP(12, "Sky6_App", DatabaseContents.DOP_OI.getId()),
    IRTAM_PROCESSOR_APP(13, "IRTAM_Processor_App", DatabaseContents.IRTAM.getId() + DatabaseContents.FASTCHAR_VI.getId()),
    IRTAM_REANALYSIS_APP(14, "IRTAM_Reanalysis_App", DatabaseContents.IRTAM.getId() + DatabaseContents.FASTCHAR_VI.getId()),
    IRTAM_ANIMATOR_APP(15, "IRTAM_Animator_App", DatabaseContents.IRTAM.getId()),
    GAMBIT_COEFF_LOCAL_SERVLET(16, "GambitCoeffsLocal_Servlet", DatabaseContents.IRTAM.getId()),
    GAMBIT_LOCAL_NOWCAST(17, "GambitLocalNowcast_Servlet", DatabaseContents.IRTAM.getId()),
    ION2PNG_PLUS_APP(18, "Ion2Png.Plus_App", DatabaseContents.IONO_VI.getId() + DatabaseContents.SCALED_VI.getId()),
    GAMBIT_MUF3000_MSG_SERVLET(19, "GambitMuf3000Message_Servlet", DatabaseContents.IRTAM.getId()),
    MUF3000_MESSENGER_APP(20, "MUF3000_Messenger_App", DatabaseContents.IRTAM.getId()),
    FASTCHAR_SERVLET(21, "FastChar_Servlet", DatabaseContents.SCALED_VI.getId()),
    MUFS_SERVLET(22, "MUFs_Servlet", DatabaseContents.SCALED_VI.getId()),
    DIDBASE_PORTAL_SERVLET(23, "DIDBasePortal_Servlet", DatabaseContents.IONO_VI.getId() + DatabaseContents.SCALED_VI.getId()),
    ARTIST_MASTERAPP(24, "ARTIST_MasterApp", DatabaseContents.IONO_VI.getId() + DatabaseContents.SCALED_VI.getId()),
    DIGILISTEN_SERVLET(25, "DigiListen_Servlet", DatabaseContents.TAV.getId()),
    SEVEN_CAT_SCANNER_APP(26, "7CatIonogramScanner_App", DatabaseContents.SCALED_VI.getId());

    private static final Map<Integer, Application> mapById;
    private static final Map<String, Application> mapByName;
    private final int id;
    private final String name;
    private final long contents;

    static {
        mapById = new HashMap<Integer, Application>();
        mapByName = new HashMap<String, Application>();
        Application[] applicationArray = Application.values();
        int n = applicationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Application application = applicationArray[n2];
            if (mapById.put(application.getId(), application) != null) {
                throw new RuntimeException("Design error: duplicated Id, " + application.getId());
            }
            if (mapByName.put(application.getName().toLowerCase(), application) != null) {
                throw new RuntimeException("Design error: duplicated Id, " + application.getName());
            }
            ++n2;
        }
    }

    private Application(int id, String name, long contents) {
        this.id = id;
        this.name = name;
        this.contents = contents;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static Application get(int id) {
        return mapById.get(id);
    }

    public static Application get(String name) {
        return mapByName.get(name.toLowerCase());
    }

    public List<DatabaseContents> getAllDatabaseContents() {
        ArrayList<DatabaseContents> allContents = new ArrayList<DatabaseContents>(5);
        DatabaseContents[] databaseContentsArray = DatabaseContents.values();
        int n = databaseContentsArray.length;
        int n2 = 0;
        while (n2 < n) {
            DatabaseContents c = databaseContentsArray[n2];
            if (c.isIncluded(this.contents)) {
                allContents.add(c);
            }
            ++n2;
        }
        return allContents;
    }

    public long getContents() {
        return this.contents;
    }

    public int getStartLineNumberInAppContentList() {
        int lineNumber = 0;
        int i = this.id - 1;
        while (i > 0) {
            Application app = Application.get(i);
            lineNumber += app.getAllDatabaseContents().size();
            --i;
        }
        return lineNumber;
    }
}

