/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.appuserdb.test;

import edu.uml.lgdc.appuserdb.api.LgdcRegistry;
import edu.uml.lgdc.appuserdb.type.Account;
import java.sql.SQLException;
import java.util.Set;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestAddUser {
    private static final String INI_FILE_NAME = "test.ini";
    private static final String ADD_USERS_FILE_NAME = "addusers.txt";
    private static Set<Account> newAccounts;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        LgdcRegistry.setupRegistryAsRegistrar(INI_FILE_NAME);
        newAccounts = Account.read(ADD_USERS_FILE_NAME);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        LgdcRegistry.releaseAllResources();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void test() {
        try {
            for (Account acc : newAccounts) {
                LgdcRegistry.addUser(acc.getUsername(), acc.getPass(), acc.getEmail(), acc.getContactPerson(), acc.getOrganization());
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }
}

