/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.appuserdb.test;

import edu.uml.lgdc.appuserdb.api.LgdcRegistry;
import edu.uml.lgdc.appuserdb.constants.Application;
import edu.uml.lgdc.fileio.FileUtils;
import java.io.File;
import java.sql.SQLException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestGetSetSettings {
    private static final String INI_FILE_NAME = "test.ini";
    private static final String SETTINGS_FILE_NAME = "TIDExplorer.ini";
    private static String settings;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        LgdcRegistry.setupRegistryAsRegistrar(INI_FILE_NAME);
        settings = FileUtils.fileToString(new File(SETTINGS_FILE_NAME)).trim();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        LgdcRegistry.releaseAllResources();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void setSettings() {
        try {
            LgdcRegistry.saveUserSettings("LDI", Application.TIDX_BACKEND, settings);
            System.out.println("Set settings:\n" + settings);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    @Test
    public void getSettings() {
        try {
            String settings = LgdcRegistry.loadUserSettings("LDI", Application.TIDX_BACKEND);
            System.out.println("Get settings:\n" + settings);
            if (!TestGetSetSettings.settings.equals(settings)) {
                throw new RuntimeException("comparing failed!");
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }
}

