/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.appuserdb.type;

import edu.uml.lgdc.appuserdb.api.UserRole;
import edu.uml.lgdc.appuserdb.constants.Application;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.security.UserPass;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class Permission {
    private final String username;
    private final Application application;
    private final UserRole userRole;
    private final boolean realtime;
    private final int dbCredentialsId;

    public Permission(String username, Application application, UserRole userRole, boolean realtime, int dbCredentialsId) {
        this.username = Objects.requireNonNull(username).trim();
        this.application = Objects.requireNonNull(application);
        this.userRole = Objects.requireNonNull(userRole);
        this.realtime = realtime;
        this.dbCredentialsId = dbCredentialsId;
        if (this.username.isEmpty()) {
            throw new IllegalArgumentException("username is empty");
        }
        if (UserPass.isUsernameContainsIllegalSymbols(this.username)) {
            throw new IllegalArgumentException("username contains illegal characters");
        }
    }

    public String getUsername() {
        return this.username;
    }

    public Application getApplication() {
        return this.application;
    }

    public UserRole getUserRole() {
        return this.userRole;
    }

    public boolean getRealtimeOK() {
        return this.realtime;
    }

    public int getDbCredentialsId() {
        return this.dbCredentialsId;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            Permission perm = (Permission)object;
            return this.username.equalsIgnoreCase(perm.username) && this.application == perm.application && this.userRole == perm.userRole && this.realtime == perm.realtime && this.dbCredentialsId == perm.dbCredentialsId;
        }
        return false;
    }

    public int hashCode() {
        return 31 * (31 * this.username.toLowerCase().hashCode() + this.application.hashCode()) + this.userRole.hashCode() + Boolean.hashCode(this.realtime) + Integer.hashCode(this.dbCredentialsId);
    }

    public static Set<Permission> read(String filename) throws IOException {
        File file = new File(filename);
        if (!file.isFile()) {
            throw new RuntimeException("cannot find file " + file);
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader br = new BufferedReader(new FileReader(filename));){
            String line;
            HashSet<Permission> permissions = new HashSet<Permission>(256);
            int addCount = 0;
            int lineCount = 0;
            while ((line = br.readLine()) != null) {
                ++lineCount;
                if ((line = line.trim()).isEmpty() || line.startsWith("#") || line.startsWith("=")) continue;
                String[] items = line.split("\\s*,\\s*");
                if (items.length != 5) {
                    throw new RuntimeException("line " + lineCount + ": illegal number of items, has to be 5");
                }
                String username = items[0].trim();
                Application application = Application.get(items[1].trim());
                if (application == null) {
                    throw new RuntimeException("illegal application name, " + items[1].trim());
                }
                UserRole userRole = UserRole.get(items[2].trim());
                if (userRole == null) {
                    throw new RuntimeException("illegal role name, " + items[2].trim());
                }
                boolean realtime = Boolean.getBoolean(items[3]);
                int dbCredsId = Integer.parseInt(items[4].trim());
                permissions.add(new Permission(username, application, userRole, realtime, dbCredsId));
                ++addCount;
            }
            if (permissions.size() == 0) {
                Console.showWarn("no permissions found in file " + file);
            } else if (permissions.size() < addCount) {
                Console.showWarn(String.valueOf(addCount - permissions.size()) + " duplication(s) of permission(s) in file " + file);
            }
            return permissions;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public String toString() {
        return "U=" + this.username + " for " + (Object)((Object)this.application) + " as " + (Object)((Object)this.userRole) + " RT=" + this.realtime + " and DB#" + this.dbCredentialsId;
    }
}

