/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.colorscale;

import edu.uml.lgdc.colorscale.BTC;
import edu.uml.lgdc.colorscale.BTY;
import edu.uml.lgdc.colorscale.BlueRed;
import edu.uml.lgdc.colorscale.ColdHot;
import edu.uml.lgdc.colorscale.Differences;
import edu.uml.lgdc.colorscale.Gray;
import edu.uml.lgdc.colorscale.HeatedObject;
import edu.uml.lgdc.colorscale.InverseGray;
import edu.uml.lgdc.colorscale.Jet;
import edu.uml.lgdc.colorscale.LOCS;
import edu.uml.lgdc.colorscale.LinearGray;
import edu.uml.lgdc.colorscale.NASA;
import edu.uml.lgdc.colorscale.OCS;
import edu.uml.lgdc.colorscale.Rainbow;
import java.awt.Color;

public class ColorScale {
    public static final int CDAWEB_COLORSCALE = 0;
    public static final int GRAY_COLORSCALE = 1;
    public static final int BTC_COLORSCALE = 2;
    public static final int BTY_COLORSCALE = 3;
    public static final int HEAT_COLORSCALE = 4;
    public static final int LINGRAY_COLORSCALE = 5;
    public static final int LOCS_COLORSCALE = 6;
    public static final int INVGRAY_COLORSCALE = 7;
    public static final int OCS_COLORSCALE = 8;
    public static final int RAINBOW_COLORSCALE = 9;
    public static final int JET_COLORSCALE = 10;
    public static final int COLD_HOT = 11;
    public static final int BLUE_RED = 12;
    public static final int DIFFERENCES = 13;
    public static final int QTY_OF_COLORSCALES = 14;
    private static final String[] shortNames = new String[]{"CDAWeb Colors", "Grayscale", "BTC", "BTY", "Heated Object", "Linear Gray", "LOCS", "Inverse Gray", "OSC", "Rainbow", "Jet", "Cold-Hot", "Blue-Red", "Differences"};
    private static ColorScale[] allTypesOfColorScaleInstances = null;
    public int MAX_COLORS;
    protected int MAX_COLORS_BUT1;
    protected Color[] colorArray;

    public Color getColor(double value) {
        if (value < 0.0) {
            value = 0.0;
        }
        if (value > 1.0) {
            value = 1.0;
        }
        return this.colorArray[(int)Math.round(value * (double)this.MAX_COLORS_BUT1)];
    }

    public Color getColor(int value) {
        return this.colorArray[value];
    }

    public static ColorScale getColorScale(int colorScaleIndex) {
        if (allTypesOfColorScaleInstances == null) {
            allTypesOfColorScaleInstances = new ColorScale[14];
        }
        if (allTypesOfColorScaleInstances[colorScaleIndex] == null) {
            ColorScale.allTypesOfColorScaleInstances[colorScaleIndex] = ColorScale.get_ColorScale(colorScaleIndex);
        }
        return allTypesOfColorScaleInstances[colorScaleIndex];
    }

    public static String getColorScaleShortName(int colorScaleIndex) {
        return shortNames[colorScaleIndex];
    }

    private static ColorScale get_ColorScale(int colorScaleIndex) {
        ColorScale colorScale = null;
        switch (colorScaleIndex) {
            case 0: {
                colorScale = new NASA();
                break;
            }
            case 1: {
                colorScale = new Gray();
                break;
            }
            case 2: {
                colorScale = new BTC();
                break;
            }
            case 3: {
                colorScale = new BTY();
                break;
            }
            case 4: {
                colorScale = new HeatedObject();
                break;
            }
            case 5: {
                colorScale = new LinearGray();
                break;
            }
            case 6: {
                colorScale = new LOCS();
                break;
            }
            case 7: {
                colorScale = new InverseGray();
                break;
            }
            case 8: {
                colorScale = new OCS();
                break;
            }
            case 9: {
                colorScale = new Rainbow();
                break;
            }
            case 10: {
                colorScale = new Jet();
                break;
            }
            case 11: {
                colorScale = new ColdHot();
                break;
            }
            case 12: {
                colorScale = new BlueRed();
                break;
            }
            case 13: {
                colorScale = new Differences();
            }
        }
        return colorScale;
    }
}

