/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.colorscale;

import edu.uml.lgdc.colorscale.ColorScale;
import java.awt.Color;

public class Differences
extends ColorScale {
    public Differences() {
        this.MAX_COLORS = 256;
        this.colorArray = new Color[this.MAX_COLORS];
        this.MAX_COLORS_BUT1 = this.MAX_COLORS - 1;
        int loop = 0;
        while (loop < this.MAX_COLORS / 2) {
            int r = Math.min(7 + loop * 2, 255);
            int g = Math.min(144 + loop, 255);
            int b = Math.min(214 + loop / 3, 255);
            this.colorArray[loop] = new Color(r, g, b);
            r = 255;
            b = g = Math.max(255 - loop * 2, 3);
            this.colorArray[loop + this.MAX_COLORS / 2] = new Color(r, g, b);
            ++loop;
        }
    }

    @Override
    public Color getColor(double value) {
        if (value < -1.0) {
            value = -1.0;
        }
        if (value > 1.0) {
            value = 1.0;
        }
        return this.colorArray[(int)Math.round(0.5 * (value + 1.0) * (double)this.MAX_COLORS_BUT1)];
    }
}

