/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.comms;

import edu.uml.lgdc.comms.Communication;
import edu.uml.lgdc.instrument.ConnectionSettings_Ix;
import edu.uml.lgdc.project.Console;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;

public class TCPChannelComm
implements Communication {
    private static final int EOS = -1;
    private static final SelectorProvider PROVIDER = SelectorProvider.provider();
    private static final String LOCAL_HOST_STR = "localhost";
    private static final String LOCAL_HOST_ADDR = "127.0.0.1";
    private ConnectionSettings_Ix settings;
    protected String commName;
    private InetAddress inetIP;
    protected InputStream is;
    protected OutputStream os;
    protected Socket socket;
    private ServerSocket serverSocket;
    private SocketChannel channel;
    private ServerSocketChannel serverChannel;
    protected int connectCount;
    private String type = "Server";
    private InetSocketAddress sockAddr;
    private transient boolean illegalClientAddress;

    public TCPChannelComm(String commName, ConnectionSettings_Ix settings) {
        this.commName = commName;
        this.settings = settings;
        try {
            this.channel = PROVIDER.openSocketChannel();
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    @Override
    public boolean connect() {
        return this.connect(0);
    }

    @Override
    public boolean connect(int milliSec) {
        boolean result;
        block25: {
            result = true;
            try {
                if (this.connectCount == 0) {
                    if (!this.settings.getConnectAsClientEnable()) {
                        Console.showMsg("Creating " + this.commName + " Server socket on port " + this.settings.getPort());
                        this.serverChannel = PROVIDER.openServerSocketChannel();
                        this.serverSocket = this.serverChannel.socket();
                        this.serverSocket.bind(new InetSocketAddress(this.settings.getPort()));
                        this.serverSocket.setReceiveBufferSize(this.settings.getRcvBufferSize());
                    } else {
                        this.inetIP = InetAddress.getByName(this.settings.getIPAddress());
                        this.sockAddr = new InetSocketAddress(this.inetIP, this.settings.getPort());
                        Console.showMsg("IP address: " + this.settings.getIPAddress() + ", port: " + this.settings.getPort());
                    }
                }
                ++this.connectCount;
                if (this.channel != null) {
                    try {
                        this.channel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.channel = null;
                }
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.socket = null;
                }
                if (!this.settings.getConnectAsClientEnable()) {
                    if (!this.illegalClientAddress) {
                        Console.showMsg(String.valueOf(this.commName) + " Server is listening to port " + this.settings.getPort() + " for connection...");
                    }
                    this.illegalClientAddress = false;
                    this.serverSocket.setSoTimeout(milliSec);
                    this.channel = this.serverChannel.accept();
                    this.socket = this.channel.socket();
                    String remoteAddress = this.socket.getInetAddress().getHostAddress();
                    if (!this.settings.getAcceptAnyIPAddressEnable()) {
                        String ipClientAddr;
                        if (remoteAddress.equalsIgnoreCase(LOCAL_HOST_STR)) {
                            remoteAddress = LOCAL_HOST_ADDR;
                        }
                        if ((ipClientAddr = this.settings.getIPClientAddress()).equalsIgnoreCase(LOCAL_HOST_STR)) {
                            ipClientAddr = LOCAL_HOST_ADDR;
                        }
                        if (!remoteAddress.equals(ipClientAddr)) {
                            this.channel.close();
                            this.illegalClientAddress = true;
                            throw new IOException();
                        }
                    }
                    Console.showMsg(String.valueOf(this.commName) + " Server accepted connection from " + remoteAddress);
                    this.serverChannel.close();
                    this.serverChannel = null;
                } else {
                    if (this.connectCount == 1) {
                        Console.showMsg(String.valueOf(this.commName) + " Client is trying to connect...");
                    }
                    this.illegalClientAddress = false;
                    this.channel = PROVIDER.openSocketChannel();
                    this.socket = this.channel.socket();
                    this.socket.setSoTimeout(milliSec);
                    this.socket.setReceiveBufferSize(this.settings.getRcvBufferSize());
                    this.channel.connect(this.sockAddr);
                    Console.showMsg(String.valueOf(this.commName) + " Client connected");
                }
                this.socket.setSoTimeout(0);
                this.socket.setKeepAlive(true);
                this.socket.setTcpNoDelay(false);
                if (this.is != null) {
                    try {
                        this.is.close();
                    }
                    catch (IOException remoteAddress) {
                        // empty catch block
                    }
                    this.is = null;
                }
                if (this.os != null) {
                    try {
                        this.os.close();
                    }
                    catch (IOException remoteAddress) {
                        // empty catch block
                    }
                    this.os = null;
                }
                this.is = new ChannelInputStream(this.channel);
                this.os = new ChannelOutputStream(this.channel);
            }
            catch (IOException e) {
                result = false;
                if ((this.illegalClientAddress || this.settings.getConnectAsClientEnable() || e instanceof AsynchronousCloseException) && (!this.settings.getConnectAsClientEnable() || e instanceof ConnectException)) break block25;
                Console.showMsg(String.valueOf(this.commName) + " " + this.type + ": " + e.toString());
            }
        }
        return result;
    }

    @Override
    public InputStream getInputStream() {
        return this.is;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.os;
    }

    @Override
    public boolean getDelayControlEnable() {
        return true;
    }

    @Override
    public boolean getNoDelayEnable() throws SocketException {
        return this.socket.getTcpNoDelay();
    }

    @Override
    public void setNoDelayEnable(boolean value) throws SocketException {
        this.socket.setTcpNoDelay(value);
    }

    @Override
    public int getTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    @Override
    public void setTimeout(int milliSec) throws SocketException {
        this.socket.setSoTimeout(milliSec);
    }

    @Override
    public void close() {
        this.closeClient();
        this.closeServer();
        this.connectCount = 0;
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.is = null;
        }
        if (this.os != null) {
            try {
                this.os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.os = null;
        }
    }

    private void closeClient() {
        if (this.channel != null) {
            if (this.channel.isOpen()) {
                try {
                    this.channel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.channel = null;
            this.socket = null;
        }
    }

    private void closeServer() {
        if (this.serverChannel != null) {
            if (this.serverChannel.isOpen()) {
                try {
                    this.serverChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.serverChannel = null;
        }
    }

    private static class ChannelInputStream
    extends InputStream {
        private SocketChannel channel;
        private ByteBuffer buffer = ByteBuffer.wrap(new byte[10000]);
        private boolean eos = false;

        ChannelInputStream(SocketChannel channel) {
            if (channel == null) {
                throw new IllegalArgumentException("channel is null");
            }
            this.channel = channel;
            this.buffer.limit(0);
        }

        @Override
        public synchronized int read() throws IOException {
            if (this.channel == null) {
                return -1;
            }
            if (this.eos) {
                throw new IOException("Try reading beyond End Of Stream");
            }
            if (this.buffer.position() == this.buffer.limit()) {
                this.buffer.clear();
                if (this.channel.read(this.buffer) == -1) {
                    this.eos = true;
                    return -1;
                }
                this.buffer.flip();
            }
            int res = this.buffer.get() & 0xFF;
            return res;
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (this.channel == null) {
                return -1;
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (this.eos) {
                throw new IOException("Try reading beyond End Of Stream");
            }
            int c = this.read();
            if (c == -1) {
                this.eos = true;
                return -1;
            }
            b[off++] = (byte)c;
            int available = Math.min(this.available(), len - 1);
            int qty = 1 + available;
            int i = 0;
            while (i < available) {
                b[off++] = this.buffer.get();
                ++i;
            }
            return qty;
        }

        @Override
        public synchronized int available() {
            if (this.channel == null) {
                return 0;
            }
            return this.buffer.limit() - this.buffer.position();
        }

        @Override
        public synchronized void close() throws IOException {
            try {
                try {
                    if (this.channel != null) {
                        this.channel.close();
                    }
                }
                catch (IOException e) {
                    Console.showError(e.toString());
                    this.channel = null;
                }
            }
            finally {
                this.channel = null;
            }
        }
    }

    private static class ChannelOutputStream
    extends OutputStream {
        private SocketChannel channel;
        private ByteBuffer buffer = ByteBuffer.wrap(new byte[10000]);
        private boolean eos = false;

        ChannelOutputStream(SocketChannel channel) {
            if (channel == null) {
                throw new IllegalArgumentException("channel is null");
            }
            this.channel = channel;
        }

        @Override
        public synchronized void write(int b) throws IOException {
            if (this.channel == null) {
                return;
            }
            if (this.eos) {
                throw new IOException("Try writing after Output Shutdown");
            }
            if (this.buffer.position() == this.buffer.limit()) {
                this.buffer.flip();
                this.channel.write(this.buffer);
                this.buffer.clear();
            }
            this.buffer.put((byte)b);
        }

        @Override
        public synchronized void flush() throws IOException {
            if (this.channel == null) {
                return;
            }
            if (this.eos) {
                throw new IOException("Try writing after Output Shutdown");
            }
            if (this.buffer.position() > 0) {
                this.buffer.flip();
                this.channel.write(this.buffer);
                this.buffer.clear();
            }
        }

        @Override
        public synchronized void close() throws IOException {
            try {
                try {
                    if (this.channel != null) {
                        this.channel.close();
                    }
                }
                catch (IOException e) {
                    Console.showError(e.toString());
                    this.channel = null;
                }
            }
            finally {
                this.channel = null;
            }
        }
    }
}

