/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.comms;

import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.time.TimeScale;

public abstract class ThreadLoop
extends Thread {
    protected boolean stop;
    private boolean working;
    protected boolean terminateOnError = false;

    public ThreadLoop() {
    }

    public ThreadLoop(String threadName) {
        super(threadName);
    }

    @Override
    public void run() {
        block16: {
            Throwable err = null;
            TimeScale timeOfError = null;
            try {
                try {
                    this.startWork();
                    do {
                        if (!this.passWork()) continue;
                        break;
                    } while (!this.stop);
                }
                catch (InterruptedException interruptedException) {
                    this.stopWork();
                    if (err != null) {
                        ConsoleUtil util = new ConsoleUtil();
                        if (err instanceof Error || this.terminateOnError) {
                            util.terminate(err, timeOfError);
                        }
                        if (err instanceof ThreadDeath) {
                            throw new ThreadDeath();
                        }
                        Console.printThreadStackTrace(err);
                    }
                }
                catch (Throwable e) {
                    err = e;
                    timeOfError = new TimeScale();
                    this.stopWork();
                    if (err == null) break block16;
                    ConsoleUtil util = new ConsoleUtil();
                    if (err instanceof Error || this.terminateOnError) {
                        util.terminate(err, timeOfError);
                    }
                    if (err instanceof ThreadDeath) {
                        throw new ThreadDeath();
                    }
                    Console.printThreadStackTrace(err);
                }
            }
            finally {
                this.stopWork();
                if (err != null) {
                    ConsoleUtil util = new ConsoleUtil();
                    if (err instanceof Error || this.terminateOnError) {
                        util.terminate(err, timeOfError);
                    }
                    if (err instanceof ThreadDeath) {
                        throw new ThreadDeath();
                    }
                    Console.printThreadStackTrace(err);
                }
            }
        }
    }

    protected abstract boolean passWork() throws InterruptedException;

    public synchronized void requestStop() {
        if (this.working) {
            this.stop = true;
        }
    }

    public boolean isWorking() {
        return this.working;
    }

    protected synchronized void startWork() {
        this.working = true;
        this.stop = false;
    }

    protected synchronized void stopWork() {
        this.working = false;
        this.stop = false;
    }

    public void setTerminateOnErrorEnabled(boolean flag) {
        this.terminateOnError = flag;
    }

    private class ConsoleUtil
    extends Console {
        private ConsoleUtil() {
        }
    }
}

