/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.comms;

import edu.uml.lgdc.multithread.Semaphore;
import edu.uml.lgdc.project.Console;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;

public class UDPInputStream
extends InputStream {
    private static final int NUMBER_OF_PACKETS = 100;
    private static final int MAX_SIZE_OF_PACKET_DATA = 10000;
    private static final boolean DEBUG = false;
    private DatagramSocket socket;
    private int udpMaxSize;
    private boolean initialized;
    private boolean closed;
    private byte[][] packetData;
    private int[] dataLen;
    private int outPacket = 0;
    private int outDataOffset = 0;
    private int inPacket = 0;
    private Semaphore smfFilledPackets;
    private Semaphore smfEmptyPackets;
    private UDPDatagramReader reader;
    private boolean getNextUDPPacketFromQueue = true;
    private boolean packetReaderSentTerminated;
    private boolean packetReaderTerminated;

    public UDPInputStream(DatagramSocket socket) {
        this(socket, 10000);
    }

    public UDPInputStream(DatagramSocket socket, int udpMaxSize) {
        this.socket = socket;
        this.setUDPMaxSize(udpMaxSize);
    }

    public void setUDPMaxSize(int udpMaxSize) {
        if (this.initialized) {
            throw new RuntimeException("UDPInputStream.setUDPMaxSize(): can be only used before method read()");
        }
        if (udpMaxSize <= 0) {
            throw new IllegalArgumentException("UDPInputStream.setUDPMaxSize(): illegal param udpMaxSize, " + udpMaxSize);
        }
        this.udpMaxSize = udpMaxSize;
    }

    private synchronized void init() {
        this.packetData = new byte[100][this.udpMaxSize];
        this.dataLen = new int[100];
        this.outPacket = 0;
        this.outDataOffset = 0;
        this.inPacket = 0;
        this.smfFilledPackets = new Semaphore(0);
        this.smfEmptyPackets = new Semaphore(100);
        this.reader = new UDPDatagramReader();
        this.getNextUDPPacketFromQueue = true;
        this.packetReaderSentTerminated = false;
        this.packetReaderTerminated = false;
        this.reader.start();
        this.initialized = true;
    }

    @Override
    public int read() throws IOException {
        block9: {
            if (this.closed) {
                return -1;
            }
            if (!this.initialized) {
                this.init();
            }
            try {
                if (this.getNextUDPPacketFromQueue) {
                    if (this.smfFilledPackets.ask() <= 0) {
                        if (this.packetReaderTerminated) break block9;
                        this.smfFilledPackets.pend(0);
                    } else {
                        this.smfFilledPackets.pend(0);
                    }
                    if (this.packetReaderSentTerminated) {
                        this.packetReaderTerminated = true;
                        this.packetReaderSentTerminated = false;
                    }
                    this.getNextUDPPacketFromQueue = false;
                }
                int c = this.packetData[this.outPacket][this.outDataOffset] & 0xFF;
                ++this.outDataOffset;
                if (this.outDataOffset >= this.dataLen[this.outPacket]) {
                    this.outPacket = this.nextPacketIndex(this.outPacket);
                    this.outDataOffset = 0;
                    this.smfEmptyPackets.post();
                    this.getNextUDPPacketFromQueue = true;
                }
                return c;
            }
            catch (InterruptedException e) {
                Console.showWarn("UDPInputStrea.read() interrupted");
            }
        }
        this.closed = true;
        this.reader.interrupt();
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        int nRead = 1;
        ++off;
        --len;
        while (len > 0) {
            int nAvail = Math.min(this.available(), len);
            if (nAvail <= 0) break;
            int i = 0;
            while (i < nAvail) {
                b[off + i] = (byte)this.read();
                ++i;
            }
            off += nAvail;
            nRead += nAvail;
            len -= nAvail;
        }
        return nRead;
    }

    @Override
    public int available() throws IOException {
        if (this.closed || this.smfFilledPackets.ask() <= 0) {
            return 0;
        }
        int size = 0;
        int packetIndex = this.outPacket;
        int filledPackets = this.smfFilledPackets.ask();
        int i = 0;
        while (i < filledPackets) {
            size = i == 0 ? this.dataLen[packetIndex] - this.outDataOffset : (size += this.dataLen[packetIndex]);
            packetIndex = this.nextPacketIndex(packetIndex);
            ++i;
        }
        return size;
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.initialized) {
            return;
        }
        if (this.closed) {
            return;
        }
        this.reader.interrupt();
        this.socket.close();
        try {
            while (this.reader.isAlive()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.closed = true;
        this.socket = null;
    }

    private int nextPacketIndex(int packetIndex) {
        if (++packetIndex >= 100) {
            packetIndex = 0;
        }
        return packetIndex;
    }

    private class UDPDatagramReader
    extends Thread {
        UDPDatagramReader() {
            super("DatagramReader");
        }

        @Override
        public void run() {
            boolean packetNumber = true;
            try {
                while (true) {
                    UDPInputStream.this.smfEmptyPackets.pend(0);
                    DatagramPacket p = new DatagramPacket(UDPInputStream.this.packetData[UDPInputStream.this.inPacket], UDPInputStream.this.udpMaxSize);
                    UDPInputStream.this.socket.receive(p);
                    ((UDPInputStream)UDPInputStream.this).dataLen[((UDPInputStream)UDPInputStream.this).inPacket] = p.getLength();
                    UDPInputStream.this.inPacket = UDPInputStream.this.nextPacketIndex(UDPInputStream.this.inPacket);
                    UDPInputStream.this.smfFilledPackets.post();
                }
            }
            catch (IOException e) {
                Console.showError("UDPInputStream.UDPDatagramReader: " + e.toString());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            UDPInputStream.this.packetReaderSentTerminated = true;
            UDPInputStream.this.smfFilledPackets.post();
        }
    }
}

