/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.comms;

import edu.uml.lgdc.multithread.Semaphore;
import edu.uml.lgdc.project.Console;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramSocket;
import java.net.SocketAddress;

public class UDPOutputStream
extends OutputStream {
    private static final int NUMBER_OF_PACKETS = 100;
    private static final int MAX_SIZE_OF_PACKET_DATA = 10000;
    private static final int SPEED_IN_BYTES_PER_SEC = 100000;
    private static final boolean DEBUG = false;
    private DatagramSocket socket;
    private SocketAddress socketAddress;
    private int udpMaxSize;
    private int flushBufferPeriod_ms;
    private boolean initialized;
    private boolean closed;
    private byte[][] packetData;
    private int[] dataLen;
    private int outPacket;
    private int inPacket;
    private int inDataOffset;
    private Semaphore smfFilledPackets;
    private Semaphore smfEmptyPackets;
    private UDPDatagramWriter writer;
    private boolean getNextPacketBufferFromQueue = true;
    private boolean packetWriterSentTerminated;
    private Object sync = new Object();

    public UDPOutputStream(DatagramSocket socket, SocketAddress socketAddress) {
        this(socket, socketAddress, 10000);
    }

    public UDPOutputStream(DatagramSocket socket, SocketAddress socketAddress, int udpMaxSize) {
        this.socket = socket;
        this.socketAddress = socketAddress;
        this.setUDPMaxSize(udpMaxSize);
    }

    public void setUDPMaxSize(int udpMaxSize) {
        if (this.initialized) {
            throw new RuntimeException("UDPOutputStream.setUDPMaxSize(): can be only used before method write()");
        }
        if (udpMaxSize <= 0) {
            throw new IllegalArgumentException("UDPOutputStream.setUDPMaxSize(): illegal param udpMaxSize, " + udpMaxSize);
        }
        this.udpMaxSize = udpMaxSize;
    }

    private synchronized void init() {
        this.packetData = new byte[100][this.udpMaxSize];
        this.dataLen = new int[100];
        this.outPacket = 0;
        this.inPacket = 0;
        this.inDataOffset = 0;
        this.smfFilledPackets = new Semaphore(0);
        this.smfEmptyPackets = new Semaphore(100);
        this.writer = new UDPDatagramWriter();
        this.getNextPacketBufferFromQueue = true;
        this.packetWriterSentTerminated = false;
        this.flushBufferPeriod_ms = 1000 * this.udpMaxSize / 100000;
        if (this.flushBufferPeriod_ms < 5) {
            this.flushBufferPeriod_ms = 5;
        }
        this.writer.start();
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int c) throws IOException {
        block13: {
            if (this.closed) {
                return;
            }
            if (!this.initialized) {
                this.init();
            }
            try {
                if (this.getNextPacketBufferFromQueue) {
                    if (this.packetWriterSentTerminated) break block13;
                    if (this.smfEmptyPackets.ask() <= 0) {
                        this.smfEmptyPackets.pend(0);
                        if (this.packetWriterSentTerminated) {
                            break block13;
                        }
                    } else {
                        this.smfEmptyPackets.pend(0, 1);
                    }
                    this.getNextPacketBufferFromQueue = false;
                }
                Object object = this.sync;
                synchronized (object) {
                    if (this.packetWriterSentTerminated) {
                        break block13;
                    }
                    this.packetData[this.inPacket][this.inDataOffset++] = (byte)c;
                    if (this.inDataOffset >= this.udpMaxSize) {
                        this.dataLen[this.inPacket] = this.udpMaxSize;
                        this.inPacket = this.nextPacketIndex(this.inPacket);
                        this.inDataOffset = 0;
                        this.smfFilledPackets.post();
                        this.getNextPacketBufferFromQueue = true;
                    }
                }
                return;
            }
            catch (InterruptedException e) {
                Console.showWarn("UDPInputStrea.read() interrupted");
            }
        }
        this.closed = true;
        this.writer.interrupt();
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.initialized) {
            return;
        }
        if (this.closed) {
            return;
        }
        this.socket.close();
        this.writer.interrupt();
        try {
            while (this.writer.isAlive()) {
                Thread.sleep(50L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.closed = true;
        this.socket = null;
    }

    private int nextPacketIndex(int packetIndex) {
        if (++packetIndex == 100) {
            packetIndex = 0;
        }
        return packetIndex;
    }

    static /* synthetic */ Semaphore access$0(UDPOutputStream uDPOutputStream) {
        return uDPOutputStream.smfFilledPackets;
    }

    static /* synthetic */ int access$1(UDPOutputStream uDPOutputStream) {
        return uDPOutputStream.flushBufferPeriod_ms;
    }

    static /* synthetic */ Object access$2(UDPOutputStream uDPOutputStream) {
        return uDPOutputStream.sync;
    }

    static /* synthetic */ int[] access$3(UDPOutputStream uDPOutputStream) {
        return uDPOutputStream.dataLen;
    }

    static /* synthetic */ int access$4(UDPOutputStream uDPOutputStream) {
        return uDPOutputStream.outPacket;
    }

    static /* synthetic */ int access$5(UDPOutputStream uDPOutputStream) {
        return uDPOutputStream.inDataOffset;
    }

    static /* synthetic */ void access$6(UDPOutputStream uDPOutputStream, int n) {
        uDPOutputStream.inDataOffset = n;
    }

    static /* synthetic */ byte[][] access$7(UDPOutputStream uDPOutputStream) {
        return uDPOutputStream.packetData;
    }

    static /* synthetic */ SocketAddress access$8(UDPOutputStream uDPOutputStream) {
        return uDPOutputStream.socketAddress;
    }

    static /* synthetic */ DatagramSocket access$9(UDPOutputStream uDPOutputStream) {
        return uDPOutputStream.socket;
    }

    static /* synthetic */ int access$10(UDPOutputStream uDPOutputStream, int n) {
        return uDPOutputStream.nextPacketIndex(n);
    }

    static /* synthetic */ void access$11(UDPOutputStream uDPOutputStream, int n) {
        uDPOutputStream.outPacket = n;
    }

    static /* synthetic */ Semaphore access$12(UDPOutputStream uDPOutputStream) {
        return uDPOutputStream.smfEmptyPackets;
    }

    static /* synthetic */ void access$13(UDPOutputStream uDPOutputStream, boolean bl) {
        uDPOutputStream.packetWriterSentTerminated = bl;
    }

    private class UDPDatagramWriter
    extends Thread {
        private long bytesOutputSoFar;

        UDPDatagramWriter() {
            super("DatagramWriter");
            this.bytesOutputSoFar = 0L;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

