/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.compression;

import edu.uml.lgdc.fileio.FileUtils;
import edu.uml.lgdc.project.Console;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Pattern;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public abstract class Zip {
    public static void unzip(File file) throws IOException {
        Zip.unzip(file, new File("."));
    }

    public static void unzip(File file, File unzipDir) throws IOException {
        Zip.unzip(file, unzipDir, null);
    }

    public static void unzip(File file, File unzipDir, Pattern pattern) throws IOException {
        boolean result = false;
        FileInputStream input = null;
        ZipInputStream zInputStream = null;
        OutputStream os = null;
        File f = null;
        try {
            ZipEntry entry;
            input = new FileInputStream(file);
            zInputStream = new ZipInputStream(input);
            while ((entry = zInputStream.getNextEntry()) != null) {
                String filename = entry.getName();
                f = null;
                if (new File(unzipDir, filename).equals(unzipDir)) {
                    if (filename.trim().length() == 0) {
                        throw new ZipException("empty file/directory name");
                    }
                    throw new ZipException("bad file/directory name: " + filename);
                }
                f = new File(unzipDir, filename);
                if (!entry.isDirectory()) {
                    if (pattern != null && !pattern.matcher(filename).matches()) continue;
                    f.delete();
                    try {
                        os = new FileOutputStream(f);
                    }
                    catch (FileNotFoundException ex) {
                        f.getParentFile().mkdirs();
                        os = new FileOutputStream(f);
                    }
                    FileUtils.iStream2oStream(zInputStream, os);
                    os.close();
                    f.setLastModified(entry.getTime());
                    continue;
                }
                f.mkdirs();
            }
            result = true;
        }
        finally {
            if (zInputStream != null) {
                try {
                    zInputStream.close();
                }
                catch (IOException ex) {
                    Console.printThreadStackTrace(ex);
                }
            } else if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException ex) {
                    Console.printThreadStackTrace(ex);
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ex) {
                    Console.printThreadStackTrace(ex);
                }
                if (!result && f != null) {
                    f.delete();
                }
            }
        }
    }

    public static void gunzip(File file) throws IOException {
        String name = file.getName();
        if (!name.toUpperCase().endsWith(".GZ")) {
            throw new IOException("input file, " + file + ", does not have .gz extension");
        }
        File unzip = new File(name.substring(0, name.length() - 3));
        Zip.gunzip(file, unzip);
    }

    public static void gunzip(File file, File unzip) throws IOException {
        FileInputStream input = null;
        GZIPInputStream gzInputStream = null;
        OutputStream os = null;
        try {
            input = new FileInputStream(file);
            gzInputStream = new GZIPInputStream(input);
            os = new FileOutputStream(unzip);
            FileUtils.iStream2oStream(gzInputStream, os);
            os.close();
        }
        finally {
            if (gzInputStream != null) {
                try {
                    gzInputStream.close();
                }
                catch (IOException ex) {
                    Console.printThreadStackTrace(ex);
                }
            } else if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException ex) {
                    Console.printThreadStackTrace(ex);
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ex) {
                    Console.printThreadStackTrace(ex);
                }
            }
        }
    }

    public static void gzip(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file is null");
        }
        Zip.gzip(file, new File(String.valueOf(file.getPath()) + ".gz"));
    }

    public static void gzip(File file, File gzipFile) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file is null");
        }
        if (gzipFile == null) {
            throw new IllegalArgumentException("gzipFile is null");
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file + " not found");
        }
        if (!file.isFile()) {
            throw new IOException(file + " is not a file");
        }
        if (gzipFile.exists()) {
            if (gzipFile.isFile()) {
                gzipFile.delete();
            } else {
                throw new IOException(gzipFile + " already exists and not a file");
            }
        }
        InputStream input = null;
        FileOutputStream output = null;
        DeflaterOutputStream gzipos = null;
        boolean ok = false;
        try {
            output = new FileOutputStream(gzipFile);
            gzipos = new GZIPOutputStream(output);
            input = new BufferedInputStream(new FileInputStream(file), 10000);
            FileUtils.iStream2oStream(input, gzipos);
            ok = true;
        }
        finally {
            if (gzipos != null) {
                try {
                    gzipos.close();
                }
                catch (IOException ex) {
                    Console.printThreadStackTrace(ex);
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException ex) {
                        Console.printThreadStackTrace(ex);
                    }
                }
                if (!ok) {
                    gzipFile.delete();
                }
            } else if (output != null) {
                try {
                    ((OutputStream)output).close();
                }
                catch (IOException ex) {
                    Console.printThreadStackTrace(ex);
                }
            }
        }
    }

    public static void zip(File file, File zipFile) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file is null");
        }
        if (zipFile == null) {
            throw new IllegalArgumentException("zipFile is null");
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file + " not found");
        }
        if (!file.isFile() && !file.isDirectory()) {
            throw new IOException(file + " is not file or directory");
        }
        if (zipFile.exists()) {
            if (zipFile.isFile()) {
                if (!zipFile.delete()) {
                    throw new IOException("can't delete file " + zipFile);
                }
            } else {
                throw new IOException(zipFile + " already exists and not a file");
            }
        }
        if (FileUtils.containsOrEqual(file, zipFile)) {
            throw new IOException(zipFile + " belongs/equals to directory/file " + file + ", recursion prohibited");
        }
        FileOutputStream output = null;
        ZipOutputStream zipos = null;
        boolean ok = false;
        File tmpZipFile = new File(zipFile + ".part");
        if (tmpZipFile.exists()) {
            if (tmpZipFile.isFile()) {
                if (!tmpZipFile.delete()) {
                    throw new IOException("can't delete file " + tmpZipFile);
                }
            } else {
                throw new IOException(tmpZipFile + " already exists and not a file");
            }
        }
        try {
            output = new FileOutputStream(tmpZipFile);
            zipos = new ZipOutputStream(output);
            Zip.zip(file, zipos);
            ok = true;
        }
        finally {
            if (zipos != null) {
                try {
                    zipos.close();
                }
                catch (IOException ex) {
                    Console.printThreadStackTrace(ex);
                }
                if (ok && !tmpZipFile.renameTo(zipFile)) {
                    throw new IOException("cannot rename " + tmpZipFile + " to " + zipFile);
                }
            } else if (output != null) {
                try {
                    ((OutputStream)output).close();
                }
                catch (IOException ex) {
                    Console.printThreadStackTrace(ex);
                }
            }
            if (!ok) {
                tmpZipFile.delete();
            }
        }
    }

    public static void zip(File[] files, File zipFile, String prependedPath) throws IOException {
        if (files == null) {
            throw new IllegalArgumentException("files == null");
        }
        if (files.length == 0) {
            throw new IllegalArgumentException("files.length == 0");
        }
        int i = 0;
        while (i < files.length) {
            if (files[i] == null) {
                throw new IllegalArgumentException("files[" + i + "] == null");
            }
            if (!files[i].isFile() && !files[i].isDirectory()) {
                throw new IOException("files[" + i + "] is not file or directory, " + files[i]);
            }
            if (FileUtils.containsOrEqual(files[i], zipFile)) {
                throw new IOException(zipFile + " belongs/equals to directory/file files[" + i + "], " + files[i] + ", recursion prohibited");
            }
            ++i;
        }
        if (zipFile.exists()) {
            if (zipFile.isFile()) {
                if (!zipFile.delete()) {
                    throw new IOException("can't delete file " + zipFile);
                }
            } else {
                throw new IOException(zipFile + " already exists and not a file");
            }
        }
        FileOutputStream output = null;
        ZipOutputStream zipos = null;
        boolean ok = false;
        File tmpZipFile = new File(zipFile + ".part");
        if (tmpZipFile.exists()) {
            if (tmpZipFile.isFile()) {
                if (!tmpZipFile.delete()) {
                    throw new IOException("can't delete file " + tmpZipFile);
                }
            } else {
                throw new IOException(tmpZipFile + " already exists and not a file");
            }
        }
        try {
            output = new FileOutputStream(tmpZipFile);
            zipos = new ZipOutputStream(output);
            Zip.zip(files, zipos, prependedPath);
            ok = true;
        }
        finally {
            if (zipos != null) {
                try {
                    zipos.close();
                }
                catch (IOException ex) {
                    Console.printThreadStackTrace(ex);
                }
                if (ok && !tmpZipFile.renameTo(zipFile)) {
                    throw new IOException("cannot rename " + tmpZipFile + " to " + zipFile);
                }
            } else if (output != null) {
                try {
                    ((OutputStream)output).close();
                }
                catch (IOException ex) {
                    Console.printThreadStackTrace(ex);
                }
            }
            if (!ok) {
                tmpZipFile.delete();
            }
        }
    }

    public static void zip(File[] files, ZipOutputStream zipos, String prependedPath) throws IOException {
        if (files == null) {
            throw new IllegalArgumentException("files == null");
        }
        if (files.length == 0) {
            throw new IllegalArgumentException("files.length == 0");
        }
        if (zipos == null) {
            throw new IllegalArgumentException("zipos == null");
        }
        int i = 0;
        while (i < files.length) {
            if (files[i] == null) {
                throw new IllegalArgumentException("files[" + i + "] == null");
            }
            if (!files[i].isFile() && !files[i].isDirectory()) {
                throw new IOException("files[" + i + "] is not file or directory, " + files[i]);
            }
            ++i;
        }
        if (prependedPath == null || prependedPath.equals(".")) {
            prependedPath = "";
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (prependedPath.length() != 0) {
                Zip.zipRecursion(file, zipos, String.valueOf(prependedPath) + File.separator + file.getName());
            } else {
                Zip.zipRecursion(file, zipos, file.getName());
            }
            ++n2;
        }
    }

    public static void zip(File file, ZipOutputStream zipos) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file is null");
        }
        if (zipos == null) {
            throw new IllegalArgumentException("zipos is null");
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file + " not found");
        }
        if (!file.isFile() && !file.isDirectory()) {
            throw new IOException(file + " is not file or directory");
        }
        String relPathname = file.getName();
        if (relPathname.equals(".")) {
            relPathname = "";
        }
        Zip.zipRecursion(file, zipos, relPathname);
    }

    private static void zipRecursion(File file, ZipOutputStream zipos, String relPathname) throws IOException {
        InputStream is = null;
        try {
            if (file.isDirectory()) {
                String[] list;
                if (!relPathname.equals("")) {
                    ZipEntry zipEntry = new ZipEntry(String.valueOf(relPathname) + "/");
                    zipos.putNextEntry(zipEntry);
                }
                String[] stringArray = list = file.list();
                int n = list.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    if (!name.equals(".")) {
                        if (relPathname.length() != 0) {
                            Zip.zipRecursion(new File(file, name), zipos, String.valueOf(relPathname) + File.separator + name);
                        } else {
                            Zip.zipRecursion(new File(file, name), zipos, name);
                        }
                    }
                    ++n2;
                }
            } else {
                ZipEntry zipEntry = new ZipEntry(relPathname);
                zipEntry.setTime(file.lastModified());
                zipEntry.setSize(file.length());
                zipos.putNextEntry(zipEntry);
                is = new FileInputStream(file);
                FileUtils.iStream2oStream(is, zipos);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    Console.printThreadStackTrace(ex);
                }
            }
        }
    }
}

