/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.dashboard;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class ByteBufferUtil {
    public ByteBuffer pushOntoByteBuffer(byte value, ByteBuffer existingBuffer) {
        ByteBuffer newBuffer = ByteBuffer.allocate(8 + existingBuffer.limit());
        newBuffer.put(existingBuffer);
        newBuffer.put(value);
        newBuffer.rewind();
        return newBuffer;
    }

    public ByteBuffer pushOntoByteBuffer(byte[] byteArray, ByteBuffer existingBuffer) {
        ByteBuffer newBuffer = ByteBuffer.allocate(byteArray.length + existingBuffer.limit());
        newBuffer.put(existingBuffer);
        newBuffer.put(byteArray);
        newBuffer.rewind();
        return newBuffer;
    }

    public ByteBuffer pushOntoByteBuffer(ByteBuffer buffer, ByteBuffer existingBuffer) {
        ByteBuffer newBuffer = ByteBuffer.allocate(buffer.limit() + existingBuffer.limit());
        newBuffer.put(existingBuffer);
        newBuffer.put(buffer);
        newBuffer.rewind();
        return newBuffer;
    }

    public ByteBuffer pushOntoByteBuffer(byte[] byteArray, int numOfBytes, ByteBuffer existingBuffer) {
        ByteBuffer newBuffer = ByteBuffer.allocate(numOfBytes + existingBuffer.limit());
        newBuffer.put(existingBuffer);
        int i = 0;
        while (i < numOfBytes) {
            newBuffer.put(byteArray[i]);
            ++i;
        }
        newBuffer.rewind();
        return newBuffer;
    }

    public ByteBuffer pushOntoByteBuffer(long value, ByteBuffer existingBuffer) {
        ByteBuffer newBuffer = ByteBuffer.allocate(8 + existingBuffer.limit());
        newBuffer.put(existingBuffer);
        newBuffer.putLong(value);
        newBuffer.rewind();
        return newBuffer;
    }

    public ByteBuffer pushOntoByteBuffer(int value, ByteBuffer existingBuffer) {
        ByteBuffer newBuffer = ByteBuffer.allocate(4 + existingBuffer.limit());
        newBuffer.put(existingBuffer);
        newBuffer.putInt(value);
        newBuffer.rewind();
        return newBuffer;
    }

    public ByteBuffer pushOntoByteBuffer(String string, Charset charset, ByteBuffer existingBuffer) {
        ByteBuffer stringLength = this.pushOntoByteBuffer(string.length(), existingBuffer);
        ByteBuffer stringBuffer = ByteBuffer.wrap(string.getBytes(charset));
        ByteBuffer newBuffer = ByteBuffer.allocate(stringBuffer.limit() + stringLength.limit());
        newBuffer.put(stringLength);
        newBuffer.put(stringBuffer);
        newBuffer.rewind();
        return newBuffer;
    }

    public ByteBuffer pushOntoByteBuffer(boolean value, ByteBuffer existingBuffer) {
        ByteBuffer newBuffer = ByteBuffer.allocate(1 + existingBuffer.limit());
        newBuffer.put(existingBuffer);
        byte byteValue = value ? (byte)1 : 0;
        newBuffer.put(byteValue);
        newBuffer.rewind();
        return newBuffer;
    }

    public byte popByteFromBuffer(ByteBuffer buffer) {
        byte value = buffer.get();
        return value;
    }

    public byte[] popByteArrayFromBuffer(int byteArraySize, ByteBuffer buffer) {
        byte[] byteArray = new byte[byteArraySize];
        if (buffer.limit() >= byteArraySize) {
            buffer.get(byteArray);
        }
        return byteArray;
    }

    public byte[] popRemainingAsByteArray(ByteBuffer buffer) {
        int byteArraySize = buffer.limit() - buffer.position();
        byte[] byteArray = new byte[byteArraySize];
        buffer.get(byteArray);
        return byteArray;
    }

    public long popLongFromBuffer(ByteBuffer buffer) {
        Long value = buffer.getLong();
        return value;
    }

    public int popIntFromBuffer(ByteBuffer buffer) {
        int value = buffer.getInt();
        return value;
    }

    public String popStringFromBuffer(ByteBuffer buffer) {
        int stringLength = this.popIntFromBuffer(buffer);
        byte[] byteArray = new byte[stringLength];
        buffer.get(byteArray, 0, stringLength);
        return new String(byteArray);
    }

    public boolean popBoolFromBuffer(ByteBuffer buffer) {
        byte value = buffer.get();
        return value == 1;
    }
}

