/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.dashboard;

import edu.uml.lgdc.instrument.Payload;
import edu.uml.lgdc.multithread.MSQueue;
import edu.uml.lgdc.project.Console;

public class PayloadAck
extends Payload {
    private final int TYPE = 84;
    private final int LENGTH = 1;
    private byte ackType;
    private String className = this.getClass().getSimpleName();

    public PayloadAck(byte dashboardPayloadAckType) {
        this.setPayloadAckType(dashboardPayloadAckType);
        Boolean toBeSent = false;
        this.setPayload(84, 1, new byte[]{this.ackType}, toBeSent);
        this.setSpecificPacketTypeParam(this.name, 1, 1);
    }

    public PayloadAck(byte[] data, int length) {
        if (length == 1) {
            this.ackType = data[0];
        }
        this.setPayloadAckType(this.ackType);
        Boolean toBeSent = false;
        this.setPayload(84, 1, new byte[]{this.ackType}, toBeSent);
        this.setSpecificPacketTypeParam(this.name, 1, 1);
    }

    private void setPayloadAckType(byte dashboardPayloadAckType) {
        switch (dashboardPayloadAckType) {
            case 2: {
                this.name = "AckRcvGetStatus";
                break;
            }
            case 5: {
                this.name = "AckRcvStateAuto";
                break;
            }
            case 4: {
                this.name = "AckRcvStateDiag";
                break;
            }
            case 6: {
                this.name = "AckRcvStop";
                break;
            }
            case 7: {
                this.name = "AckRcvRunProg";
            }
        }
        this.ackType = dashboardPayloadAckType;
    }

    public byte getAckType() {
        return this.ackType;
    }

    @Override
    public void handle(MSQueue dashboardCoreQueue) throws InterruptedException {
        this.check();
        this.process();
        if (dashboardCoreQueue != null) {
            dashboardCoreQueue.post(this);
        }
    }

    @Override
    public int check() {
        this.error = 0;
        this.errMsg = null;
        if (this.length < this.minTypeLength || this.maxTypeLength != -1 && this.length > this.maxTypeLength) {
            this.error = 2;
            this.errMsg = ERR_MES[this.error];
            this.errMsg = this.maxTypeLength == -1 ? String.valueOf(this.errMsg) + ", should be >= " + this.minTypeLength + ", but is " + this.length : String.valueOf(this.errMsg) + ", should be between " + this.minTypeLength + " and " + this.maxTypeLength + ", but is " + this.length;
            return this.error;
        }
        return this.error;
    }

    @Override
    public void process() {
        if (this.error == 0) {
            return;
        }
        this.showError();
    }

    protected void showError() {
        Console.showError(String.valueOf(this.getInfoStart()) + "bad " + this.name + " packet, " + "\n" + "Error: " + this.getErrText());
    }
}

