/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.database;

import java.text.ParseException;
import java.util.Objects;

public class ConnectionRequisites {
    public static final String NONE_STR = "NONE";
    private final String title;
    private final String protocol;
    private final String host;
    private final String filename;
    private final String username;
    private final String pass;
    private final String role;
    private final String driverClassName;

    public ConnectionRequisites(String title, String protocol, String host, String filename, String username, String pass, String role, String driverClassName) {
        this.title = Objects.requireNonNull(title);
        this.protocol = Objects.requireNonNull(protocol).trim();
        this.host = Objects.requireNonNull(host).trim();
        this.filename = Objects.requireNonNull(filename).trim();
        this.username = Objects.requireNonNull(username).trim();
        this.pass = Objects.requireNonNull(pass);
        this.role = role;
        this.driverClassName = Objects.requireNonNull(driverClassName).trim();
    }

    public ConnectionRequisites(String title, String url, String username, String pass, String role, String driverClassName) throws ParseException {
        this.title = Objects.requireNonNull(title);
        String[] parts = ConnectionRequisites.parseURL(Objects.requireNonNull(url));
        this.protocol = parts[0];
        this.host = parts[1];
        this.filename = parts[2];
        this.username = Objects.requireNonNull(username).trim();
        this.pass = Objects.requireNonNull(pass);
        this.role = role;
        this.driverClassName = Objects.requireNonNull(driverClassName).trim();
    }

    public static ConnectionRequisites createConnectItem(String title, String url, String username, String pass, String role, String driverClassName) {
        try {
            return new ConnectionRequisites(title, url, username, pass, role, driverClassName);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPass() {
        return this.pass;
    }

    public String getRole() {
        return this.role;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getURL() {
        String databaseURL = String.valueOf(this.protocol) + "://" + this.host + "/" + this.filename;
        String modifiers = "";
        if (this.protocol.contains("firebird") && this.role != null && !this.role.isEmpty()) {
            modifiers = "?sql_role_name=" + this.role;
        }
        return String.valueOf(databaseURL) + modifiers;
    }

    private static String[] parseURL(String url) throws ParseException {
        url = url.trim();
        String[] parts = new String[3];
        int pos = url.indexOf("://");
        if (pos < 0) {
            throw new ParseException("protocol not found in url, " + url, 0);
        }
        parts[0] = url.substring(0, pos);
        if (parts[0].length() == 0 || parts[0].contains(" ")) {
            throw new ParseException("illegal protocol in url, " + url, 0);
        }
        if ((pos = (url = url.substring(pos + 3)).indexOf(47)) < 0) {
            throw new ParseException("host not found in url, " + url, 0);
        }
        parts[1] = url.substring(0, pos);
        if (parts[1].length() == 0 || parts[1].contains(" ")) {
            throw new ParseException("illegal host in url, " + url, 0);
        }
        parts[2] = url.substring(pos + 1);
        if (parts[2].length() == 0 || parts[2].contains(" ")) {
            throw new ParseException("illegal filename in url, " + url, 0);
        }
        return parts;
    }

    public boolean isEmpty() {
        return this.host.isEmpty();
    }

    public static ConnectionRequisites createEmpty() {
        return new ConnectionRequisites(NONE_STR, "", "", "", "", "", "", "");
    }

    public static ConnectionRequisites parse(String connectItemAsStr) {
        String driver;
        String role;
        String pass;
        String user;
        String filename;
        String host;
        String protocol;
        assert (connectItemAsStr != null);
        String[] parts = (connectItemAsStr = connectItemAsStr.trim()).split(",");
        if (parts.length < 3) {
            return ConnectionRequisites.createEmpty();
        }
        String title = parts[0].trim();
        if (parts.length <= 6) {
            String[] urlParts;
            try {
                urlParts = ConnectionRequisites.parseURL(parts[1]);
            }
            catch (ParseException ex) {
                String protocol2 = parts[1].trim();
                String host2 = parts[2].trim();
                String filename2 = parts[3].trim();
                String user2 = parts[4].trim();
                String pass2 = parts.length < 6 ? "" : parts[5].trim();
                String role2 = "";
                String driver2 = "";
                return new ConnectionRequisites(title, protocol2, host2, filename2, user2, pass2, role2, driver2);
            }
            protocol = urlParts[0];
            host = urlParts[1];
            filename = urlParts[2];
            user = parts[2].trim();
            pass = parts.length < 4 ? "" : parts[3].trim();
            role = parts.length < 5 ? "" : parts[4].trim();
            driver = parts.length < 6 ? "" : parts[5].trim();
        } else {
            protocol = parts[1].trim();
            host = parts[2].trim();
            filename = parts[3].trim();
            user = parts[4].trim();
            pass = parts.length < 6 ? "" : parts[5].trim();
            role = parts.length < 7 ? "" : parts[6].trim();
            driver = parts.length < 8 ? "" : parts[7].trim();
        }
        return new ConnectionRequisites(title, protocol, host, filename, user, pass, role, driver);
    }

    public StringBuilder append(StringBuilder sb) {
        return sb.append(this.title).append(',').append(this.protocol).append(',').append(this.host).append(',').append(this.filename).append(',').append(this.username).append(',').append(this.pass).append(',').append(this.role).append(',').append(this.driverClassName);
    }

    public String toString() {
        return this.append(new StringBuilder(128)).toString();
    }

    public boolean isFirebird() {
        return this.driverClassName.contains("firebird");
    }
}

