/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.database;

import com.mysql.cj.conf.PropertyDefinitions;
import edu.uml.lgdc.appuserdb.api.LgdcRegistry;
import edu.uml.lgdc.database.ConnectionRequisites;
import edu.uml.lgdc.database.SPColumn;
import edu.uml.lgdc.database.SPColumnType;
import edu.uml.lgdc.database.StoredProcedure;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.time.TimeScale;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverManagerConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDriver;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;

public class DBConnect
implements AutoCloseable {
    private static final String URL_SQL_ROLE_NAME = "sql_role_name";
    public static final String JAYBIRD_DRIVER = "org.firebirdsql.jdbc.FBDriver";
    public static final String ROLE_NAME_COMMON = "COMMON";
    public static final String POOLING_DRIVER = "jdbc:apache:commons:dbcp:";
    public static final int DBERROR_QUIT = 1;
    public static final int DBERROR_LOOP = 2;
    public static final int DBERROR_RETRY_ONCE_AND_QUIT = 3;
    public static final int DBERROR_RETRY_100_AND_CRASH = 4;
    public static final int DBERROR_CRASH = 5;
    protected ConnectionRequisites requisites;
    protected long allContents;
    protected int databaseId;
    private Class driverClass;
    private GenericObjectPool connectionPool = null;
    private ConnectionFactory connectionFactory = null;
    private PoolableConnectionFactory poolFactory = null;
    private Class dbcpDriverClass;
    private PoolingDriver dbcpDriver = null;
    private String dbcpPoolName;
    protected Connection connection;
    public static final int METADATA_TABLES = 1;
    public static final int METADATA_PROCEDURES = 2;
    public static final int METADATA_INDICES = 4;
    protected DatabaseMetaData dbMetaData;
    protected HashSet<String> tables;
    protected Map<String, StoredProcedure> procedures;
    protected Map<String, HashMap<String, ArrayList<String>>> indices;

    public DBConnect(ConnectionRequisites requisites, long allContents, int databaseId) {
        this.setRequisites(requisites);
        try {
            this.driverClass = Class.forName(requisites.getDriverClassName());
            Properties props = new Properties();
            props.put("user", requisites.getUsername());
            props.put("password", requisites.getPass());
            if (requisites.getProtocol().contains("mysql")) {
                props.put("sslMode", PropertyDefinitions.SslMode.DISABLED);
            }
            props.put("lc_ctype", "NONE");
            this.connectionFactory = new DriverManagerConnectionFactory(requisites.getURL(), props);
            this.poolFactory = new PoolableConnectionFactory(this.connectionFactory, null);
            this.connectionPool = new GenericObjectPool((PooledObjectFactory)this.poolFactory);
            this.poolFactory.setPool((ObjectPool)this.connectionPool);
            this.poolFactory.setMaxConnLifetimeMillis(3600000L);
            this.dbcpDriverClass = Class.forName("org.apache.commons.dbcp2.PoolingDriver");
            this.dbcpDriver = (PoolingDriver)DriverManager.getDriver(POOLING_DRIVER);
            TimeUnit.MILLISECONDS.sleep(10L);
            this.dbcpPoolName = "dbcp-lgdc-" + new TimeScale().toFormatISO8601();
            this.dbcpDriver.registerPool(this.dbcpPoolName, (ObjectPool)this.connectionPool);
            Console.showMsg("Connection pool " + this.dbcpPoolName + " for " + requisites.getTitle() + " is now available.");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setAllContents(allContents);
        this.setDatabaseId(databaseId);
    }

    public DBConnect getInstance() {
        return new DBConnect(this.requisites, this.allContents, this.databaseId);
    }

    public void setRequisites(ConnectionRequisites r) {
        this.requisites = r;
    }

    public ConnectionRequisites getRequisites() {
        return this.requisites;
    }

    public void setAllContents(long contents) {
        this.allContents = contents;
    }

    public long getAllContents() {
        return this.allContents;
    }

    public void setDatabaseId(int databaseId) {
        this.databaseId = databaseId;
    }

    public int getDatabaseId() {
        return this.databaseId;
    }

    public boolean sameContents(long contents) {
        return this.allContents == contents;
    }

    public boolean sameRequisites(ConnectionRequisites r) {
        return r.equals(this.requisites);
    }

    public boolean equals(DBConnect connect) {
        return this.equals(connect.requisites, connect.allContents);
    }

    public boolean equals(ConnectionRequisites req, long cont) {
        return this.sameContents(cont) && this.sameRequisites(req);
    }

    public synchronized Connection getConnection() throws SQLException {
        boolean noMoreWaitMessage = false;
        int attemptCount = 0;
        int smallInterval_sec = 5;
        int bigInterval_sec = 60;
        int short_wait_sec = 5;
        int long_wait_sec = 20;
        int secondsCounter = 0;
        String failedText = "Connection to database " + this.requisites.getURL() + " in the " + this.requisites.getRole() + " role failed";
        block17: while (true) {
            try {
                this.connection = DriverManager.getConnection(POOLING_DRIVER + this.dbcpPoolName);
                return this.connection;
            }
            catch (SQLException e) {
                if (this.connection != null) {
                    this.connection.close();
                }
                switch (LgdcRegistry.getDbErrorHandlingMode()) {
                    case 3: {
                        if (!noMoreWaitMessage) {
                            noMoreWaitMessage = true;
                            try {
                                Thread.sleep(short_wait_sec * 1000);
                            }
                            catch (InterruptedException e1) {
                                e1.printStackTrace();
                            }
                            continue block17;
                        }
                        failedText = String.valueOf(failedText) + " twice";
                    }
                    case 1: {
                        Console.showError(String.valueOf(failedText) + "... no connection possible. Quitting the attempts to connect.");
                        throw new SQLException(e);
                    }
                    case 4: {
                        if (attemptCount++ < 100) {
                            Console.showError("Connection failed, will retry again in " + long_wait_sec + " sec; attempt #" + attemptCount);
                            try {
                                Thread.sleep(long_wait_sec * 1000);
                            }
                            catch (InterruptedException e1) {
                                e1.printStackTrace();
                            }
                            continue block17;
                        }
                    }
                    case 5: {
                        Console.showError(String.valueOf(failedText) + "... no connection possible. The application will crash.");
                        LgdcRegistry.releaseAllResources();
                        System.exit(-999);
                    }
                    case 2: {
                        Console.showError(String.valueOf(failedText) + "... connection attempts will continue every " + short_wait_sec + " sec");
                        if ((secondsCounter += short_wait_sec) < 60) {
                            try {
                                Thread.sleep(short_wait_sec * 1000);
                                continue block17;
                            }
                            catch (InterruptedException e1) {
                                throw new SQLException(String.valueOf(failedText) + "... restoring attempts interrupted.");
                            }
                        }
                        Console.showError("Pausing the reconnection attempts... will try again in 60 sec");
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (InterruptedException e1) {
                            throw new SQLException(String.valueOf(failedText) + "... restoring attempts interrupted.");
                        }
                        secondsCounter = 0;
                        continue block17;
                    }
                }
                throw new RuntimeException("Database connection impossible for unknown reason");
            }
            break;
        }
    }

    public boolean isConnected() {
        boolean connected = false;
        if (this.connection != null) {
            try {
                connected = !this.connection.isClosed();
            }
            catch (SQLException e) {
                System.out.println(e.toString());
            }
        }
        return connected;
    }

    public String getUser() {
        return this.requisites.getUsername();
    }

    public boolean isCommonRole() {
        return this.requisites.getRole().equals(ROLE_NAME_COMMON);
    }

    public Statement createStatement() throws SQLException {
        if (this.connection != null) {
            return this.connection.createStatement();
        }
        return null;
    }

    public PreparedStatement prepareStatement(String sqlString) throws SQLException {
        if (this.connection != null) {
            return this.connection.prepareStatement(sqlString);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runSQLScript(String filename) throws SQLException, IOException {
        String sep = ";";
        int sepLen = sep.length();
        boolean endOfSQLStr = false;
        boolean eof = false;
        Throwable throwable = null;
        Object var8_8 = null;
        try {
            Statement st = this.connection.createStatement();
            try {
                try (BufferedReader in = new BufferedReader(new FileReader(filename), 4000);){
                    while (in.ready()) {
                        String line = in.readLine();
                        if (line == null) {
                            eof = true;
                            endOfSQLStr = true;
                        } else if ((line = line.trim()).substring(line.length() - sepLen, line.length()).equals(sep)) {
                            line = line.substring(0, line.length() - sepLen);
                            line = line.trim();
                            endOfSQLStr = true;
                        }
                        if (endOfSQLStr) {
                            if (!line.equals("")) {
                                if (line.toUpperCase().startsWith("SET ") && line.substring(4).toUpperCase().startsWith("TERM ")) {
                                    sep = line.substring(4).trim();
                                    sep = sep.substring(5).trim();
                                    sepLen = sep.length();
                                } else if (line.toUpperCase().startsWith("SELECT ")) {
                                    st.executeQuery(line);
                                } else if (line.toUpperCase().startsWith("UPDATE ") || line.toUpperCase().startsWith("INSERT ") || line.toUpperCase().startsWith("DELETE ")) {
                                    st.executeUpdate(line);
                                } else if (line.trim().toUpperCase().equals("COMMIT")) {
                                    this.connection.commit();
                                } else if (line.trim().toUpperCase().equals("ROLLBACK")) {
                                    this.connection.rollback();
                                } else {
                                    st.execute(line);
                                }
                            }
                            endOfSQLStr = false;
                        }
                        if (!eof) continue;
                        break;
                    }
                }
                if (st == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (st == null) throw throwable;
                st.close();
                throw throwable;
            }
            st.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public void readMetadata(int requiredMatadataSelection) {
        block55: {
            if (requiredMatadataSelection == 0) {
                return;
            }
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (Connection metadataConnect = DriverManager.getConnection(POOLING_DRIVER + this.dbcpPoolName);){
                    Object procName;
                    ResultSet rs;
                    Object var6_13;
                    this.dbMetaData = metadataConnect.getMetaData();
                    if ((requiredMatadataSelection & 5) != 0) {
                        this.tables = new HashSet();
                        try {
                            Throwable throwable2 = null;
                            var6_13 = null;
                            try {
                                rs = this.dbMetaData.getTables(null, null, null, new String[]{"TABLE"});
                                try {
                                    while (rs.next()) {
                                        String name = rs.getString("TABLE_NAME").toUpperCase();
                                        this.tables.add(name);
                                    }
                                }
                                finally {
                                    if (rs != null) {
                                        rs.close();
                                    }
                                }
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                        }
                        catch (SQLException e) {
                            System.out.println("Error during reading database table names");
                            e.printStackTrace();
                        }
                    }
                    if ((requiredMatadataSelection & 2) != 0) {
                        this.procedures = new HashMap<String, StoredProcedure>();
                        try {
                            Throwable e = null;
                            var6_13 = null;
                            try {
                                rs = this.dbMetaData.getProcedureColumns(null, null, null, null);
                                try {
                                    while (rs.next()) {
                                        procName = rs.getString("PROCEDURE_NAME");
                                        String colName = rs.getString("COLUMN_NAME");
                                        short type = rs.getShort("COLUMN_TYPE");
                                        int sqlType = rs.getInt("DATA_TYPE");
                                        SPColumn column = new SPColumn(colName, SPColumnType.get(type), sqlType);
                                        StoredProcedure sp = this.procedures.get(procName);
                                        if (sp == null) {
                                            ArrayList<SPColumn> list = new ArrayList<SPColumn>();
                                            list.add(column);
                                            this.procedures.put(((String)procName).toUpperCase(), new StoredProcedure((String)procName, list));
                                            continue;
                                        }
                                        sp.addColumn(column);
                                    }
                                }
                                finally {
                                    if (rs != null) {
                                        rs.close();
                                    }
                                }
                            }
                            catch (Throwable throwable4) {
                                if (e == null) {
                                    e = throwable4;
                                } else if (e != throwable4) {
                                    e.addSuppressed(throwable4);
                                }
                                throw e;
                            }
                        }
                        catch (SQLException e) {
                            System.out.println("Error during reading database procedure names");
                            e.printStackTrace();
                        }
                    }
                    if ((requiredMatadataSelection & 1) == 0) break block55;
                    this.indices = new HashMap<String, HashMap<String, ArrayList<String>>>();
                    for (String table : this.tables) {
                        HashMap tableIndices = new HashMap();
                        try {
                            procName = null;
                            Object var9_20 = null;
                            try (ResultSet rs2 = this.dbMetaData.getIndexInfo(null, null, table, false, false);){
                                ResultSetMetaData rsmd = rs2.getMetaData();
                                int cols = rsmd.getColumnCount();
                                ArrayList<String> columns = new ArrayList<String>(cols);
                                while (rs2.next()) {
                                    int i = 1;
                                    while (i >= cols) {
                                        columns.add(rsmd.getColumnName(i));
                                        ++i;
                                    }
                                    tableIndices.put(rs2.getString("INDEX_NAME"), columns);
                                }
                            }
                            catch (Throwable throwable5) {
                                if (procName == null) {
                                    procName = throwable5;
                                } else if (procName != throwable5) {
                                    ((Throwable)procName).addSuppressed(throwable5);
                                }
                                throw procName;
                            }
                        }
                        catch (SQLException e) {
                            System.out.println("Error during reading database table names");
                            e.printStackTrace();
                        }
                        this.indices.put(table, tableIndices);
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                System.out.println("Error opening connection to metadata");
                e.printStackTrace();
            }
        }
    }

    public boolean isTableExist(String tableName) {
        return this.tables == null ? false : this.tables.contains(tableName.toUpperCase());
    }

    public boolean isProcedureExist(String procedureName) {
        return this.procedures == null ? false : this.procedures.get(procedureName.toUpperCase()) != null;
    }

    public StoredProcedure getProcedure(String procedureName) {
        return this.procedures == null ? null : this.procedures.get(procedureName.toUpperCase());
    }

    public String getUniIndName(String table, String column) {
        return this.getUniIndName(table, new String[]{column});
    }

    public String getUniIndName(String table, String[] columns) {
        return this.getIndName(table, columns, true);
    }

    public String getIndName(String table, String column) {
        return this.getIndName(table, new String[]{column});
    }

    public String getIndName(String table, String[] columns) {
        return this.getIndName(table, columns, false);
    }

    public static String getSQLRole(String databaseURL) {
        int pos = -1;
        String mask = "?sql_role_name=";
        pos = databaseURL.lastIndexOf(mask);
        if (pos < 0) {
            mask = "&sql_role_name=";
            pos = databaseURL.lastIndexOf(mask);
        }
        if (pos >= 0) {
            int startOfValue = pos + mask.length();
            int endOfValue = databaseURL.indexOf(38, startOfValue + 1);
            if (endOfValue < 0) {
                return databaseURL.substring(startOfValue);
            }
            return databaseURL.substring(startOfValue, endOfValue);
        }
        return null;
    }

    private String getIndName(String table, String[] columns, boolean unique) {
        String indexName = null;
        if (this.dbMetaData == null || this.tables == null || this.indices == null) {
            return indexName;
        }
        HashMap<String, ArrayList<String>> tableIndicies = this.indices.get(table);
        for (Map.Entry<String, ArrayList<String>> entry : tableIndicies.entrySet()) {
            ArrayList<String> myColumns = entry.getValue();
            boolean match = true;
            int i = 0;
            while (i < columns.length) {
                if (!columns[i].equalsIgnoreCase(myColumns.get(i))) {
                    match = false;
                    break;
                }
                ++i;
            }
            if (!match) continue;
            return entry.getKey();
        }
        return null;
    }

    public void commit() {
        if (this.requisites == null) {
            return;
        }
        if (this.requisites.getProtocol().toLowerCase().contains("mysql")) {
            return;
        }
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void rollback() {
        if (this.requisites == null) {
            return;
        }
        if (this.requisites.getProtocol().toLowerCase().contains("mysql")) {
            return;
        }
        try {
            if (this.connection != null) {
                this.connection.rollback();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public void close() {
        if (this.dbcpDriver != null) {
            try {
                this.commit();
                this.dbcpDriver.closePool(this.dbcpPoolName);
                if (this.connectionPool != null) {
                    this.connectionPool.close();
                }
            }
            catch (SQLException e) {
                Console.printThreadStackTrace(e);
            }
        }
    }

    public void disconnect() throws SQLException {
        this.close();
    }

    public void printDriverStats() {
        Console.showMsg("Pool " + this.dbcpPoolName + " stat: active connections: " + this.connectionPool.getNumActive() + ", idling connections: " + this.connectionPool.getNumIdle());
    }

    public Class getDriverClass() {
        return this.driverClass;
    }
}

