/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.database;

import edu.uml.lgdc.appuserdb.api.ApplicationPassport;
import edu.uml.lgdc.appuserdb.api.LgdcRegistry;
import edu.uml.lgdc.database.ConnectionRequisites;
import edu.uml.lgdc.database.DBConnect;
import edu.uml.lgdc.database.DatabaseContents;
import edu.uml.lgdc.database.DatabaseFarm;
import edu.uml.lgdc.project.CommonConst;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.project.ControlPar;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class DatabaseInputOutput {
    protected static final String TEMP_PATH = new File(CommonConst.getUserDir(), "temp").getPath();
    protected ApplicationPassport appPassport;
    protected long allDatabaseContents = 0L;
    protected DatabaseFarm farm = null;
    protected Map<DatabaseContents, DBConnect> dbConnects = new HashMap<DatabaseContents, DBConnect>(5);

    static {
        ControlPar.checkLocalDir(TEMP_PATH);
    }

    public DatabaseInputOutput(DatabaseFarm farm) {
        this.farm = farm;
        this.appPassport = LgdcRegistry.lookupApplicationPassport(farm);
        this.allDatabaseContents = farm.getAllContents(true);
        this.lookupFarm();
    }

    public DatabaseInputOutput(ApplicationPassport appPassport, DatabaseContents databaseContents) {
        this.appPassport = appPassport;
        this.allDatabaseContents = databaseContents.getId();
        this.lookupFarm();
    }

    private void lookupFarm() {
        this.farm = LgdcRegistry.lookupDatabaseFarm(this.appPassport, this.allDatabaseContents, true);
        if (this.farm == null) {
            this.farm = LgdcRegistry.lookupDatabaseFarm(this.appPassport, this.allDatabaseContents, false);
            if (this.farm == null) {
                Console.showError("Database farm of " + DatabaseContents.toText(this.allDatabaseContents) + "content is not available in LGDC resources");
                this.dbConnects.clear();
                return;
            }
            Console.showWarn("Database farm found but it is not fully activated; please review your connection credentials");
        }
        DatabaseContents[] databaseContentsArray = DatabaseContents.values();
        int n = databaseContentsArray.length;
        int n2 = 0;
        while (n2 < n) {
            DatabaseContents contents = databaseContentsArray[n2];
            if ((contents.getId() & this.allDatabaseContents) != 0L) {
                DBConnect oneConnect = this.farm.getActiveDatabaseConnect(contents);
                if (oneConnect != null) {
                    this.dbConnects.put(contents, oneConnect);
                } else {
                    Console.showWarn("Database with " + contents.getName() + " is not active.");
                }
            }
            ++n2;
        }
    }

    public boolean contentAvailable(DatabaseContents contents) {
        return this.dbConnects.get((Object)contents) != null;
    }

    public Connection openRead(DatabaseContents contents) throws SQLException {
        DBConnect connect = this.dbConnects.get((Object)contents);
        return connect != null ? connect.getConnection() : null;
    }

    public Connection openWrite(DatabaseContents contents) throws SQLException {
        if (!this.appPassport.getRole().getWriteAccess()) {
            throw new RuntimeException("No permission to write to " + (Object)((Object)contents) + " database farm");
        }
        DBConnect connect = this.dbConnects.get((Object)contents);
        return this.dbConnects.get((Object)contents) != null ? connect.getConnection() : null;
    }

    public boolean isAvailable(DatabaseContents contents) {
        DBConnect connect = this.dbConnects.get((Object)contents);
        return connect != null;
    }

    public void commit(DatabaseContents contents) {
        DBConnect connect = this.dbConnects.get((Object)contents);
        if (connect != null) {
            connect.commit();
        }
    }

    public void rollback(DatabaseContents contents) {
        DBConnect connect = this.dbConnects.get((Object)contents);
        if (connect != null) {
            connect.rollback();
        }
    }

    public ConnectionRequisites getRequisites(DatabaseContents contents) {
        DBConnect connect = this.dbConnects.get((Object)contents);
        return connect == null ? null : connect.getRequisites();
    }
}

