/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.database;

import edu.uml.lgdc.time.TimeScale;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;

public class FirebirdUtil {
    private static final String SCHEME_SEP = "://";
    private static final String JDBC_FIREBIRD2_PROTOCOL_SEP = "jdbc:firebirdsql://";

    public static TimeScale getTime(ResultSet rs, int timestampIndex) throws SQLException {
        Timestamp timestamp = rs.getTimestamp(timestampIndex, (Calendar)TimeScale.TM);
        return FirebirdUtil.getTime(rs, timestamp);
    }

    public static TimeScale getTime(ResultSet rs, String timestampColumnName) throws SQLException {
        Timestamp timestamp = rs.getTimestamp(timestampColumnName, (Calendar)TimeScale.TM);
        return FirebirdUtil.getTime(rs, timestamp);
    }

    private static TimeScale getTime(ResultSet rs, Timestamp timestamp) throws SQLException {
        if (!rs.wasNull() && timestamp != null) {
            return new TimeScale(timestamp.getTime());
        }
        return null;
    }

    public static String removeBackSlashesAndCheck(String url) {
        int pos = url.indexOf(SCHEME_SEP);
        if (pos <= 0) {
            return null;
        }
        String scheme_colon = url.substring(0, pos + 1);
        url = String.valueOf(scheme_colon = scheme_colon.replace("\\:", ":")) + url.substring(pos + 1);
        if (url.startsWith(JDBC_FIREBIRD2_PROTOCOL_SEP)) {
            return url;
        }
        return null;
    }
}

