/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.database;

import java.util.HashMap;
import java.util.Map;

public enum SPColumnType {
    SPCT_UNKNOWN(0, "nobody knows"),
    SPCT_IN_PAR(1, "IN parameter"),
    SPCT_IN_OUT_PAR(2, "INOUT parameter"),
    SPCT_OUT_PAR(3, "OUT parameter"),
    SPCT_RET_COL(4, "procedure return value"),
    SPCT_RE_COL_IN_RS(5, "result column in ResultSet");

    private static final Map<Integer, SPColumnType> MAP_BY_ID;
    private final int id;
    private final String desc;

    static {
        MAP_BY_ID = new HashMap<Integer, SPColumnType>();
        SPColumnType[] sPColumnTypeArray = SPColumnType.values();
        int n = sPColumnTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SPColumnType type = sPColumnTypeArray[n2];
            if (MAP_BY_ID.put(type.getId(), type) != null) {
                throw new RuntimeException("Design error: duplicate id, " + type.getId());
            }
            ++n2;
        }
    }

    private SPColumnType(int id, String desc) {
        this.id = id;
        this.desc = desc;
    }

    public int getId() {
        return this.id;
    }

    public String getDesc() {
        return this.desc;
    }

    public static SPColumnType get(int id) {
        return MAP_BY_ID.get(id);
    }
}

