/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.database;

import edu.uml.lgdc.database.SPColumn;
import java.util.List;

public class StoredProcedure {
    private final String name;
    private final List<SPColumn> columns;

    public StoredProcedure(String name, List<SPColumn> columns) {
        this.name = name.toUpperCase();
        this.columns = columns;
    }

    public String getName() {
        return this.name;
    }

    public List<SPColumn> getColumns() {
        return this.columns;
    }

    public boolean isColumn(SPColumn column) {
        return this.getColumn(column) != null;
    }

    public SPColumn getColumn(SPColumn column) {
        int index = this.columns.indexOf(column);
        if (index >= 0) {
            return this.columns.get(index);
        }
        return null;
    }

    public boolean addColumn(SPColumn column) {
        if (this.columns.indexOf(column) < 0) {
            this.columns.add(column);
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof StoredProcedure) {
            StoredProcedure sp = (StoredProcedure)object;
            return this.name.equals(sp.name) && this.columns.equals(sp.columns);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() + 31 * this.columns.hashCode();
    }
}

