/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.database.test;

import edu.uml.lgdc.database.ConnectionRequisites;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestConnectionRequisites {
    private static final String[][] parsingInputAndExpectedResult = new String[][]{{"GAMBIT,jdbc:firebirdsql://d2d.giro.uml.edu/gambit,name", "GAMBIT", "jdbc:firebirdsql", "d2d.giro.uml.edu", "gambit", "name", "", "", ""}, {"GAMBIT,jdbc:firebirdsql://d2d.giro.uml.edu/gambit,name,pass", "GAMBIT", "jdbc:firebirdsql", "d2d.giro.uml.edu", "gambit", "name", "pass", "", ""}, {"GAMBIT,jdbc:firebirdsql://d2d.giro.uml.edu/gambit,name,pass,role", "GAMBIT", "jdbc:firebirdsql", "d2d.giro.uml.edu", "gambit", "name", "pass", "role", ""}, {"GAMBIT,jdbc:firebirdsql://d2d.giro.uml.edu/gambit,name,pass,role,org.firebirdsql.jdbc.FBDriver", "GAMBIT", "jdbc:firebirdsql", "d2d.giro.uml.edu", "gambit", "name", "pass", "role", "org.firebirdsql.jdbc.FBDriver"}, {"GAMBIT,jdbc:firebirdsql,d2d.giro.uml.edu,gambit,name", "GAMBIT", "jdbc:firebirdsql", "d2d.giro.uml.edu", "gambit", "name", "", "", ""}, {"GAMBIT,jdbc:firebirdsql,d2d.giro.uml.edu,gambit,name,pass", "GAMBIT", "jdbc:firebirdsql", "d2d.giro.uml.edu", "gambit", "name", "pass", "", ""}, {"GAMBIT,jdbc:firebirdsql,d2d.giro.uml.edu,gambit,name,pass,role", "GAMBIT", "jdbc:firebirdsql", "d2d.giro.uml.edu", "gambit", "name", "pass", "role", ""}, {"GAMBIT,jdbc:firebirdsql,d2d.giro.uml.edu,gambit,name,pass,role,org.firebirdsql.jdbc.FBDriver", "GAMBIT", "jdbc:firebirdsql", "d2d.giro.uml.edu", "gambit", "name", "pass", "role", "org.firebirdsql.jdbc.FBDriver"}};

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testParsing0() {
        String[][] stringArray = parsingInputAndExpectedResult;
        int n = parsingInputAndExpectedResult.length;
        int n2 = 0;
        while (n2 < n) {
            String[] inputAndExpected = stringArray[n2];
            ConnectionRequisites connectionRequisites = ConnectionRequisites.parse(inputAndExpected[0]);
            String alias = inputAndExpected[1];
            String protocol = inputAndExpected[2];
            String host = inputAndExpected[3];
            String file = inputAndExpected[4];
            String user = inputAndExpected[5];
            String pass = inputAndExpected[6];
            String role = inputAndExpected[7];
            String string = inputAndExpected[8];
            ++n2;
        }
    }

    @Test
    public void testParsing_0() {
        this.testParsing(parsingInputAndExpectedResult[0]);
    }

    @Test
    public void testParsing_1() {
        this.testParsing(parsingInputAndExpectedResult[1]);
    }

    @Test
    public void testParsing_2() {
        this.testParsing(parsingInputAndExpectedResult[2]);
    }

    @Test
    public void testParsing_3() {
        this.testParsing(parsingInputAndExpectedResult[3]);
    }

    @Test
    public void testParsing_4() {
        this.testParsing(parsingInputAndExpectedResult[4]);
    }

    @Test
    public void testParsing_5() {
        this.testParsing(parsingInputAndExpectedResult[5]);
    }

    @Test
    public void testParsing_6() {
        this.testParsing(parsingInputAndExpectedResult[6]);
    }

    @Test
    public void testParsing_7() {
        this.testParsing(parsingInputAndExpectedResult[7]);
    }

    private void testParsing(String[] inputAndExpected) {
        ConnectionRequisites item = ConnectionRequisites.parse(inputAndExpected[0]);
        String title = inputAndExpected[1];
        String protocol = inputAndExpected[2];
        String host = inputAndExpected[3];
        String file = inputAndExpected[4];
        String user = inputAndExpected[5];
        String pass = inputAndExpected[6];
        String role = inputAndExpected[7];
        String driver = inputAndExpected[8];
        if (!(title.equals(item.getTitle()) && protocol.equals(item.getProtocol()) && host.equals(item.getHost()) && file.equals(item.getFilename()) && user.equals(item.getUsername()) && pass.equals(item.getPass()) && role.equals(item.getRole()) && driver.equals(item.getDriverClassName()))) {
            Assert.fail((String)("Input string for parsing: " + inputAndExpected[0] + "\nExpected result: title=" + title + ", protocol=" + protocol + ", host=" + host + ", file=" + file + ", user=" + user + ", pass=" + pass + ", role=" + role + ", driver=" + driver + "\n  Actual result: title=" + item.getTitle() + ", protocol=" + item.getProtocol() + ", host=" + item.getHost() + ", file=" + item.getFilename() + ", user=" + item.getUsername() + ", pass=" + item.getPass() + ", role=" + item.getRole() + ", driver=" + item.getDriverClassName()));
        }
    }
}

