/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public final class ArrVec {
    public static <T> void addVectorToVector(Vector<T> from, Vector<T> to) {
        if (from != null) {
            int i = 0;
            while (i < from.size()) {
                to.addElement(from.elementAt(i));
                ++i;
            }
        }
    }

    public static <T> void addArrayToVector(T[] from, Vector<T> to) {
        if (from != null) {
            int i = 0;
            while (i < from.length) {
                to.addElement(from[i]);
                ++i;
            }
        }
    }

    public static void shiftCircularly(Object[] object, int shift) {
        if (shift == 0) {
            return;
        }
        if (object == null || object.length <= 1) {
            return;
        }
        int dir = shift > 0 ? 1 : 0;
        shift = Math.abs(shift);
        if ((shift %= object.length) == 0) {
            return;
        }
        if (shift > object.length / 2) {
            shift = object.length - shift;
            dir = -dir;
        }
        Object[] temp = new Object[shift];
        if (dir > 0) {
            System.arraycopy(object, object.length - shift, temp, 0, shift);
            int i = object.length - 1;
            while (i >= shift) {
                object[i] = object[i - shift];
                --i;
            }
            System.arraycopy(temp, 0, object, 0, shift);
        } else {
            System.arraycopy(object, 0, temp, 0, shift);
            int i = 0;
            while (i < object.length - shift) {
                object[i] = object[i + shift];
                ++i;
            }
            System.arraycopy(temp, 0, object, object.length - shift, shift);
        }
    }

    public static <T> void shiftCircularly(List<T> list, int shift) {
        if (shift == 0) {
            return;
        }
        if (list == null || list.size() <= 1) {
            return;
        }
        int dir = shift > 0 ? 1 : 0;
        shift = Math.abs(shift);
        if ((shift %= list.size()) == 0) {
            return;
        }
        if (shift > list.size() / 2) {
            shift = list.size() - shift;
            dir = -dir;
        }
        ArrayList<T> temp = new ArrayList<T>(shift);
        int i = 0;
        while (i < shift) {
            temp.add(null);
            ++i;
        }
        if (dir > 0) {
            i = 0;
            while (i < shift) {
                temp.set(i, list.get(list.size() - shift + i));
                ++i;
            }
            i = list.size() - 1;
            while (i >= shift) {
                list.set(i, list.get(i - shift));
                --i;
            }
            i = 0;
            while (i < shift) {
                list.set(i, temp.get(i));
                ++i;
            }
        } else {
            i = 0;
            while (i < shift) {
                temp.set(i, list.get(i));
                ++i;
            }
            i = 0;
            while (i < list.size() - shift) {
                list.set(i, list.get(i + shift));
                ++i;
            }
            i = 0;
            while (i < shift) {
                list.set(list.size() - shift + i, temp.get(i));
                ++i;
            }
        }
    }

    public static void mirror(double[] values) {
        ArrVec.mirror(values, 0, values.length);
    }

    public static void mirror(double[] values, int start, int length) {
        if (length < 2) {
            return;
        }
        int left = start;
        int right = start + length - 1;
        while (left < right) {
            double val = values[left];
            values[left] = values[right];
            values[right] = val;
            ++left;
            --right;
        }
    }

    public static void mirror(int[] values) {
        ArrVec.mirror(values, 0, values.length);
    }

    public static void mirror(int[] values, int start, int length) {
        if (length < 2) {
            return;
        }
        int left = start;
        int right = start + length - 1;
        while (left < right) {
            int val = values[left];
            values[left] = values[right];
            values[right] = val;
            ++left;
            --right;
        }
    }

    public static void mirror(Object[] values) {
        ArrVec.mirror(values, 0, values.length);
    }

    public static void mirror(Object[] values, int start, int length) {
        if (length < 2) {
            return;
        }
        int left = start;
        int right = start + length - 1;
        while (left < right) {
            Object val = values[left];
            values[left] = values[right];
            values[right] = val;
            ++left;
            --right;
        }
    }
}

