/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype;

import edu.uml.lgdc.datatype.AbstractObjBuffer;

public class CIOObjBuffer
extends AbstractObjBuffer {
    private Object[] buffer;
    private int in = 0;
    private int out = 0;
    private int urgentCount = 0;

    public CIOObjBuffer(int bfrSize) {
        super(bfrSize);
        this.buffer = new Object[bfrSize + 1];
    }

    @Override
    public synchronized int howMany() {
        if (this.in >= this.out) {
            return this.in - this.out;
        }
        return this.in + (this.bfrSize + 1 - this.out);
    }

    @Override
    public synchronized Object read() {
        Object object = this.buffer[this.out];
        this.buffer[this.out] = null;
        this.out = this.nextIndex(this.out);
        if (this.urgentCount > 0) {
            --this.urgentCount;
        }
        return object;
    }

    @Override
    public synchronized void write(Object object) {
        this.buffer[this.in] = object;
        this.in = this.nextIndex(this.in);
    }

    public synchronized void writeUrgent(Object urgentObject) {
        this.out = this.prevIndex(this.out);
        this.buffer[this.out] = urgentObject;
        ++this.urgentCount;
    }

    public synchronized void writeToHead(Object object) {
        int qty = this.howMany();
        if (this.urgentCount == 0) {
            this.out = this.prevIndex(this.out);
            this.buffer[this.out] = object;
            return;
        }
        int insertPos = (this.out + this.urgentCount) % (this.bfrSize + 1);
        int qtyToMove = qty - this.urgentCount;
        int nextPos = this.in;
        int pos = this.prevIndex(this.in);
        while (qtyToMove > 0) {
            this.buffer[nextPos] = this.buffer[pos];
            nextPos = pos;
            pos = this.prevIndex(pos);
            --qtyToMove;
        }
        this.buffer[insertPos] = object;
        this.in = this.nextIndex(this.in);
    }

    private int nextIndex(int ind) {
        if (ind < this.bfrSize) {
            return ++ind;
        }
        return 0;
    }

    private int prevIndex(int ind) {
        if (ind > 0) {
            return --ind;
        }
        return this.bfrSize;
    }
}

