/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype;

import edu.uml.lgdc.datatype.IntervalType;
import java.util.ArrayList;
import java.util.List;

public class Interval<T extends Comparable<? super T>>
extends IntervalType {
    protected T left;
    protected T right;
    private boolean empty = true;

    public Interval() {
    }

    public Interval(T left, T right, int type) {
        this.setInterval(left, right, type);
    }

    public Interval(Interval<T> interval) {
        if (interval.isEmpty()) {
            this.setEmpty();
        } else {
            this.setInterval(interval.left, interval.right, interval.type);
        }
    }

    public Interval<T> getEmptyInterval() {
        return new Interval<T>();
    }

    public void setInterval(T left, T right) {
        int type = !this.eq(left, right) ? 0 : 0;
        this.setInterval(left, right, type);
    }

    public void setInterval(T left, T right, int type) {
        if (type < 0 || type >= 4) {
            throw new IllegalArgumentException("Illegal interval type: " + type);
        }
        if (right != null && left != null && right.compareTo(left) < 0) {
            throw new IllegalArgumentException("end before start");
        }
        this.left = left;
        this.right = right;
        if (left == null) {
            if (type == 0) {
                type = 3;
            } else if (type == 2) {
                type = 1;
            }
        }
        if (right == null) {
            if (type == 0) {
                type = 2;
            } else if (type == 3) {
                type = 1;
            }
        }
        this.type = type;
        this.empty = false;
    }

    public Object getLeft() {
        if (!this.isEmpty()) {
            return this.left;
        }
        return null;
    }

    public void setLeft(T left) {
        if (!this.isEmpty()) {
            this.setInterval(left, this.right, this.type);
        }
    }

    public T getRight() {
        if (!this.isEmpty()) {
            return this.right;
        }
        return null;
    }

    public void setRight(T right) {
        if (!this.isEmpty()) {
            this.setInterval(this.left, right, this.type);
        }
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setEmpty() {
        this.empty = true;
    }

    @Override
    public void setLeftIncluded(boolean flag) {
        if (this.isEmpty()) {
            return;
        }
        if (this.left == null) {
            return;
        }
        super.setLeftIncluded(flag);
    }

    @Override
    public void setRightIncluded(boolean flag) {
        if (this.isEmpty()) {
            return;
        }
        if (this.right == null) {
            return;
        }
        super.setRightIncluded(flag);
    }

    public boolean inside(T value) {
        if (value == null) {
            throw new IllegalArgumentException("value == null");
        }
        boolean result = false;
        if (this.isEmpty()) {
            return false;
        }
        if (!this.before(value, this.left) && !this.before(this.right, value)) {
            result = this.before(this.left, value) && this.before(value, this.right) ? true : (this.eq(value, this.left) ? this.type == 0 || this.type == 2 : this.type == 0 || this.type == 3);
        }
        return result;
    }

    public boolean liesBefore(Interval<T> interval) {
        if (this.isEmpty() || interval.isEmpty()) {
            return true;
        }
        if (this.before(this.right, interval.left)) {
            return true;
        }
        if (this.eq(this.right, interval.left)) {
            return !this.rightIncluded() || !interval.leftIncluded();
        }
        return false;
    }

    public boolean intersected(Interval<T> interval) {
        return this.intersected(this, interval);
    }

    public boolean leftAdjacent(Interval<T> interval) {
        return this.leftAdjacent(this, interval);
    }

    public boolean rightAdjacent(Interval<T> interval) {
        return this.rightAdjacent(this, interval);
    }

    public boolean adjacent(Interval<T> interval) {
        return this.adjacent(this, interval);
    }

    public boolean joined(Interval<T> interval) {
        return this.joined(this, interval);
    }

    public Interval<T> intersect(Interval<T> interval) {
        Interval<T> intersect = this.intersect(this, interval);
        if (intersect != null) {
            this.setInterval(intersect.left, intersect.right, intersect.type);
        } else {
            this.setEmpty();
        }
        return this;
    }

    public Interval<T> envelope(Interval<T> interval) {
        Interval<T> env = this.envelope(this, interval);
        if (!env.isEmpty()) {
            this.setInterval(env.left, env.right, env.type);
        } else {
            this.setEmpty();
        }
        return this;
    }

    public boolean equals(Interval<T> obj) {
        if (obj != null && obj instanceof Interval) {
            if (this.isEmpty()) {
                return obj.isEmpty();
            }
            if (obj.isEmpty()) {
                return false;
            }
            return this.eq(this.left, obj.left) && this.eq(this.right, obj.right) && this.type == obj.type;
        }
        return false;
    }

    public boolean before(T obj1, T obj2) {
        if (obj1 == null) {
            return obj2 != null;
        }
        if (obj2 != null) {
            return obj1.compareTo(obj2) < 0;
        }
        return false;
    }

    public boolean eq(T obj1, T obj2) {
        if (obj1 == null || obj2 == null) {
            return obj1 == obj2;
        }
        return obj1.compareTo(obj2) == 0;
    }

    public boolean intersected(Interval<T> int1, Interval<T> int2) {
        if (int1.isEmpty() || int2.isEmpty()) {
            return false;
        }
        return !int1.liesBefore(int2) && !int2.liesBefore(int1);
    }

    public boolean leftAdjacent(Interval<T> int1, Interval<T> int2) {
        if (int1.isEmpty() || int2.isEmpty()) {
            return true;
        }
        return this.eq(int1.right, int2.left) && (int1.rightIncluded() && !int2.leftIncluded() || !int1.rightIncluded() && int2.leftIncluded());
    }

    public boolean rightAdjacent(Interval<T> int1, Interval<T> int2) {
        return this.leftAdjacent(int2, int1);
    }

    public boolean adjacent(Interval<T> int1, Interval<T> int2) {
        return this.leftAdjacent(int1, int2) || this.rightAdjacent(int1, int2);
    }

    public boolean joined(Interval<T> int1, Interval<T> int2) {
        if (int1.isEmpty() || int2.isEmpty()) {
            return false;
        }
        return this.intersected(int1, int2) || this.adjacent(int1, int2);
    }

    public Interval<T> intersect(Interval<T> int1, Interval<T> int2) {
        boolean rightIncluded;
        T right;
        boolean leftIncluded;
        T left;
        Interval<T> intersect = null;
        if (int1.isEmpty() || int2.isEmpty()) {
            return null;
        }
        if (this.before(int1.left, int2.left)) {
            left = int2.left;
            leftIncluded = int2.leftIncluded();
        } else {
            left = int1.left;
            if (this.before(int2.left, int1.left)) {
                leftIncluded = int1.leftIncluded();
            } else {
                boolean bl = leftIncluded = int1.leftIncluded() && int2.leftIncluded();
            }
        }
        if (this.before(int1.right, int2.right)) {
            right = int1.right;
            rightIncluded = int1.rightIncluded();
        } else {
            right = int2.right;
            if (this.before(int2.left, int1.left)) {
                rightIncluded = int2.rightIncluded();
            } else {
                boolean bl = rightIncluded = int1.rightIncluded() && int2.rightIncluded();
            }
        }
        if (this.before(left, right)) {
            intersect = int1.getEmptyInterval();
            intersect.setInterval(left, right);
            intersect.setLeftIncluded(leftIncluded);
            intersect.setRightIncluded(rightIncluded);
        } else if (this.eq(left, right) && leftIncluded && rightIncluded) {
            intersect = int1.getEmptyInterval();
            intersect.setInterval(left, right, 0);
        }
        return intersect;
    }

    public Interval<T> envelope(Interval<T> int1, Interval<T> int2) {
        boolean rightIncluded;
        T right;
        boolean leftIncluded;
        T left;
        Interval<T> env = null;
        if (int1.isEmpty()) {
            return int2;
        }
        if (int2.isEmpty()) {
            return int1;
        }
        if (this.before(int1.left, int2.left)) {
            left = int1.left;
            leftIncluded = int1.leftIncluded();
        } else {
            left = int2.left;
            if (this.before(int2.left, int1.left)) {
                leftIncluded = int2.leftIncluded();
            } else {
                boolean bl = leftIncluded = int1.leftIncluded() || int2.leftIncluded();
            }
        }
        if (this.before(int1.right, int2.right)) {
            right = int2.right;
            rightIncluded = int2.rightIncluded();
        } else {
            right = int1.right;
            rightIncluded = this.before(int2.left, int1.left) ? int1.rightIncluded() : int1.rightIncluded() || int2.rightIncluded();
        }
        env = int1.getEmptyInterval();
        env.setInterval(left, right);
        env.setLeftIncluded(leftIncluded);
        env.setRightIncluded(rightIncluded);
        return env;
    }

    public List<Interval<T>> subtract(Interval<T> int1, Interval<T> int2) {
        Interval<T> sub1 = null;
        Interval<T> sub2 = null;
        if (int2.isEmpty() || !int1.intersected(int2)) {
            ArrayList<Interval<T>> list = new ArrayList<Interval<T>>();
            list.add(new Interval<T>(int1));
            list.add(null);
            return list;
        }
        int2 = this.intersect(int1, int2);
        boolean leftIncluded = true;
        boolean rightIncluded = true;
        T left = null;
        T right = null;
        if (this.before(int1.left, int2.left)) {
            left = int1.left;
            leftIncluded = int1.leftIncluded();
            right = int2.left;
            rightIncluded = !int2.leftIncluded();
        } else if (int1.leftIncluded() && !int2.leftIncluded()) {
            T t = int1.left;
            right = t;
            left = t;
            rightIncluded = true;
            leftIncluded = true;
        }
        if (left != null) {
            sub1 = new Interval<T>(int1);
            sub1.setInterval(left, right);
            sub1.setLeftIncluded(leftIncluded);
            sub1.setRightIncluded(rightIncluded);
        }
        left = null;
        if (this.before(int2.right, int1.right)) {
            right = int1.right;
            rightIncluded = int1.rightIncluded();
            left = int2.right;
            leftIncluded = !int2.rightIncluded();
        } else if (int1.rightIncluded() && !int2.rightIncluded()) {
            T t = int1.right;
            right = t;
            left = t;
            rightIncluded = true;
            leftIncluded = true;
        }
        if (left != null) {
            Interval<T> sub = new Interval<T>(int1);
            sub.setInterval(left, right);
            sub.setLeftIncluded(leftIncluded);
            sub.setRightIncluded(rightIncluded);
            if (sub1 == null) {
                sub1 = sub;
            } else {
                sub2 = sub;
            }
        }
        ArrayList<Interval<T>> list = new ArrayList<Interval<T>>();
        list.add(sub1);
        list.add(sub2);
        return list;
    }
}

