/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype;

import edu.uml.lgdc.datatype.Interval;
import java.util.ArrayList;
import java.util.List;

public class Intervals<T extends Comparable<? super T>> {
    private List<Interval<T>> intervals = new ArrayList<Interval<T>>(32);

    public void add(T start, T end) {
        this.add(start, end, 0);
    }

    public void add(T start, T end, int type) {
        this.add(new Interval<T>(start, end, type));
    }

    public void add(Interval<T> interval) {
        if (interval.isEmpty()) {
            return;
        }
        Interval<T> last = null;
        if (this.intervals.size() > 0) {
            last = this.intervals.get(this.intervals.size() - 1);
        }
        if (last != null && (!last.liesBefore(interval) || last.leftAdjacent(interval))) {
            interval = new Interval<T>(interval);
            int i = 0;
            while (i < this.intervals.size()) {
                Interval<T> current = this.intervals.get(i);
                if (interval.liesBefore(current) && !interval.leftAdjacent(current)) {
                    this.intervals.add(i, interval);
                    interval = null;
                    break;
                }
                if (interval.joined(current)) {
                    interval.envelope(current);
                    this.intervals.remove(i);
                    continue;
                }
                ++i;
            }
        }
        if (interval != null) {
            this.intervals.add(interval);
        }
    }

    public void subtract(T start, T end, int type) {
        this.subtract(new Interval<T>(start, end, type));
    }

    public void subtract(Interval<T> interval) {
        if (interval.isEmpty()) {
            return;
        }
        Interval<T> last = null;
        if (this.intervals.size() > 0) {
            last = this.intervals.get(this.intervals.size() - 1);
        }
        if (last != null && (!last.liesBefore(interval) || last.leftAdjacent(interval))) {
            int i = 0;
            while (i < this.intervals.size()) {
                Interval<T> current = this.intervals.get(i);
                if (interval.liesBefore(current)) break;
                if (interval.intersected(current)) {
                    List<Interval<T>> sub = interval.subtract(current, interval);
                    if (sub.get(1) != null) {
                        this.intervals.add(i, sub.get(0));
                        this.intervals.set(i + 1, sub.get(1));
                        break;
                    }
                    if (sub.get(0) == null) {
                        this.intervals.remove(i);
                        continue;
                    }
                    this.intervals.set(i++, sub.get(0));
                    continue;
                }
                ++i;
            }
        }
    }

    public List<Interval<T>> getIntervals() {
        return this.intervals;
    }

    public boolean inside(T value) {
        boolean result = false;
        int i = 0;
        while (i < this.intervals.size()) {
            if (this.intervals.get(i).inside(value)) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }
}

