/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Pair<T> {
    private final List<T> elements = new ArrayList<T>();
    private final Set<T> set;

    public Pair(T[] elements) {
        this(Pair.check(elements)[0], Pair.check(elements)[1]);
    }

    public Pair(T first, T second) {
        this.elements.add(first);
        this.elements.add(second);
        this.set = new HashSet<T>();
        this.set.add(this.elements.get(0));
        this.set.add(this.elements.get(1));
        if (this.set.size() == 1) {
            throw new IllegalArgumentException("equaled elements are not allowed for this implementation");
        }
    }

    public T getFirst() {
        return this.get(0);
    }

    public T getSecond() {
        return this.get(1);
    }

    public T get(int index) {
        return this.elements.get(index);
    }

    public boolean equals(Object obj) {
        return this.set.equals(obj);
    }

    public int hashCode() {
        return this.set.hashCode();
    }

    private static Object[] check(Object[] elements) {
        if (elements == null || elements.length != 2) {
            throw new IllegalArgumentException("elements == null || elements.length != 2");
        }
        return elements;
    }
}

