/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype;

import java.util.ArrayList;
import java.util.List;

public class TailBuffer<E> {
    private final int length;
    private final List<E> buffer;
    private int first;

    public TailBuffer(int length) {
        assert (length > 0);
        this.length = length;
        this.buffer = new ArrayList(length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(E e) {
        List<E> list = this.buffer;
        synchronized (list) {
            if (this.buffer.size() == this.length) {
                this.buffer.set(this.first, e);
                this.first = this.getNext(this.first);
            } else {
                this.buffer.add(e);
            }
        }
    }

    public int getSize() {
        return this.buffer.size();
    }

    public List<E> getTail() {
        return this.getTail(this.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<E> getTail(int maxSize) {
        assert (maxSize > 0);
        List<E> list = this.buffer;
        synchronized (list) {
            int qty = Math.min(maxSize, this.buffer.size());
            if (qty > 0) {
                ArrayList<E> tail = new ArrayList<E>(qty);
                int current = this.first;
                int i = 0;
                while (i < qty) {
                    tail.add(this.buffer.get(current));
                    current = this.getNext(current);
                    ++i;
                }
                return tail;
            }
            return new ArrayList();
        }
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    private int getNext(int current) {
        if (current != this.length - 1) {
            return ++current;
        }
        return 0;
    }
}

