/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype;

import edu.uml.lgdc.datatype.OrderedMetricable;
import edu.uml.lgdc.project.CommonConst;
import edu.uml.lgdc.time.TimeMarked;
import edu.uml.lgdc.time.TimeScale;

public abstract class TimeOrderedMetric
implements OrderedMetricable<TimeOrderedMetric>,
TimeMarked {
    private static final String FILE_TIME_FORMAT = CommonConst.getFileTimeFormat();

    public TimeScale getTime() {
        double time = this.getTimeInMinutes();
        if (!Double.isNaN(time)) {
            return new TimeScale(time);
        }
        return null;
    }

    @Override
    public int compareTo(TimeOrderedMetric timeOrderedMetric) {
        if (timeOrderedMetric != null) {
            double time1 = this.getTimeInMinutes();
            double time2 = timeOrderedMetric.getTimeInMinutes();
            if (!Double.isNaN(time1) && !Double.isNaN(time2)) {
                return (int)Math.signum(time1 - time2);
            }
        }
        return 1;
    }

    @Override
    public double dist(TimeOrderedMetric timeOrderedMetric) {
        double dist = Double.NaN;
        if (timeOrderedMetric != null) {
            double time1 = this.getTimeInMinutes();
            double time2 = timeOrderedMetric.getTimeInMinutes();
            if (!Double.isNaN(time1) && !Double.isNaN(time2)) {
                dist = Math.abs(time1 - time2);
            }
        }
        return dist;
    }

    public String createFileName() {
        return this.getTimeAsString();
    }

    public String createFileName(String format) {
        return this.getTimeAsString(format);
    }

    public String createTempFileName() {
        return this.getTimeAsString();
    }

    public String createTempFileName(String format) {
        return this.getTimeAsString(format);
    }

    public String createTempName() {
        return this.getTimeAsString(FILE_TIME_FORMAT);
    }

    public String createTempName(String format) {
        return this.getTimeAsString(format);
    }

    public String createName() {
        return this.getTimeAsString();
    }

    public String createName(String format) {
        return this.getTimeAsString(format);
    }

    public final String getTimeAsString() {
        return this.getTimeAsString(FILE_TIME_FORMAT);
    }

    public final String getTimeAsString(String format) {
        return this.getTime().toFormatUT(format);
    }
}

