/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype;

import edu.uml.lgdc.datatype.OrderedMetricable;
import edu.uml.lgdc.math.Search;
import edu.uml.lgdc.math.Sort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class WeighedSet {
    private static final double SMALL_VALUE = 1.0E-9;
    private int[] idents;
    private double[] weights;
    private int numberOfElements;
    private double constant;
    private double divider;
    private Exact[] exactWeights;

    public WeighedSet(int[] idents, double[] weights) {
        this(idents, weights, 0.0);
    }

    public WeighedSet(int[] idents, double[] weights, double constant) {
        this(idents, weights, constant, 1.0);
    }

    public WeighedSet(int[] idents, double[] weights, double constant, double divider) {
        if (idents == null) {
            throw new IllegalArgumentException("parameter idents must not be null");
        }
        if (weights == null) {
            throw new IllegalArgumentException("parameter weights must not be null");
        }
        if (idents.length != weights.length) {
            throw new IllegalArgumentException("arrays idents and weights have different length");
        }
        if (idents.length == 0) {
            throw new IllegalArgumentException("array idents has length 0");
        }
        if (idents.length > 30) {
            throw new IllegalArgumentException("array idents too big, " + idents.length + ", no more than 30 allowed");
        }
        this.checkAllIdentsAreDifferent(idents);
        this.copyAndIncreaseByWeights(idents, weights);
        this.numberOfElements = idents.length;
        this.constant = constant;
        this.divider = divider;
        this.buildPossibleExactWeights();
    }

    public Exact[] getAllExactWeights() {
        return this.exactWeights;
    }

    public int getNumberOfExactWeights() {
        return this.exactWeights.length;
    }

    public Exact getClosestExactWeight(double weight) {
        return this.exactWeights[this.getIndexOfClosestExactWeight(weight)];
    }

    public int getIndexOfClosestExactWeight(double weight) {
        return Search.closest((OrderedMetricable[])this.exactWeights, (OrderedMetricable)new Exact(weight, new int[0]));
    }

    private void buildPossibleExactWeights() {
        ArrayList<Exact> lstExactWeights = new ArrayList<Exact>(128);
        int numberOfSubsets = 1 << this.numberOfElements;
        int i = 0;
        while (i < numberOfSubsets) {
            int[] subset = this.getSubset(i);
            double weight = this.getWeight(subset);
            int j = 0;
            while (j < subset.length) {
                subset[j] = this.idents[subset[j]];
                ++j;
            }
            Sort.qsort(subset);
            Exact exactWeight = new Exact(weight, subset);
            int index = Search.leftNearest(lstExactWeights, exactWeight);
            if (index == -1 || exactWeight.compareTo((Exact)lstExactWeights.get(index)) != 0) {
                lstExactWeights.add(index + 1, exactWeight);
            } else {
                ((Exact)lstExactWeights.get(index)).addSubset(subset);
            }
            ++i;
        }
        this.exactWeights = lstExactWeights.toArray(new Exact[0]);
    }

    private void copyAndIncreaseByWeights(int[] idents, double[] weights) {
        this.idents = Arrays.copyOf(idents, idents.length);
        this.weights = Arrays.copyOf(weights, weights.length);
        Sort sort = new Sort(this.weights);
        this.idents = sort.doSort(this.idents);
    }

    private double getWeight(int[] subsetAsIndexes) {
        double weight = this.constant;
        int i = 0;
        while (i < subsetAsIndexes.length) {
            weight += this.weights[subsetAsIndexes[i]];
            ++i;
        }
        return weight / this.divider;
    }

    private int[] getSubset(int seqNumber) {
        int subsetLength = this.getSubsetLength(seqNumber);
        int[] subset = new int[subsetLength];
        if (subsetLength == 0) {
            return subset;
        }
        int next = 0;
        int i = 0;
        while (i < this.numberOfElements) {
            if ((seqNumber & 1) != 0) {
                subset[next++] = i;
                if (next == subsetLength) break;
            }
            seqNumber >>= 1;
            ++i;
        }
        Sort.qsort(subset);
        return subset;
    }

    private int getSubsetLength(int seqNumber) {
        int length = 0;
        int i = 0;
        while (i < this.numberOfElements) {
            if ((seqNumber & 1) != 0) {
                ++length;
            }
            seqNumber >>= 1;
            ++i;
        }
        return length;
    }

    private void checkAllIdentsAreDifferent(int[] idents) {
        int[] sortedIdents = Arrays.copyOf(idents, idents.length);
        Sort.qsort(sortedIdents);
        if (sortedIdents[0] <= 0) {
            throw new IllegalArgumentException("array idents contains 0 or negative numbers");
        }
        int i = 1;
        while (i < sortedIdents.length) {
            if (sortedIdents[i - 1] == sortedIdents[i]) {
                throw new IllegalArgumentException("array idents contains identical elements");
            }
            ++i;
        }
    }

    private void checkAllWeightsArePositive(double[] weights) {
        int i = 0;
        while (i < weights.length) {
            if (weights[i] <= 0.0) {
                throw new IllegalArgumentException("array weights contains 0 or negative numbers");
            }
            ++i;
        }
    }

    public static class Exact
    implements OrderedMetricable<Exact> {
        private double weight;
        private List<int[]> subsets = new ArrayList<int[]>();

        private Exact(double weight, int[] subsetIdents) {
            this.weight = weight;
            this.subsets.add(subsetIdents);
        }

        public double getWeight() {
            return this.weight;
        }

        public List<int[]> getSubsets() {
            return this.subsets;
        }

        @Override
        public int compareTo(Exact exact) {
            if (exact != null) {
                return (int)Math.signum(this.weight - exact.weight - 1.0E-9);
            }
            return 1;
        }

        @Override
        public double dist(Exact exactWeight) {
            if (exactWeight != null) {
                double dist = Math.abs(this.weight - exactWeight.weight);
                if (dist <= 1.0E-9) {
                    return 0.0;
                }
                return dist;
            }
            return 2.147483647E9;
        }

        private void addSubset(int[] subsetIdents) {
            this.subsets.add(subsetIdents);
        }
    }
}

