/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype;

import edu.uml.lgdc.datatype.Double2DArray;

public class WrapToDouble2DArray
implements Double2DArray {
    private double[][] data;
    private int minXIndex;
    private int maxXIndex;
    private int minYIndex;
    private int maxYIndex;

    public WrapToDouble2DArray(double[][] data) {
        this(data, 0, data.length - 1);
    }

    public WrapToDouble2DArray(double[][] data, int minXIndex, int maxXIndex) {
        this(data, minXIndex, maxXIndex, 0, data.length == 0 ? 0 : data[0].length - 1);
    }

    public WrapToDouble2DArray(double[][] data, int minXIndex, int maxXIndex, int minYIndex, int maxYIndex) {
        this.setArray(data, minXIndex, maxXIndex, minYIndex, maxYIndex);
    }

    @Override
    public int size(int dimensionIndex) {
        int length = 0;
        if (dimensionIndex == 0) {
            length = this.maxXIndex - this.minXIndex + 1;
        } else if (dimensionIndex == 1) {
            length = this.maxYIndex - this.minYIndex + 1;
        } else {
            throw new IllegalArgumentException("Illegal index for dimension: " + dimensionIndex);
        }
        return length;
    }

    @Override
    public double element(int index1, int index2) {
        if (index1 >= 0 && index1 < this.size(0) && index2 >= 0 && index2 < this.size(1)) {
            return this.data[this.minXIndex + index1][this.minYIndex + index2];
        }
        throw new IndexOutOfBoundsException("Some or both of indeces are illegal: " + index1 + " or " + index2);
    }

    private void setArray(double[][] data, int minXIndex, int maxXIndex, int minYIndex, int maxYIndex) {
        int yDim;
        int n = yDim = data.length == 0 ? 0 : data[0].length - 1;
        if (minXIndex < 0 || maxXIndex >= data.length || minXIndex > maxXIndex || minYIndex < 0 || maxYIndex >= yDim || minYIndex > maxYIndex) {
            throw new IllegalArgumentException("Illegal bounds: " + minXIndex + ", " + maxXIndex + ", " + minYIndex + " or " + maxYIndex);
        }
        this.data = data;
        this.minXIndex = minXIndex;
        this.maxXIndex = maxXIndex;
        this.minYIndex = minYIndex;
        this.maxYIndex = maxYIndex;
    }
}

