/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype;

import edu.uml.lgdc.datatype.FloatArray;

public class WrapToFloatArray
implements FloatArray {
    private float[] data;
    private int minIndex = 0;
    private int maxIndex = 0;
    private float minData;
    private float maxData;
    private boolean newArray;

    public WrapToFloatArray(float[] data) {
        this(data, 0);
    }

    public WrapToFloatArray(float[] data, int minIndex) {
        this(data, minIndex, data.length - 1);
    }

    public WrapToFloatArray(float[] data, int minIndex, int maxIndex) {
        this.setArray(data, minIndex, maxIndex);
    }

    @Override
    public int size() {
        return this.maxIndex - this.minIndex + 1;
    }

    @Override
    public float element(int index) {
        if (index >= 0 && index <= this.maxIndex - this.minIndex) {
            return this.data[this.minIndex + index];
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    @Override
    public float getMinData() {
        if (this.newArray) {
            this.calcMinMax();
        }
        return this.minData;
    }

    @Override
    public float getMaxData() {
        if (this.newArray) {
            this.calcMinMax();
        }
        return this.maxData;
    }

    private void setArray(float[] data, int minIndex, int maxIndex) {
        if (minIndex < 0 || maxIndex >= data.length || minIndex > maxIndex) {
            throw new IllegalArgumentException("Illegal bounds: " + minIndex + " or " + maxIndex);
        }
        this.data = data;
        this.minIndex = minIndex;
        this.maxIndex = maxIndex;
        this.newArray = true;
    }

    protected void calcMinMax() {
        this.newArray = false;
        if (this.data.length == 0) {
            this.minData = Float.NaN;
            this.maxData = Float.NaN;
        } else {
            this.minData = Float.MAX_VALUE;
            this.maxData = Float.MIN_VALUE;
            int i = this.minIndex;
            while (i <= this.maxIndex) {
                if (this.data[i] < this.minData) {
                    this.minData = this.data[i];
                }
                if (this.data[i] > this.maxData) {
                    this.maxData = this.data[i];
                }
                ++i;
            }
        }
    }
}

