/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype.field;

import edu.uml.lgdc.datatype.field.ExternalType;
import edu.uml.lgdc.datatype.field.FieldDesc;
import edu.uml.lgdc.datatype.field.IntegerField;
import edu.uml.lgdc.datatype.field.LongField;
import edu.uml.lgdc.datatype.field.NumericField;
import edu.uml.lgdc.datatype.field.ProField;
import edu.uml.lgdc.project.IllegalDataFieldException;

public class DoubleField
extends NumericField {
    private double doubleValue;

    public DoubleField(FieldDesc fieldDesc) {
        super(fieldDesc);
        this.checkFieldDesc();
    }

    public DoubleField(FieldDesc fieldDesc, double value) {
        super(fieldDesc);
        this.checkFieldDesc();
        this.put(value);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof DoubleField) {
            DoubleField field = (DoubleField)obj;
            if (this.valueSet && field.valueSet && this.doubleValue == field.doubleValue) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object get() {
        this.checkValueSet();
        return new Double(this.doubleValue);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void put(Object obj) {
        err = 0;
        if (!IntegerField.class.isInstance(obj) && !LongField.class.isInstance(obj) && !DoubleField.class.isInstance(obj)) ** GOTO lbl7
        if (!((ProField)obj).isValueSet()) {
            err = 2;
        } else {
            obj = ((ProField)obj).get();
lbl7:
            // 2 sources

            if (Double.class.isInstance(obj)) {
                this.doubleValue = (Double)obj;
            } else if (Long.class.isInstance(obj)) {
                this.doubleValue = ((Long)obj).longValue();
            } else if (Integer.class.isInstance(obj)) {
                this.doubleValue = ((Integer)obj).intValue();
            } else {
                err = 1;
            }
        }
        if (err == 1) {
            throw new RuntimeException("Not a Double, Long, or Integer type");
        }
        if (err == 2) {
            throw new RuntimeException("Value is not set");
        }
        this.valueSet = true;
    }

    @Override
    public String check(Object objValue) {
        double value;
        if (Double.class.isInstance(objValue)) {
            value = (Double)objValue;
        } else if (Long.class.isInstance(objValue)) {
            value = ((Long)objValue).longValue();
        } else if (Integer.class.isInstance(objValue)) {
            value = ((Integer)objValue).intValue();
        } else {
            throw new RuntimeException("Not a Double, Long or Integer type");
        }
        return this.check(value);
    }

    @Override
    public String extract(byte[] data, int byteOffset, int bitOffset) throws IllegalDataFieldException {
        double internalVal = -2.147483648E9;
        String errMsg = null;
        if (this.fieldDesc.isBinaryNumber()) {
            internalVal = this.fieldDesc.extractInt(data, byteOffset, bitOffset);
        } else {
            errMsg = this.fieldDesc.checkEncodedNumber(data, byteOffset);
            if (errMsg == null) {
                internalVal = this.fieldDesc.decodeNumber(data, byteOffset);
            }
        }
        if (errMsg == null) {
            errMsg = this.fieldDesc.checkInt(internalVal);
        }
        if (errMsg == null) {
            this.doubleValue = this.fieldDesc.get(internalVal);
            this.valueSet = true;
        }
        return errMsg;
    }

    @Override
    public void pack(byte[] data, int byteOffset, int bitOffset) throws IllegalDataFieldException {
        this.checkValueSet();
        if (this.fieldDesc.isBinaryNumber()) {
            this.fieldDesc.packInt(this.fieldDesc.getInt(this.doubleValue), data, byteOffset, bitOffset);
        } else {
            this.fieldDesc.EncodeNumber((int)this.fieldDesc.getInt(this.doubleValue), data, byteOffset);
        }
    }

    @Override
    public double doubleValue() {
        this.checkValueSet();
        return this.doubleValue;
    }

    @Override
    public void put(double value) {
        this.doubleValue = value;
        this.valueSet = true;
    }

    @Override
    public String check(double value) {
        return this.fieldDesc.checkExt(value);
    }

    @Override
    public long longValue() {
        this.checkValueSet();
        return (long)this.doubleValue;
    }

    @Override
    public void put(long value) {
        this.put(value);
    }

    @Override
    public String check(long value) {
        return this.fieldDesc.checkExt(value);
    }

    public int hashCode() {
        return new Double(this.doubleValue).hashCode();
    }

    private void checkFieldDesc() {
        if (this.fieldDesc.getExtType() != ExternalType.E_TYPE_DOUBLE) {
            throw new RuntimeException("External type should be Double for Double Field");
        }
    }
}

