/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype.field;

import edu.uml.lgdc.datatype.field.ArrayOfProFields;
import edu.uml.lgdc.datatype.field.IntegerField;

public class FA_Switches
extends ArrayOfProFields<IntegerField> {
    private static final boolean PACKED = true;
    private int numberOfSwitches;

    public FA_Switches(String mnemonic, String name, int numberOfSwitches, IntegerField field) {
        super(mnemonic, name, field, numberOfSwitches, true);
        this.numberOfSwitches = numberOfSwitches;
    }

    public void changeNumberOfSwitches(int newNumberOfSwitches) {
        if (newNumberOfSwitches < 0) {
            throw new IllegalArgumentException("newNumberOfSwitches is negative");
        }
        if (newNumberOfSwitches > this.numberOfSwitches) {
            throw new IllegalArgumentException("newNumberOfSwitches > oldNumberOfSwitches");
        }
        if (newNumberOfSwitches < this.numberOfSwitches) {
            this.numberOfSwitches = newNumberOfSwitches;
            this.changeArraySize(newNumberOfSwitches);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof FA_Switches) {
            int i;
            FA_Switches swFld = (FA_Switches)obj;
            boolean[] sw1 = this.getSwitches();
            boolean[] sw2 = swFld.getSwitches();
            int minSize = Math.min(sw1.length, sw2.length);
            if (sw1.length != sw2.length) {
                boolean[] sw = sw1.length < sw2.length ? sw2 : sw1;
                i = minSize;
                while (i < sw.length) {
                    if (sw[i]) {
                        return false;
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < minSize) {
                if (sw1[i] != sw2[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean getSwitch(int index) {
        this.checkIndex(index);
        return this.intValue(index) != 0;
    }

    public void putSwitch(int index, boolean value) {
        this.checkIndex(index);
        this.put(index, value ? 1 : 0);
    }

    public boolean[] getSwitches() {
        boolean[] switches = new boolean[this.numberOfSwitches];
        int i = 0;
        while (i < this.numberOfSwitches) {
            switches[i] = this.getSwitch(i);
            ++i;
        }
        return switches;
    }

    public void putSwitches(boolean[] switches) {
        if (switches.length < this.numberOfSwitches) {
            throw new IllegalArgumentException("length of array, " + switches.length + ", less than number of switches, " + this.numberOfSwitches);
        }
        int i = 0;
        while (i < this.numberOfSwitches) {
            this.putSwitch(i, switches[i]);
            ++i;
        }
        this.setValueSet();
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.numberOfSwitches) {
            throw new IllegalArgumentException("index out of range, " + index);
        }
    }
}

