/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype.field;

import edu.uml.lgdc.datatype.field.DoubleField;
import edu.uml.lgdc.datatype.field.ExternalType;
import edu.uml.lgdc.datatype.field.FieldDesc;
import edu.uml.lgdc.datatype.field.IntegerField;
import edu.uml.lgdc.datatype.field.NumericField;
import edu.uml.lgdc.datatype.field.ProField;
import edu.uml.lgdc.project.IllegalDataFieldException;

public class LongField
extends NumericField {
    private long longValue;

    public LongField(FieldDesc fieldDesc) {
        super(fieldDesc);
        this.checkFieldDesc();
    }

    public LongField(FieldDesc fieldDesc, int value) {
        super(fieldDesc);
        this.checkFieldDesc();
        this.put(value);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof LongField) {
            LongField field = (LongField)obj;
            if (this.valueSet && field.valueSet && this.longValue == field.longValue) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object get() {
        this.checkValueSet();
        return new Long(this.longValue);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void put(Object obj) {
        block12: {
            block14: {
                block13: {
                    block11: {
                        err = 0;
                        if (IntegerField.class.isInstance(obj) || LongField.class.isInstance(obj) || DoubleField.class.isInstance(obj)) {
                            obj = ((ProField)obj).get();
                        }
                        if (!Long.class.isInstance(obj)) break block11;
                        this.longValue = (Long)obj;
                        break block12;
                    }
                    if (!Double.class.isInstance(obj)) break block13;
                    this.longValue = (long)((Double)obj).doubleValue();
                    break block12;
                }
                if (!Integer.class.isInstance(obj)) break block14;
                this.longValue = ((Integer)obj).intValue();
                break block12;
            }
            if (!NumericField.class.isInstance(obj)) ** GOTO lbl-1000
            if (!((ProField)obj).isValueSet()) {
                err = 2;
            } else if (LongField.class.isInstance(obj)) {
                this.longValue = ((LongField)obj).longValue();
            } else if (DoubleField.class.isInstance(obj)) {
                this.longValue = (long)((DoubleField)obj).doubleValue();
            } else if (IntegerField.class.isInstance(obj)) {
                this.longValue = ((IntegerField)obj).intValue();
            } else lbl-1000:
            // 2 sources

            {
                err = 1;
            }
        }
        if (err == 1) {
            throw new RuntimeException("Not a Long, Double or Integer type");
        }
        if (err == 2) {
            throw new RuntimeException("Value is not set");
        }
        this.valueSet = true;
    }

    @Override
    public String check(Object objValue) {
        long value;
        if (Long.class.isInstance(objValue)) {
            value = (Long)objValue;
        } else if (Double.class.isInstance(objValue)) {
            value = (long)((Double)objValue).doubleValue();
        } else if (Integer.class.isInstance(objValue)) {
            value = ((Integer)objValue).intValue();
        } else {
            throw new RuntimeException("Not a Long, Double or Integer type");
        }
        return this.check(value);
    }

    @Override
    public String extract(byte[] data, int byteOffset, int bitOffset) throws IllegalDataFieldException {
        double internalVal = -9.223372036854776E18;
        String errMsg = null;
        if (this.fieldDesc.isBinaryNumber()) {
            internalVal = this.fieldDesc.extractInt(data, byteOffset, bitOffset);
        } else {
            errMsg = this.fieldDesc.checkEncodedNumber(data, byteOffset);
            if (errMsg == null) {
                internalVal = this.fieldDesc.decodeNumber(data, byteOffset);
            }
        }
        if (errMsg == null) {
            errMsg = this.fieldDesc.checkInt(internalVal);
        }
        if (errMsg == null) {
            this.longValue = (long)this.fieldDesc.get(internalVal);
            this.valueSet = true;
        }
        return errMsg;
    }

    @Override
    public void pack(byte[] data, int byteOffset, int bitOffset) throws IllegalDataFieldException {
        this.checkValueSet();
        if (this.fieldDesc.isBinaryNumber()) {
            this.fieldDesc.packInt(this.fieldDesc.getInt(this.longValue), data, byteOffset, bitOffset);
        } else {
            this.fieldDesc.EncodeNumber((int)this.fieldDesc.getInt(this.longValue), data, byteOffset);
        }
    }

    @Override
    public long longValue() {
        this.checkValueSet();
        return this.longValue;
    }

    @Override
    public void put(long value) {
        this.longValue = value;
        this.valueSet = true;
    }

    @Override
    public String check(long value) {
        return this.fieldDesc.checkExt(value);
    }

    public String check(long[] values) {
        if (values == null) {
            return null;
        }
        String errMsg = null;
        int i = 0;
        while (i < values.length) {
            errMsg = this.fieldDesc.checkExt(values[i]);
            if (errMsg != null) {
                errMsg = "element " + i + " is incorrect:" + "\n" + errMsg;
                break;
            }
            ++i;
        }
        return errMsg;
    }

    @Override
    public double doubleValue() {
        return this.longValue;
    }

    @Override
    public void put(double value) {
        this.put((long)value);
    }

    @Override
    public String check(double value) {
        return this.check((long)value);
    }

    public int hashCode() {
        return (int)(this.longValue ^ this.longValue >>> 32);
    }

    private void checkFieldDesc() {
        if (this.fieldDesc.getExtType() != ExternalType.E_TYPE_LONG) {
            throw new RuntimeException("External type should be Long for Long Field!");
        }
    }
}

