/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype.field;

import edu.uml.lgdc.format.Formatter;
import edu.uml.lgdc.project.IllegalDataFieldException;
import edu.uml.lgdc.quantities.Units;

public abstract class ProField
implements Cloneable {
    public static final String FILL_MNEM = "_FILL_";
    protected static final String MSG_VALUE_NOT_SET = "Value is not set";
    public static final int EXPORT_LEVEL_ALL = 1;
    public static final int EXPORT_LEVEL_NAMES_ONLY = 2;
    public static final int EXPORT_LEVEL_VALUES_ONLY = 3;
    private static final int MIN_LENGTH = 10;
    protected boolean valueSet = false;

    public abstract String getMnemonic();

    public abstract String getName();

    public boolean isValueSet() {
        return this.valueSet;
    }

    public void setValueSet() {
        this.valueSet = true;
    }

    public ProField clone() {
        try {
            return (ProField)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public Object shallowClone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isFiller() {
        return false;
    }

    public abstract boolean getAligned();

    public abstract void clearValue();

    public abstract Object get();

    public abstract void put(Object var1);

    public abstract String check(Object var1);

    public abstract String extract(byte[] var1, int var2, int var3) throws IllegalDataFieldException;

    public abstract void pack(byte[] var1, int var2, int var3) throws IllegalDataFieldException;

    public abstract int getLengthInBits();

    public abstract int getMinLengthInBits();

    public abstract int getMaxLengthInBits();

    public abstract void calcOffset(int var1, int var2);

    public abstract String getMnemonicOfUnset(String var1);

    public String check() {
        if (this.isValueSet()) {
            return this.check(this.get());
        }
        return "Value not set: " + this.getMnemonicOfUnset();
    }

    public String getMnemonicOfUnset() {
        return this.getMnemonicOfUnset("");
    }

    public String getFullNameOfUnset() {
        String mn = this.getMnemonicOfUnset("");
        if (mn != null) {
            return this.getFullNameByFullMnemonic(mn);
        }
        return null;
    }

    public String getFullNameByFullMnemonic(String mn) {
        return null;
    }

    public String extract(byte[] data) throws IllegalDataFieldException {
        return this.extract(data, 0);
    }

    public String extract(byte[] data, int byteOffset) throws IllegalDataFieldException {
        return this.extract(data, byteOffset, 0);
    }

    public void pack(byte[] data) throws IllegalDataFieldException {
        this.pack(data, 0);
    }

    public void pack(byte[] data, int byteOffset) throws IllegalDataFieldException {
        this.pack(data, byteOffset, 0);
    }

    public void calcOffset() {
        this.calcOffset(0);
    }

    public void calcOffset(int byteOffset) {
        this.calcOffset(byteOffset, 0);
    }

    public int getWholeBytesLength() {
        return this.getLengthInBits() / 8;
    }

    public int getRoundUpBytesLength() {
        return (this.getLengthInBits() + 8 - 1) / 8;
    }

    public int getMinWholeBytesLength() {
        return this.getMinLengthInBits() / 8;
    }

    public int getMaxWholeBytesLength() {
        return this.getMaxLengthInBits() / 8;
    }

    public int getExtraBitsLength() {
        return this.getLengthInBits() % 8;
    }

    public int getMinExtraBitsLength() {
        return this.getMinLengthInBits() % 8;
    }

    public int getMaxExtraBitsLength() {
        return this.getMaxLengthInBits() % 8;
    }

    public int getMinRoundUpBytesLength() {
        return (this.getMinLengthInBits() + 8 - 1) / 8;
    }

    public int getMaxRoundUpBytesLength() {
        return (this.getMaxLengthInBits() + 8 - 1) / 8;
    }

    public boolean isVariableSize() {
        return this.getMaxLengthInBits() != this.getMinLengthInBits();
    }

    protected void checkValueSet() {
        if (!this.isValueSet()) {
            throw new RuntimeException("Value is not set, " + this.getMnemonic());
        }
    }

    protected abstract String getStrValue();

    protected abstract Units getIntUnits();

    public abstract String getDescription();

    public String toString() {
        return this.textExport(0, "");
    }

    public String textExport(int level, String indention) {
        if (level == 2) {
            if (this.getStrValue() == null) {
                return " " + this.getMnemonic();
            }
            if (this.getMnemonic().length() >= 10) {
                return " " + this.getMnemonic();
            }
            return " " + Formatter.format("%1$#10s", this.getMnemonic());
        }
        if (level == 3) {
            if (this.getStrValue() == null) {
                return " " + Formatter.format("%1$#" + this.getMnemonic().length() + "s", "");
            }
            if (this.getMnemonic().length() >= 10) {
                return " " + Formatter.format("%1$#" + this.getMnemonic().length() + "s", this.getStrValue());
            }
            return " " + Formatter.format("%1$#10s", this.getStrValue());
        }
        StringBuffer sb = new StringBuffer(256);
        sb.append(indention).append(this.getName());
        String value = this.getStrValue();
        if (value != null) {
            sb.append(" ").append(value);
        }
        if (level == 1) {
            Units units = this.getIntUnits();
            if (units != null && value != null) {
                sb.append(", Units: ").append(units.getName());
                sb.append(", Max Length in Bits: ").append(this.getMaxLengthInBits());
            }
            sb.append(", Mnemonic: ").append(this.getMnemonic());
            String description = this.getDescription();
            if (description != null && description.trim().length() > 0) {
                sb.append(", Description: ").append(description.replaceAll("\\n", "; ").replaceAll("\\r", ""));
            }
        }
        return sb.toString();
    }
}

