/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype.field;

import edu.uml.lgdc.datatype.field.Field;
import edu.uml.lgdc.datatype.field.FieldDesc;
import edu.uml.lgdc.datatype.field.InternalType;
import edu.uml.lgdc.datatype.field.ProField;
import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.format.StrDecoder;
import edu.uml.lgdc.format.StrEncoder;

public class StringField
extends Field {
    private static final int VAR_STRING_LENGTH_BYTES = 4;
    private static final int TWO_POWER8 = 256;
    private static final int TWO_POWER16 = 65536;
    private static final int TWO_POWER24 = 0x1000000;
    private static final long TWO_POWER32 = 0x100000000L;
    private String strValue;
    private int lengthInBits;
    private boolean lengthCalculated;

    public StringField(FieldDesc fieldDesc) {
        super(fieldDesc);
        this.checkFieldDesc();
    }

    public StringField(FieldDesc fieldDesc, String value) {
        super(fieldDesc);
        this.checkFieldDesc();
        this.put(value);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof StringField) {
            StringField field = (StringField)obj;
            if (this.valueSet && field.valueSet && this.strValue.equals(field.strValue)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void clearValue() {
        super.clearValue();
        this.lengthCalculated = false;
    }

    @Override
    public Object get() {
        this.checkValueSet();
        return this.strValue;
    }

    @Override
    public void put(Object obj) {
        if (StringField.class.isInstance(obj)) {
            if (!((ProField)obj).isValueSet()) {
                throw new RuntimeException("Value is not set");
            }
            this.strValue = (String)((StringField)obj).get();
        } else if (String.class.isInstance(obj)) {
            this.strValue = (String)obj;
        } else {
            throw new RuntimeException("Not a String type");
        }
        this.valueSet = true;
        this.lengthCalculated = false;
    }

    @Override
    public String check(Object obj) {
        if (!String.class.isInstance(obj)) {
            throw new RuntimeException("Not a String type");
        }
        String value = (String)obj;
        return this.check(value);
    }

    @Override
    public String extract(byte[] data, int byteOffset, int bitOffset) {
        if (bitOffset != 0) {
            throw new RuntimeException("Parameter bitOffset should be equal to 0 for string field");
        }
        int lenLength = this.fieldDesc.isStrLengthRestricted() ? StringField.getStrBytesLenCodedFieldLengthFromMaxStrLength(this.fieldDesc.getMaxStrLength()) : 4;
        int byteLen = FC.bytes2Int(data, byteOffset, lenLength);
        this.strValue = StrDecoder.runISO_8859_1(data, byteOffset + lenLength, byteLen);
        this.valueSet = true;
        this.lengthInBits = 8 * (lenLength + byteLen);
        this.lengthCalculated = true;
        return null;
    }

    @Override
    public void pack(byte[] data, int byteOffset, int bitOffset) {
        if (bitOffset != 0) {
            throw new RuntimeException("Parameter bitOffset should be equal to 0 for string field");
        }
        this.checkValueSet();
        int lenLength = !this.fieldDesc.isStrLengthRestricted() ? 4 : StringField.getStrBytesLenCodedFieldLengthFromMaxStrLength(this.fieldDesc.getMaxStrLength());
        FC.convertInt2Bytes(this.strValue.length(), data, byteOffset, lenLength);
        StrEncoder.runISO_8859_1(this.strValue, data, byteOffset + lenLength, false);
        if (!this.lengthCalculated) {
            this.lengthInBits = 8 * (lenLength + this.strValue.length());
            this.lengthCalculated = true;
        }
    }

    @Override
    public int getLengthInBits() {
        this.checkValueSet();
        int strLen = this.strValue.length();
        int lenLength = !this.fieldDesc.isStrLengthRestricted() ? 4 : StringField.getStrBytesLenCodedFieldLengthFromMaxStrLength(this.fieldDesc.getMaxStrLength());
        this.lengthInBits = 8 * (lenLength + strLen);
        this.lengthCalculated = true;
        return this.lengthInBits;
    }

    @Override
    public int getMinLengthInBits() {
        long minLenInBytes = 0L;
        int lenLen = !this.fieldDesc.isStrLengthRestricted() ? 4 : StringField.getStrBytesLenCodedFieldLengthFromMaxStrLength(this.fieldDesc.getMaxStrLength());
        String[] choices = null;
        if (this.fieldDesc.isCodeWasSet()) {
            choices = this.fieldDesc.getStrCodes();
        } else if (this.fieldDesc.isSetSet()) {
            choices = this.fieldDesc.getStrSet();
        }
        if (choices != null) {
            if (choices.length > 0) {
                minLenInBytes = choices[0].length();
                int i = 0;
                while (i < choices.length) {
                    if ((long)choices[i].length() < minLenInBytes) {
                        minLenInBytes = choices[i].length();
                    }
                    ++i;
                }
            }
            minLenInBytes += (long)lenLen;
        } else {
            minLenInBytes = lenLen;
        }
        return (int)(8L * minLenInBytes);
    }

    @Override
    public int getMaxLengthInBits() {
        long maxLenInBytes = 0L;
        int lenLen = !this.fieldDesc.isStrLengthRestricted() ? 4 : StringField.getStrBytesLenCodedFieldLengthFromMaxStrLength(this.fieldDesc.getMaxStrLength());
        String[] choices = null;
        if (this.fieldDesc.isCodeWasSet()) {
            choices = this.fieldDesc.getStrCodes();
        } else if (this.fieldDesc.isSetSet()) {
            choices = this.fieldDesc.getStrSet();
        }
        if (choices == null) {
            switch (lenLen) {
                case 1: {
                    maxLenInBytes = 256L;
                    break;
                }
                case 2: {
                    maxLenInBytes = 65537L;
                    break;
                }
                case 3: {
                    maxLenInBytes = 0x1000002L;
                    break;
                }
                case 4: {
                    maxLenInBytes = 0x100000003L;
                }
            }
        } else {
            if (choices.length > 0) {
                maxLenInBytes = choices[0].length();
                int i = 0;
                while (i < choices.length) {
                    if ((long)choices[i].length() > maxLenInBytes) {
                        maxLenInBytes = choices[i].length();
                    }
                    ++i;
                }
            }
            maxLenInBytes += (long)lenLen;
        }
        return (int)(8L * maxLenInBytes);
    }

    public int hashCode() {
        return this.strValue.hashCode();
    }

    public String check(String value) {
        return this.fieldDesc.checkExt(value);
    }

    public static int getStrBytesLenCodedFieldLengthFromMaxStrLength(int strLength) {
        if (strLength < 256) {
            return 1;
        }
        if (strLength < 65536) {
            return 2;
        }
        if (strLength < 0x1000000) {
            return 3;
        }
        return 4;
    }

    private void checkFieldDesc() {
        if (this.fieldDesc.getIntType() != InternalType.I_TYPE_STRING) {
            throw new RuntimeException("Internal type should be String for String Field");
        }
    }
}

