/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype.geom;

import edu.uml.lgdc.datatype.geom.Equivalence;
import edu.uml.lgdc.datatype.geom.R2;
import edu.uml.lgdc.datatype.geom.SetFinite;
import edu.uml.lgdc.datatype.geom.SetR2Finite;

class DistanceCoherenceEquivalence
implements Equivalence {
    private SetR2Finite set;
    private double distance;

    public DistanceCoherenceEquivalence(SetR2Finite set, double distance) {
        this.set = set;
        this.distance = distance;
    }

    @Override
    public boolean equal(Object obj1, Object obj2) {
        boolean result = true;
        SetFinite equivSet = null;
        if (!obj1.equals(obj2)) {
            equivSet = this.addEquivalent(obj1);
            result = equivSet.contains(obj2);
        }
        return result;
    }

    @Override
    public SetFinite addEquivalent(Object element) {
        SetR2Finite equivSet = new SetR2Finite((R2)element);
        SetFinite theRest = SetFinite.subtract(this.set, equivSet);
        SetR2Finite justAdded = equivSet;
        while ((justAdded = this.getEquivalent(justAdded, theRest)).quantity() != 0) {
            equivSet.add(justAdded);
            theRest.notCommon(justAdded);
        }
        return equivSet;
    }

    private SetR2Finite getEquivalent(SetR2Finite center, SetFinite set) {
        SetR2Finite equiv = new SetR2Finite();
        int i = 0;
        while (i < set.quantity()) {
            if (center.distance((R2)set.get(i)) <= this.distance) {
                equiv.add(set.get(i));
            }
            ++i;
        }
        return equiv;
    }
}

