/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype.geom;

import edu.uml.lgdc.datatype.geom.LineSegment2D;
import edu.uml.lgdc.datatype.geom.R2;
import edu.uml.lgdc.datatype.geom.Rn;
import edu.uml.lgdc.datatype.geom.SetR2Analytical;
import edu.uml.lgdc.datatype.geom.SetR2Finite;
import edu.uml.lgdc.datatype.geom.ZigzagLine2D;
import edu.uml.lgdc.math.ExtMath;
import java.util.Objects;
import java.util.Set;

public class Line2D
extends SetR2Analytical {
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_UNDEF = 1;
    public static final int TYPE_EMPTY = 2;
    public static final String[] TYPE_NAME = new String[]{"NORMAL_LINE", "UNDEFINED_LINE", "EMPTY_LINE"};
    private static final double SMALL_NUMBER = 1.0E-7;
    private double a;
    private double b;
    private double c;
    private R2 point1;
    private R2 point2;
    private int type = 1;

    public Line2D(double a, double b, double c) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.normalize();
    }

    public Line2D(Line2D sLine) {
        this(sLine.a, sLine.b, sLine.c);
        this.point1 = sLine.point1;
        this.point2 = sLine.point2;
    }

    public Line2D(R2 p1, R2 p2) {
        Objects.requireNonNull(p1);
        Objects.requireNonNull(p2);
        if (!Rn.areClose(p1, p2, 1.0E-7)) {
            this.point1 = p1;
            this.point2 = p2;
            if (p1.getY() != p2.getY()) {
                this.a = 1.0;
                this.b = -(p2.getX() - p1.getX()) / (p2.getY() - p1.getY());
                this.c = -p1.getX() - this.b * p1.getY();
            } else {
                this.a = 0.0;
                this.b = 1.0;
                this.c = -p1.getY();
            }
        } else {
            this.a = 0.0;
            this.b = 0.0;
            this.c = 1.0;
        }
        this.normalize();
    }

    public int getType() {
        return this.type;
    }

    public double calcValueAtPoint(R2 p) {
        return this.a * p.getX() + this.b * p.getY() + this.c;
    }

    @Override
    public boolean contains(Object element) {
        if (element instanceof R2) {
            return this.contains((R2)element);
        }
        return false;
    }

    @Override
    public boolean includes(Object object) {
        Objects.requireNonNull(object);
        boolean result = false;
        if (this.type == 0) {
            if (object instanceof SetR2Analytical) {
                if (object instanceof LineSegment2D) {
                    result = this.includes((LineSegment2D)object);
                } else if (object instanceof ZigzagLine2D) {
                    result = this.includes((ZigzagLine2D)object);
                } else if (object instanceof Line2D) {
                    result = this.includes((Line2D)object);
                }
            } else if (object instanceof SetR2Finite) {
                result = super.includes((SetR2Finite)object);
            } else if (object instanceof R2) {
                result = this.contains((R2)object);
            } else {
                throw new IllegalArgumentException("illegal type: " + object.getClass().getName());
            }
        }
        return result;
    }

    protected boolean contains(R2 point) {
        return ExtMath.areClose(this.calcValueAtPoint(point), 0.0, 1.0E-7);
    }

    protected boolean includes(LineSegment2D segment) {
        return this.contains(segment.getStart()) && this.contains(segment.getEnd());
    }

    protected boolean includes(Line2D sLine) {
        return this.equals(sLine);
    }

    protected boolean includes(ZigzagLine2D zigzag) {
        int i = 0;
        while (i < zigzag.qtyOfVertices()) {
            if (!this.contains(zigzag.getVertex(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public double distance(R2 p) {
        if (!this.contains(p)) {
            if (this.type == 0) {
                return Math.abs(this.calcValueAtPoint(p));
            }
            if (this.type == 2) {
                return Double.MAX_VALUE;
            }
            return Double.NaN;
        }
        return 0.0;
    }

    public static Line2D getLineUsingPointAndVector(R2 point, R2 vector) {
        return new Line2D(point, new R2(vector).add(point));
    }

    public Line2D getParallel(R2 point) {
        if (this.type == 0) {
            return Line2D.getLineUsingPointAndVector(point, new R2(-this.b, this.a));
        }
        return null;
    }

    public Line2D getPerpendicular(R2 point) {
        if (this.type == 0) {
            return Line2D.getLineUsingPointAndVector(point, new R2(this.a, this.b));
        }
        return null;
    }

    public R2 projection(R2 point) {
        if (this.type == 0) {
            return (R2)this.intersection(this.getPerpendicular(point));
        }
        return null;
    }

    public R2 direction(R2 p1, R2 p2) {
        if (this.type == 0) {
            return this.projection(p2).subtract(this.projection(p1));
        }
        return null;
    }

    public Object intersection(Line2D sLine) {
        Object object = null;
        if (this.type == 0 && sLine.type == 0) {
            if (!this.equals(sLine)) {
                double det = this.a * sLine.b - this.b * sLine.a;
                if (!ExtMath.areClose(det, 0.0, 1.0E-7)) {
                    double x = (-this.c * sLine.b + this.b * sLine.c) / det;
                    double y = (-this.a * sLine.c + this.c * sLine.a) / det;
                    object = new R2(x, y);
                }
            } else {
                object = new Line2D(sLine);
            }
        }
        return object;
    }

    public Object intersection(LineSegment2D segment) {
        return segment.intersection(this);
    }

    public Set<Object> intersection(ZigzagLine2D zigzagLine) {
        return zigzagLine.intersection(this);
    }

    public R2 mirror(R2 point) {
        return this.projection(point).subtract(point).scalar(2.0).add(point);
    }

    public boolean areRayConnected(R2 point1, R2 point2) {
        if (this.type == 0) {
            if (!this.contains(point1) && !this.contains(point2)) {
                double val1 = this.calcValueAtPoint(point1);
                double val2 = this.calcValueAtPoint(point2);
                return Math.signum(val1) == Math.signum(val2);
            }
            return false;
        }
        return true;
    }

    public R2 getReflection(R2 point1, R2 point2) {
        if (this.areRayConnected(point1, point2)) {
            return (R2)this.intersection(new Line2D(this.mirror(point1), point2));
        }
        return null;
    }

    public int hashCode() {
        return 31 * (31 * Double.hashCode(this.a) + Double.hashCode(this.b) + Double.hashCode(this.c));
    }

    public boolean equals(Object object) {
        if (this.type == 1) {
            return false;
        }
        if (object instanceof Line2D) {
            Line2D other = (Line2D)object;
            if (this.type == other.type) {
                if (other.type == 0) {
                    return ExtMath.areClose(this.a, other.a, 1.0E-7) && ExtMath.areClose(this.b, other.b, 1.0E-7) && ExtMath.areClose(this.c, other.c, 1.0E-7);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public double squareFitting(R2[] p) {
        return this.squareFitting(p, 0, p.length);
    }

    public double squareFitting(R2[] p, int start, int length) {
        double fit = 0.0;
        int i = start;
        while (i < start + length) {
            double dist = this.distance(p[i]);
            fit += dist * dist;
            ++i;
        }
        return fit;
    }

    public static Line2D leastSquareFitting(R2[] p) {
        return Line2D.leastSquareFitting(p, 0, p.length);
    }

    public static Line2D leastSquareFitting(R2[] p, int start, int length) {
        double bigB;
        Line2D sLine = null;
        double a = 0.0;
        double b = 0.0;
        double fitNonVert = Double.MAX_VALUE;
        boolean nonVertFound = false;
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXX = 0.0;
        double sumYY = 0.0;
        double sumXY = 0.0;
        int i = start;
        while (i < start + length) {
            sumX += p[i].getX();
            sumY += p[i].getY();
            sumXX += p[i].getX() * p[i].getX();
            sumYY += p[i].getY() * p[i].getY();
            sumXY += p[i].getX() * p[i].getY();
            ++i;
        }
        double div = sumX * sumY / (double)length - sumXY;
        if (!ExtMath.areClose(div, 0.0, 1.0E-7)) {
            double temp;
            bigB = 0.5 * (sumYY - sumY * sumY / (double)length - (sumXX - sumX * sumX / (double)length)) / div;
            b = -bigB + Math.sqrt(bigB * bigB + 1.0);
            a = (sumY - b * sumX) / (double)length;
            double b1 = -bigB - Math.sqrt(bigB * bigB + 1.0);
            double a1 = (sumY - b1 * sumX) / (double)length;
            fitNonVert = new Line2D(b, -1.0, a).squareFitting(p, start, length);
            if (fitNonVert > (temp = new Line2D(b1, -1.0, a1).squareFitting(p, start, length))) {
                a = a1;
                b = b1;
                fitNonVert = temp;
            }
            nonVertFound = true;
        } else {
            bigB = sumYY - sumY * sumY / (double)length - (sumXX - sumX * sumX / (double)length);
            if (!ExtMath.areClose(bigB, 0.0, 1.0E-7)) {
                b = 0.0;
                a = sumY / (double)length;
                fitNonVert = new Line2D(b, -1.0, a).squareFitting(p, start, length);
                nonVertFound = true;
            }
        }
        double c = sumX / (double)length;
        double fitVert = 0.0;
        int i2 = start;
        while (i2 < start + length) {
            fitVert += (c - p[i2].getX()) * (c - p[i2].getX());
            ++i2;
        }
        sLine = nonVertFound && fitNonVert < fitVert ? new Line2D(b, -1.0, a) : new Line2D(1.0, 0.0, -c);
        return sLine;
    }

    private void normalize() {
        if (this.a != 0.0 || this.b != 0.0) {
            this.type = 0;
            double temp = Math.sqrt(this.a * this.a + this.b * this.b);
            this.a /= temp;
            this.b /= temp;
            this.c /= temp;
            if (this.a < 0.0) {
                this.a = -this.a;
                this.b = -this.b;
                this.c = -this.c;
            } else if (this.a == 0.0 && this.b < 0.0) {
                this.b = -this.b;
                this.c = -this.c;
            }
        } else if (this.c != 0.0) {
            this.type = 2;
            this.c = 1.0;
        } else {
            this.type = 1;
        }
    }

    public String toString() {
        switch (this.type) {
            case 0: {
                if (this.point1 != null) {
                    return this.point1 + "-" + this.point2;
                }
                return "(" + this.a + "," + this.b + "," + this.c + ")";
            }
            case 1: 
            case 2: {
                return TYPE_NAME[this.type];
            }
        }
        throw new RuntimeException("design error: line type " + this.type + " is illegal");
    }
}

