/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype.geom;

import edu.uml.lgdc.datatype.geom.R2;
import edu.uml.lgdc.datatype.geom.R3;
import edu.uml.lgdc.datatype.geom.Rn;
import edu.uml.lgdc.datatype.geom.SetR3Analytical;
import edu.uml.lgdc.datatype.geom.SetR3Finite;
import edu.uml.lgdc.math.ExtMath;
import java.util.Objects;

public class Line3D
extends SetR3Analytical {
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_UNDEF = 1;
    public static final String[] TYPE_NAME = new String[]{"NORMAL_LINE", "UNDEFINED_LINE"};
    private static final double SMALL_NUMBER = 1.0E-7;
    private R3 point;
    private R3 direction;
    private int type = 1;

    public Line3D(R3 point, R3 direction) {
        this.point = point;
        this.direction = direction;
        this.normalize();
    }

    public int getType() {
        return this.type;
    }

    @Override
    public boolean contains(Object element) {
        if (element instanceof R3) {
            return this.contains((R3)element);
        }
        return false;
    }

    @Override
    public boolean includes(Object object) {
        Objects.requireNonNull(object);
        boolean result = false;
        if (this.type == 0) {
            if (object instanceof SetR3Analytical) {
                if (object instanceof Line3D) {
                    result = this.includes((Line3D)object);
                }
            } else if (object instanceof SetR3Finite) {
                result = super.includes((SetR3Finite)object);
            } else if (object instanceof R3) {
                result = this.contains((R3)object);
            } else {
                throw new IllegalArgumentException("illegal type: " + object.getClass().getName());
            }
        }
        return result;
    }

    protected boolean contains(R3 point) {
        if (!Rn.areClose(point, this.point, 1.0E-7)) {
            return this.equals(new Line3D(this.point, R3.subtract(point, this.point)));
        }
        return true;
    }

    protected boolean includes(Line3D line) {
        return this.equals(line);
    }

    @Override
    public double distance(R3 p) {
        if (!this.contains(p)) {
            if (this.type == 0) {
                return 0.0;
            }
            return Double.NaN;
        }
        return 0.0;
    }

    public boolean equals(Object object) {
        if (this.type == 1) {
            return false;
        }
        if (object instanceof Line3D) {
            Line3D other = (Line3D)object;
            if (this.type == other.type) {
                return Rn.areClose(this.point, this.point, 1.0E-7) && Rn.areClose(this.direction, this.direction, 1.0E-7);
            }
            return false;
        }
        return false;
    }

    private void normalize() {
        if (!Rn.areSmall(this.direction, 1.0E-7)) {
            this.direction.scalar(1.0 / this.direction.length());
            if (this.direction.getX() < 0.0) {
                this.direction.scalar(-1.0);
            } else if (this.direction.getX() == 0.0) {
                if (this.direction.getY() < 0.0) {
                    this.direction.scalar(-1.0);
                } else if (this.direction.getY() == 0.0 && this.direction.getZ() < 0.0) {
                    this.direction.scalar(-1.0);
                }
            }
            if (!ExtMath.areClose(this.direction.getZ(), 0.0, 1.0E-7)) {
                R2 p2;
                R2 p1 = new R2(this.point.getX(), this.point.getY());
                if (Rn.areClose(p1, p2 = new R2(this.point.getX() + this.direction.getX(), this.point.getY() + this.direction.getY()), 1.0E-7)) {
                    double tan = Math.sqrt(this.direction.getX() * this.direction.getX() + this.direction.getY() * this.direction.getY()) / this.direction.getZ();
                    double projLength = Math.abs(this.point.getZ() * tan);
                    if (Math.abs(this.point.getZ() + this.direction.getZ()) > Math.abs(this.point.getZ())) {
                        projLength = -projLength;
                    }
                    R2 proj = p2.subtract(p1).normalize().scalar(projLength);
                    this.point = new R3(proj.getX(), proj.getY(), 0.0);
                } else {
                    this.point = new R3(this.point.getX(), this.point.getY(), 0.0);
                }
            } else if (!ExtMath.areClose(this.direction.getY(), 0.0, 1.0E-7)) {
                R2 p2;
                R2 p1 = new R2(this.point.getX(), this.point.getZ());
                if (Rn.areClose(p1, p2 = new R2(this.point.getX() + this.direction.getX(), this.point.getZ() + this.direction.getZ()), 1.0E-7)) {
                    double tan = Math.sqrt(this.direction.getX() * this.direction.getX() + this.direction.getZ() * this.direction.getZ()) / this.direction.getY();
                    double projLength = Math.abs(this.point.getY() * tan);
                    if (Math.abs(this.point.getY() + this.direction.getY()) > Math.abs(this.point.getY())) {
                        projLength = -projLength;
                    }
                    R2 proj = p2.subtract(p1).normalize().scalar(projLength);
                    this.point = new R3(proj.getX(), 0.0, proj.getY());
                } else {
                    this.point = new R3(this.point.getX(), 0.0, this.point.getZ());
                }
            } else {
                R2 p2;
                R2 p1 = new R2(this.point.getY(), this.point.getZ());
                if (Rn.areClose(p1, p2 = new R2(this.point.getY() + this.direction.getY(), this.point.getZ() + this.direction.getZ()), 1.0E-7)) {
                    double tan = Math.sqrt(this.direction.getY() * this.direction.getY() + this.direction.getZ() * this.direction.getZ()) / this.direction.getX();
                    double projLength = Math.abs(this.point.getX() * tan);
                    if (Math.abs(this.point.getX() + this.direction.getX()) > Math.abs(this.point.getX())) {
                        projLength = -projLength;
                    }
                    R2 proj = p2.subtract(p1).normalize().scalar(projLength);
                    this.point = new R3(0.0, proj.getX(), proj.getY());
                } else {
                    this.point = new R3(0.0, this.point.getY(), this.point.getZ());
                }
            }
        } else {
            this.type = 1;
        }
    }
}

