/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype.geom;

import edu.uml.lgdc.datatype.geom.Line2D;
import edu.uml.lgdc.datatype.geom.R2;
import edu.uml.lgdc.datatype.geom.SetR2Analytical;
import edu.uml.lgdc.datatype.geom.SetR2Finite;
import edu.uml.lgdc.datatype.geom.ZigzagLine2D;
import edu.uml.lgdc.math.ExtMath;
import java.util.Objects;
import java.util.Set;

public class LineSegment2D
extends SetR2Analytical {
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_POINT = 1;
    private static final double SMALL_NUMBER = 1.0E-7;
    private R2 p1;
    private R2 p2;
    private double xMin;
    private double xMax;
    private double yMin;
    private double yMax;
    private int type;
    private Line2D sLine;
    private double length = -1.0;

    public LineSegment2D(R2 p1, R2 p2) {
        this.p1 = Objects.requireNonNull(p1);
        this.p2 = Objects.requireNonNull(p2);
        this.normalize();
    }

    @Override
    public boolean contains(Object element) {
        if (element instanceof R2) {
            return this.contains((R2)element);
        }
        return false;
    }

    @Override
    public boolean includes(Object object) {
        Objects.requireNonNull(object);
        boolean result = false;
        if (object instanceof SetR2Analytical) {
            if (object instanceof LineSegment2D) {
                result = this.includes((LineSegment2D)object);
            } else if (object instanceof ZigzagLine2D) {
                result = this.includes((ZigzagLine2D)object);
            } else if (object instanceof Line2D) {
                result = this.includes((Line2D)object);
            }
        } else if (object instanceof SetR2Finite) {
            result = super.includes((SetR2Finite)object);
        } else if (object instanceof R2) {
            result = this.contains((R2)object);
        } else {
            throw new IllegalArgumentException("illegal type: " + object.getClass().getName());
        }
        return result;
    }

    protected boolean contains(R2 p) {
        boolean result = false;
        if (this.type == 0) {
            if ((p.getX() >= this.xMin && p.getX() <= this.xMax || ExtMath.areClose(p.getX(), this.xMin, 1.0E-7) || ExtMath.areClose(p.getX(), this.xMax, 1.0E-7)) && (p.getY() >= this.yMin && p.getY() <= this.yMax || ExtMath.areClose(p.getY(), this.yMin, 1.0E-7) || ExtMath.areClose(p.getY(), this.yMax, 1.0E-7))) {
                result = this.getLine().contains(p);
            }
        } else {
            result = this.p1.equals(p);
        }
        return result;
    }

    protected boolean includes(LineSegment2D segment) {
        boolean result = false;
        if (this.type == segment.type) {
            if (this.type == 0) {
                Line2D sl = this.getLine();
                R2 start = segment.getStart();
                R2 end = segment.getEnd();
                if (sl.contains(start) && sl.contains(end)) {
                    if (this.p1.getX() < this.p2.getX()) {
                        if (this.p1.getX() <= start.getX() && end.getX() <= this.p2.getX()) {
                            result = true;
                        }
                    } else if (this.p1.getY() <= start.getY() && end.getY() <= this.p2.getY()) {
                        result = true;
                    }
                }
            } else {
                result = this.getStart().equals(segment.getStart());
            }
        }
        return result;
    }

    protected boolean includes(Line2D sLine) {
        return sLine.getType() == 2;
    }

    protected boolean includes(ZigzagLine2D zigzag) {
        int i = 0;
        while (i < zigzag.qtyOfVertices()) {
            if (!this.contains(zigzag.getVertex(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getType() {
        return this.type;
    }

    public R2 getStart() {
        return this.p1;
    }

    public R2 getEnd() {
        return this.p2;
    }

    public double getLength() {
        if (this.length < 0.0) {
            this.length = this.p1.dist(this.p2);
        }
        return this.length;
    }

    @Override
    public double distance(R2 p) {
        if (this.type != 1) {
            double dist2;
            Line2D line = this.getLine();
            double segLength = this.getLength();
            R2 proj = line.projection(p);
            double dist1 = proj.dist(this.p1);
            if (dist1 > (dist2 = proj.dist(this.p2))) {
                if (dist1 > segLength) {
                    return p.dist(this.p2);
                }
                return line.distance(p);
            }
            if (dist2 > dist1) {
                if (dist2 > segLength) {
                    return p.dist(this.p1);
                }
                return line.distance(p);
            }
            return line.distance(p);
        }
        return p.dist(this.p1);
    }

    public Object intersection(Line2D sLine) {
        Object object = null;
        if (sLine.getType() == 0) {
            if (sLine.contains(this.p1)) {
                object = sLine.contains(this.p2) ? new LineSegment2D(this.p1, this.p2) : new R2(this.p1);
            } else if (sLine.contains(this.p2)) {
                object = new R2(this.p2);
            } else if (!sLine.areRayConnected(this.p1, this.p2)) {
                object = (R2)sLine.intersection(this.getLine());
            }
        }
        return object;
    }

    public Object intersection(LineSegment2D seg) {
        Object object = this.intersection(seg.getLine());
        if (object != null) {
            if (object instanceof R2) {
                object = seg.intersection(this.getLine());
            } else if (this.contains(seg.p1)) {
                object = this.contains(seg.p2) ? new LineSegment2D(seg.p1, seg.p2) : new LineSegment2D(seg.p1, this.p2);
            } else if (this.contains(seg.p2)) {
                object = new LineSegment2D(this.p1, seg.p2);
            } else if (!seg.contains(this.p1)) {
                object = null;
            }
        }
        return object;
    }

    public Set<Object> intersection(ZigzagLine2D zigzagLine) {
        return zigzagLine.intersection(this);
    }

    public int hashCode() {
        if (this.type == 0) {
            return this.p1.hashCode() + this.p2.hashCode();
        }
        return this.p1.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            return this.p1.equals(((LineSegment2D)object).p1) && this.p2.equals(((LineSegment2D)object).p2);
        }
        return false;
    }

    public Line2D getLine() {
        if (this.sLine == null) {
            this.sLine = new Line2D(this.p1, this.p2);
        }
        return this.sLine;
    }

    public String toString() {
        return this.p1 + "-" + this.p2;
    }

    private void normalize() {
        this.type = 0;
        if (!ExtMath.areClose(this.p1.getX(), this.p2.getX(), 1.0E-7)) {
            if (this.p1.getX() > this.p2.getX()) {
                R2 temp = this.p1;
                this.p1 = this.p2;
                this.p2 = temp;
            }
        } else if (!ExtMath.areClose(this.p1.getY(), this.p2.getY(), 1.0E-7)) {
            if (this.p1.getY() > this.p2.getY()) {
                R2 temp = this.p1;
                this.p1 = this.p2;
                this.p2 = temp;
            }
        } else {
            this.p2 = new R2(this.p1);
            this.type = 1;
        }
        this.xMin = this.p1.getX();
        this.xMax = this.p2.getX();
        this.yMin = Math.min(this.p1.getY(), this.p2.getY());
        this.yMax = Math.max(this.p1.getY(), this.p2.getY());
    }
}

