/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype.geom;

import edu.uml.lgdc.math.ExtMath;
import java.io.Serializable;
import java.util.Arrays;

public class Rn
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final int dim;
    private final double[] x;

    public Rn(double ... x) {
        if (x == null) {
            throw new IllegalArgumentException("x is null");
        }
        if (x.length == 0) {
            throw new IllegalArgumentException("x.length == 0");
        }
        this.x = x;
        this.dim = x.length;
    }

    public Rn(Rn v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        this.dim = v.dim;
        this.x = (double[])v.x.clone();
    }

    protected double distance(Rn point) {
        return Rn.subtract(this, point).length();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return false;
        }
        if (obj instanceof Rn) {
            return Arrays.equals(this.x, ((Rn)obj).x);
        }
        return false;
    }

    public int hashCode() {
        int hashcode = Double.hashCode(this.x[0]);
        int i = 1;
        while (i < this.dim) {
            hashcode += 31 * hashcode + Double.hashCode(this.x[i]);
            ++i;
        }
        return hashcode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("(").append(this.x[0]);
        int i = 1;
        while (i < this.dim) {
            sb.append(",").append(this.x[i]);
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean isZero() {
        int i = 0;
        while (i < this.dim) {
            if (this.x[i] != 0.0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public double get(int n) {
        return this.x[n];
    }

    public void set(int n, double value) {
        this.x[n] = value;
    }

    public Rn setTo(double ... x) {
        if (x == null) {
            throw new IllegalArgumentException("x == null");
        }
        if (x.length != this.dim) {
            throw new IllegalArgumentException("x.length != dim");
        }
        System.arraycopy(x, 0, this.x, 0, this.dim);
        return this;
    }

    public Rn inverse() {
        int i = 0;
        while (i < this.dim) {
            this.x[i] = -this.x[i];
            ++i;
        }
        return this;
    }

    public static Rn inverse(Rn v) {
        return new Rn(v).inverse();
    }

    public Rn add(Rn vector) {
        if (vector == null) {
            throw new IllegalArgumentException("vector == null");
        }
        if (vector.dim != this.dim) {
            throw new IllegalArgumentException("vector.dim != dim");
        }
        int i = 0;
        while (i < this.dim) {
            int n = i;
            this.x[n] = this.x[n] + vector.get(i);
            ++i;
        }
        return this;
    }

    public static Rn add(Rn vector1, Rn vector2) {
        return new Rn(vector1).add(vector2);
    }

    public Rn scalar(double factor) {
        int i = 0;
        while (i < this.dim) {
            int n = i++;
            this.x[n] = this.x[n] * factor;
        }
        return this;
    }

    public static Rn scalar(double factor, Rn vector) {
        return new Rn(vector).scalar(factor);
    }

    public Rn subtract(Rn vector) {
        return this.add(new Rn(vector).inverse());
    }

    public static Rn subtract(Rn vector1, Rn vector2) {
        return new Rn(vector2).inverse().add(vector1);
    }

    public Rn shift(Rn vector) {
        return this.add(vector);
    }

    public Rn shiftAlongAxis(int n, double shiftValue) {
        if (n < 0 || n >= this.dim) {
            throw new IllegalArgumentException("n < 0 || n >= dim, n=" + n);
        }
        int n2 = n;
        this.x[n2] = this.x[n2] + shiftValue;
        return this;
    }

    public double length() {
        double length = this.x[0] * this.x[0];
        int i = 1;
        while (i < this.dim) {
            length += this.x[i] * this.x[i];
            ++i;
        }
        return Math.sqrt(length);
    }

    public double getRadius() {
        return this.length();
    }

    public Rn normalize() {
        double len = this.length();
        if (len > 0.0) {
            this.scalar(1.0 / len);
        }
        return this;
    }

    public static Rn normalize(Rn vector) {
        return new Rn(vector).normalize();
    }

    public double betweenAngle(Rn vector) {
        if (vector == null) {
            throw new IllegalArgumentException("vector == null");
        }
        if (vector.dim != this.dim) {
            throw new IllegalArgumentException("vector.dim != dim");
        }
        double angle = Double.NaN;
        double lengthProduct = this.length() * vector.length();
        if (lengthProduct != 0.0) {
            double cos = this.scalarProduct(vector) / lengthProduct;
            if (cos > 1.0) {
                cos = 1.0;
            } else if (cos < -1.0) {
                cos = -1.0;
            }
            angle = Math.acos(cos);
        }
        return angle;
    }

    public double dotProduct(Rn vector) {
        return this.scalarProduct(vector);
    }

    public static double dotProduct(Rn v1, Rn v2) {
        return Rn.scalarProduct(v1, v2);
    }

    public double scalarProduct(Rn vector) {
        return Rn.scalarProduct(this, vector);
    }

    public static double scalarProduct(Rn vector1, Rn vector2) {
        if (vector1 == null) {
            throw new IllegalArgumentException("vector1 == null");
        }
        if (vector2 == null) {
            throw new IllegalArgumentException("vector2 == null");
        }
        if (vector1.dim != vector2.dim) {
            throw new IllegalArgumentException("vector1.dim != vector2.dim");
        }
        double dotProduct = vector1.x[0] * vector2.x[0];
        int i = 1;
        while (i < vector1.dim) {
            dotProduct += vector1.x[i] * vector2.x[i];
            ++i;
        }
        return dotProduct;
    }

    public Rn applyLinearOperator(double[][] a) {
        if (a == null) {
            throw new IllegalArgumentException("a == null");
        }
        if (a.length != this.dim) {
            throw new IllegalArgumentException("a.length != dim");
        }
        double[] tempX = (double[])this.x.clone();
        int i = 0;
        while (i < this.dim) {
            if (a[i] == null) {
                throw new IllegalArgumentException("a[" + i + "] == null");
            }
            if (a[i].length != this.dim) {
                throw new IllegalArgumentException("a[" + i + "].length != dim");
            }
            this.x[i] = 0.0;
            int j = 0;
            while (j < this.dim) {
                int n = i;
                this.x[n] = this.x[n] + a[i][j] * tempX[j];
                ++j;
            }
            ++i;
        }
        return this;
    }

    public static double diameter(Rn[] points) {
        double diameter = 0.0;
        int numberOfPoints = points.length;
        int i = 0;
        while (i < numberOfPoints - 1) {
            int j = i + 1;
            while (j < numberOfPoints) {
                double dist = points[i].distance(points[j]);
                if (dist > diameter) {
                    diameter = dist;
                }
                ++j;
            }
            ++i;
        }
        return diameter;
    }

    public static boolean areClose(Rn p1, Rn p2, double epsilon) {
        return ExtMath.areClose(p1.distance(p2), 0.0, epsilon);
    }

    public static boolean areSmall(Rn p, double epsilon) {
        return ExtMath.areClose(p.length(), 0.0, epsilon);
    }
}

