/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype.geom;

import edu.uml.lgdc.datatype.geom.DistanceCoherenceEquivalence;
import edu.uml.lgdc.datatype.geom.R2;
import edu.uml.lgdc.datatype.geom.SetFinite;
import edu.uml.lgdc.math.Statistic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SetR2Finite
extends SetFinite {
    public SetR2Finite() {
        this(new R2[0]);
    }

    public SetR2Finite(R2 element) {
        this(new R2[]{element});
    }

    public SetR2Finite(R2[] elements) {
        this.setElements(new ArrayList<Object>(Arrays.asList(elements)));
    }

    public double distance(R2 element) {
        double distance = Double.MAX_VALUE;
        int i = 0;
        while (i < this.quantity()) {
            double temp = element.dist((R2)this.get(i));
            if (temp < distance) {
                distance = temp;
            }
            ++i;
        }
        return distance;
    }

    public List<Object> divideSpots() {
        ArrayList<Object> sets = new ArrayList();
        double threshold = this.calcThresholdDistance();
        DistanceCoherenceEquivalence equiv = new DistanceCoherenceEquivalence(this, threshold);
        this.setEquivalence(equiv);
        sets = this.divide();
        return sets;
    }

    public int[] fastDivideSpots() {
        int[] clusters = new int[this.quantity()];
        double threshold = this.calcThresholdDistance();
        double threshold2 = threshold * threshold;
        int i = 0;
        while (i < clusters.length) {
            clusters[i] = i;
            ++i;
        }
        boolean found = false;
        int i2 = 0;
        while (i2 < clusters.length) {
            if (clusters[i2] == i2) {
                int last = i2;
                do {
                    found = false;
                    int j = i2 + 1;
                    while (j < clusters.length) {
                        if (clusters[j] > i2) {
                            R2 temp = (R2)this.get(j);
                            int k = i2;
                            while (k <= last) {
                                if (clusters[k] == i2) {
                                    double deltaY;
                                    R2 p = (R2)this.get(k);
                                    double deltaX = temp.getX() - p.getX();
                                    if (deltaX * deltaX + (deltaY = temp.getY() - p.getY()) * deltaY <= threshold2) {
                                        clusters[j] = i2;
                                        if (last < j) {
                                            last = j;
                                        }
                                        found = true;
                                        break;
                                    }
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                } while (found);
            }
            ++i2;
        }
        return clusters;
    }

    public int[] xyOrderedFastDivideSpots() {
        int[] clusters = new int[this.quantity()];
        double threshold = this.calcThresholdDistance(true);
        double threshold2 = threshold * threshold;
        int i = 0;
        while (i < clusters.length) {
            clusters[i] = i;
            ++i;
        }
        boolean found = false;
        int i2 = 0;
        while (i2 < clusters.length) {
            if (clusters[i2] == i2) {
                int last = i2;
                double xMax = ((R2)this.get(last)).getX();
                block2: do {
                    found = false;
                    int j = i2 + 1;
                    while (j < clusters.length) {
                        R2 temp = (R2)this.get(j);
                        if (temp.getX() - xMax > threshold) continue block2;
                        if (clusters[j] > i2) {
                            int k = i2;
                            while (k <= last) {
                                if (clusters[k] == i2) {
                                    double deltaY;
                                    R2 p = (R2)this.get(k);
                                    double deltaX = temp.getX() - p.getX();
                                    if (deltaX * deltaX + (deltaY = temp.getY() - p.getY()) * deltaY <= threshold2) {
                                        clusters[j] = i2;
                                        if (last < j) {
                                            last = j;
                                            xMax = ((R2)this.get(last)).getX();
                                        }
                                        found = true;
                                        break;
                                    }
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                } while (found);
            }
            ++i2;
        }
        return clusters;
    }

    public void orderByXY() {
        this.orderByXY(0, this.quantity() - 1);
    }

    private void orderByXY(int l, int r) {
        if (r <= l) {
            return;
        }
        int i = l;
        int j = r;
        R2 v = (R2)this.get((l + r) / 2);
        while (true) {
            if (((R2)this.get(i)).getX() < v.getX() || ((R2)this.get(i)).getX() == v.getX() && ((R2)this.get(i)).getY() < v.getY()) {
                ++i;
                continue;
            }
            while (v.getX() < ((R2)this.get(j)).getX() || v.getX() == ((R2)this.get(j)).getX() && v.getY() < ((R2)this.get(j)).getY()) {
                --j;
            }
            if (i <= j) {
                R2 w = (R2)this.get(i);
                this.elements.set(i, this.get(j));
                this.elements.set(j, w);
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (l < j) {
            this.orderByXY(l, j);
        }
        if (i < r) {
            this.orderByXY(i, r);
        }
    }

    private double calcThresholdDistance() {
        return this.calcThresholdDistance(false);
    }

    private double calcThresholdDistance(boolean ordered) {
        double meanMinDist;
        double visibilityCoeff = 0.51;
        double[] minDists = this.getMinDists(ordered);
        double deviation = Statistic.deviation(minDists, meanMinDist = Statistic.mean(minDists));
        double deltaVisibility = deviation > visibilityCoeff * meanMinDist ? 0.0 : Math.max((1.0 + visibilityCoeff) * deviation, visibilityCoeff * meanMinDist);
        double threshold = meanMinDist + deltaVisibility;
        System.out.println("Average min dist = " + meanMinDist);
        System.out.println("Deviation of min dists = " + deviation);
        System.out.println("Threshold distance = " + threshold);
        return threshold;
    }

    public double getAverageMinDist() {
        return this.getAverageMinDist(false);
    }

    public double getAverageMinDist(boolean ordered) {
        return Statistic.mean(this.getMinDists(ordered));
    }

    public double[] getMinDists() {
        return this.getMinDists(false);
    }

    public double[] getMinDists(boolean ordered) {
        double[] minDists = new double[this.quantity()];
        int i = 0;
        while (i < this.quantity()) {
            minDists[i] = this.getMinDist(i, ordered);
            ++i;
        }
        return minDists;
    }

    public double getMinDist(int i) {
        return this.getMinDist(i, false);
    }

    public double getMinDist(int i, boolean ordered) {
        if (ordered) {
            return this.getMinDistanceForOrdered(i);
        }
        return this.getMinDistance(i);
    }

    private double getMinDistance(int ind) {
        double minDist = -1.0;
        if (ind < 0 || ind >= this.quantity()) {
            return minDist;
        }
        if (this.quantity() == 1) {
            return minDist;
        }
        minDist = Double.MAX_VALUE;
        int i = 0;
        while (i < this.quantity()) {
            double temp;
            if (i != ind && (temp = ((R2)this.get(ind)).dist((R2)this.get(i))) < minDist) {
                minDist = temp;
            }
            ++i;
        }
        return minDist;
    }

    private double getMinDistanceForOrdered(int ind) {
        double temp;
        R2 otherP;
        double thisX;
        double minDist = -1.0;
        if (ind < 0 || ind >= this.quantity()) {
            return minDist;
        }
        if (this.quantity() == 1) {
            return minDist;
        }
        minDist = Double.MAX_VALUE;
        R2 thisP = (R2)this.get(ind);
        double otherX = thisX = thisP.getX();
        int i = ind - 1;
        while (i >= 0) {
            otherP = (R2)this.get(i);
            if (otherP.getX() != otherX && thisX - (otherX = otherP.getX()) >= minDist) break;
            temp = thisP.dist(otherP);
            if (temp < minDist) {
                minDist = temp;
            }
            --i;
        }
        otherX = thisX;
        i = ind + 1;
        while (i < this.quantity()) {
            otherP = (R2)this.get(i);
            if (otherP.getX() != otherX && (otherX = otherP.getX()) - thisX >= minDist) break;
            temp = thisP.dist(otherP);
            if (temp < minDist) {
                minDist = temp;
            }
            ++i;
        }
        return minDist;
    }
}

