/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype.geom;

import edu.uml.lgdc.datatype.geom.Line2D;
import edu.uml.lgdc.datatype.geom.LineSegment2D;
import edu.uml.lgdc.datatype.geom.R2;
import edu.uml.lgdc.datatype.geom.SetR2Analytical;
import edu.uml.lgdc.datatype.geom.SetR2Finite;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class SetR2StraightSets
extends SetR2Analytical {
    private Set<Object> straightSets;

    public SetR2StraightSets() {
    }

    public SetR2StraightSets(Object[] objects) {
        this.normalize(objects);
    }

    @Override
    public boolean contains(Object element) {
        if (element instanceof R2) {
            return this.contains((R2)element);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean includes(Object object) {
        Objects.requireNonNull(object);
        boolean result = false;
        if (object instanceof SetR2Analytical) {
            if (object instanceof LineSegment2D) {
                return this.includes((LineSegment2D)object);
            }
            if (object instanceof Line2D) {
                return this.includes((Line2D)object);
            }
            if (!(object instanceof SetR2StraightSets)) throw new IllegalArgumentException("illegal type: " + object.getClass().getName());
            return this.includes((SetR2StraightSets)object);
        }
        if (object instanceof SetR2Finite) {
            return super.includes((SetR2Finite)object);
        }
        if (!(object instanceof R2)) throw new IllegalArgumentException("illegal type: " + object.getClass().getName());
        return this.contains((R2)object);
    }

    protected boolean contains(R2 point) {
        for (Object object : this.straightSets) {
            if (!(object instanceof LineSegment2D ? ((LineSegment2D)object).contains(point) : (object instanceof R2 ? ((R2)object).equals(point) : object instanceof Line2D && ((Line2D)object).contains(point)))) continue;
            return true;
        }
        return false;
    }

    protected boolean includes(LineSegment2D segment) {
        boolean result = false;
        for (Object object : this.straightSets) {
            if (object instanceof LineSegment2D) {
                if (!((LineSegment2D)object).includes(segment)) continue;
                result = true;
                break;
            }
            if (object instanceof R2) {
                if (segment.getType() != 1 || !((R2)object).equals(segment.getStart())) continue;
                result = true;
                break;
            }
            if (!(object instanceof Line2D) || !((Line2D)object).includes(segment)) continue;
            result = true;
            break;
        }
        return result;
    }

    protected boolean includes(Line2D sLine) {
        boolean result = false;
        if (sLine.getType() == 0) {
            for (Object object : this.straightSets) {
                if (!(object instanceof Line2D) || !((Line2D)object).equals(sLine)) continue;
                result = true;
                break;
            }
        } else if (sLine.getType() == 2) {
            result = true;
        }
        return result;
    }

    public boolean includes(SetR2StraightSets sets) {
        for (Object object : sets.straightSets) {
            if (this.includes(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public double distance(R2 p) {
        double dist = Double.MAX_VALUE;
        for (Object object : this.straightSets) {
            if (object instanceof SetR2Analytical) {
                dist = ((SetR2Analytical)object).distance(p);
                continue;
            }
            if (!(object instanceof R2)) continue;
            dist = ((R2)object).dist(p);
        }
        return dist;
    }

    public int qtyOfSubsets() {
        return this.straightSets.size();
    }

    public Set<Object> intersection(Line2D sLine) {
        HashSet<Object> set = new HashSet<Object>();
        if (sLine.getType() == 0) {
            for (Object subset : this.straightSets) {
                Object object = null;
                if (subset instanceof LineSegment2D) {
                    object = sLine.intersection((LineSegment2D)subset);
                } else if (subset instanceof Line2D) {
                    object = sLine.intersection((Line2D)subset);
                } else if (subset instanceof R2 && sLine.includes(subset)) {
                    object = subset;
                }
                if (object == null) continue;
                set.add(object);
            }
        }
        return set.size() == 0 ? null : set;
    }

    public Set<Object> intersection(LineSegment2D segment) {
        HashSet<Object> set = new HashSet<Object>();
        for (Object subset : this.straightSets) {
            Object object = null;
            if (subset instanceof LineSegment2D) {
                object = segment.intersection((LineSegment2D)subset);
            } else if (subset instanceof Line2D) {
                object = segment.intersection((Line2D)subset);
            } else if (subset instanceof R2 && segment.getType() == 1 && ((R2)subset).equals(segment.getStart())) {
                object = subset;
            }
            if (object == null) continue;
            set.add(object);
        }
        if (set.size() > 0) {
            return new SetR2StraightSets((Object[])set.toArray()).straightSets;
        }
        return null;
    }

    public Set<Object> intersection(SetR2StraightSets sets) {
        HashSet<Object> set = new HashSet<Object>();
        for (Object subset : this.straightSets) {
            Set<Object> tmpObjects = null;
            if (subset instanceof LineSegment2D) {
                tmpObjects = sets.intersection((LineSegment2D)subset);
            } else if (subset instanceof Line2D) {
                tmpObjects = sets.intersection((Line2D)subset);
            } else if (sets.contains(subset)) {
                tmpObjects = new HashSet<Object>(Arrays.asList(subset));
            }
            if (tmpObjects == null) continue;
            set.addAll(tmpObjects);
        }
        return set.size() == 0 ? null : set;
    }

    public boolean containsSet(Object object) {
        return this.straightSets.contains(object);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            return this.straightSets.equals(((SetR2StraightSets)object).straightSets);
        }
        return false;
    }

    private void normalize(Object[] objects) {
        int j;
        int[] clusters = new int[objects.length];
        this.straightSets = new HashSet<Object>();
        int i = 0;
        while (i < clusters.length) {
            clusters[i] = i;
            ++i;
        }
        i = 0;
        while (i < clusters.length - 1) {
            if (i == clusters[i]) {
                Object objForComparing = objects[i];
                boolean foundLine = !(objForComparing instanceof R2);
                j = i + 1;
                while (j < clusters.length) {
                    if (clusters[j] == j && SetR2StraightSets.isOnTheSameLine(objForComparing, objects[j])) {
                        clusters[j] = clusters[i];
                        if (!foundLine && !(objects[j] instanceof R2)) {
                            objForComparing = objects[j];
                            foundLine = true;
                            int k = i + 1;
                            while (k < j) {
                                if (clusters[k] == k && objects[k] instanceof R2 && SetR2StraightSets.isOnTheSameLine(objForComparing, objects[k])) {
                                    clusters[k] = clusters[i];
                                }
                                ++k;
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < clusters.length) {
            if (clusters[i] >= 0) {
                boolean coalesced;
                Object coalescedObj = objects[i];
                block5: do {
                    coalesced = false;
                    j = i + 1;
                    while (j < clusters.length) {
                        Object obj;
                        if (clusters[j] == clusters[i] && (obj = SetR2StraightSets.coalesceOnTheSameLine(coalescedObj, objects[j])) != null) {
                            coalesced = true;
                            coalescedObj = obj;
                            clusters[j] = -1;
                            continue block5;
                        }
                        ++j;
                    }
                } while (coalesced);
                this.straightSets.add(coalescedObj);
            }
            ++i;
        }
    }

    public static boolean isOnTheSameLine(Object object1, Object object2) {
        boolean result = false;
        Line2D sl1 = null;
        Line2D sl2 = null;
        if (object1 instanceof LineSegment2D) {
            sl1 = ((LineSegment2D)object1).getLine();
        } else if (object1 instanceof Line2D) {
            sl1 = (Line2D)object1;
        }
        if (object2 instanceof LineSegment2D) {
            sl2 = ((LineSegment2D)object2).getLine();
        } else if (object2 instanceof Line2D) {
            sl2 = (Line2D)object2;
        }
        if (sl1 != null && sl2 != null) {
            result = sl1.equals(sl2);
        } else if (sl1 != null) {
            if (object2 instanceof R2) {
                result = sl1.contains(object2);
            }
        } else if (sl2 != null) {
            if (object1 instanceof R2) {
                result = sl2.contains(object1);
            }
        } else if (object1 instanceof R2 && object2 instanceof R2) {
            result = object1.equals(object2);
        }
        return result;
    }

    public static Object coalesce(Object object1, Object object2) {
        if (SetR2StraightSets.isOnTheSameLine(object1, object2)) {
            return SetR2StraightSets.coalesceOnTheSameLine(object1, object2);
        }
        return null;
    }

    private static Object coalesceOnTheSameLine(Object object1, Object object2) {
        Object coalescedObject = null;
        if (object1 instanceof LineSegment2D) {
            if (object2 instanceof LineSegment2D) {
                R2 start1 = ((LineSegment2D)object1).getStart();
                R2 end1 = ((LineSegment2D)object1).getEnd();
                R2 start2 = ((LineSegment2D)object2).getStart();
                R2 end2 = ((LineSegment2D)object2).getEnd();
                LineSegment2D[] seg = new LineSegment2D[]{(LineSegment2D)object1, (LineSegment2D)object2};
                int[] resultSegRef = null;
                resultSegRef = start1.getX() < end1.getX() ? SetR2StraightSets.refCoalescedR1Seg(start1.getX(), end1.getX(), start2.getX(), end2.getX()) : SetR2StraightSets.refCoalescedR1Seg(start1.getY(), end1.getY(), start2.getY(), end2.getY());
                if (resultSegRef != null) {
                    coalescedObject = new LineSegment2D(seg[resultSegRef[0]].getStart(), seg[resultSegRef[1]].getEnd());
                }
            } else if (object2 instanceof Line2D) {
                if (((Line2D)object2).includes(object1)) {
                    coalescedObject = object2;
                }
            } else if (object2 instanceof R2 && ((LineSegment2D)object1).contains(object2)) {
                coalescedObject = object1;
            }
        } else if (object1 instanceof Line2D) {
            if (object2 instanceof LineSegment2D) {
                if (((Line2D)object1).includes(object2)) {
                    coalescedObject = object1;
                }
            } else if (object2 instanceof Line2D) {
                if (object1.equals(object2)) {
                    coalescedObject = object1;
                }
            } else if (object2 instanceof R2 && ((Line2D)object1).contains(object2)) {
                coalescedObject = object1;
            }
        } else if (object1 instanceof R2) {
            if (object2 instanceof LineSegment2D) {
                if (((LineSegment2D)object2).contains(object1)) {
                    coalescedObject = object2;
                }
            } else if (object2 instanceof Line2D) {
                if (((Line2D)object2).contains(object1)) {
                    coalescedObject = object2;
                }
            } else if (object2 instanceof R2 && object1.equals(object2)) {
                coalescedObject = object2;
            }
        }
        return coalescedObject;
    }

    private static int[] refCoalescedR1Seg(double startSeg1, double endSeg1, double startSeg2, double endSeg2) {
        int[] coalescedSegRef = null;
        if (startSeg2 < startSeg1) {
            if (endSeg2 >= startSeg1) {
                if (endSeg2 <= endSeg1) {
                    int[] nArray = new int[2];
                    nArray[0] = 1;
                    coalescedSegRef = nArray;
                } else {
                    coalescedSegRef = new int[]{1, 1};
                }
            }
        } else if (startSeg2 <= endSeg1) {
            if (endSeg2 <= endSeg1) {
                coalescedSegRef = new int[2];
            } else {
                int[] nArray = new int[2];
                nArray[1] = 1;
                coalescedSegRef = nArray;
            }
        }
        return coalescedSegRef;
    }
}

