/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype.geom.test;

import edu.uml.lgdc.datatype.geom.Line2D;
import edu.uml.lgdc.datatype.geom.LineSegment2D;
import edu.uml.lgdc.datatype.geom.R2;
import edu.uml.lgdc.datatype.geom.Rn;
import edu.uml.lgdc.datatype.geom.ZigzagLine2D;
import edu.uml.lgdc.math.ExtMath;
import java.util.Arrays;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestLine2D {
    private static final double SMALL = 1.0E-7;
    private static double[][][][] testContainsData = new double[][][][]{new double[][][]{new double[][]{{2.0, 0.0}, {2.0, 5.0}}, new double[][]{{2.0, -1.0}, {2.0, 0.5}, {2.0, 3456.0}}}, new double[][][]{new double[][]{{0.0, -5.0}, {2.0, -5.0}}, new double[][]{{-3.0, -5.0}, {-6534.0, -5.0}, {30476.0, -5.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {1.0, 1.0}}, new double[][]{{-1.0, -1.0}, {0.5, 0.5}, {2.0, 2.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {-1.0, 1.0}}, new double[][]{{-2.0, 2.0}, {0.5, -0.5}, {1.0, -1.0}, {2.0, -2.0}}}, new double[][][]{new double[][]{{0.0, 1.0}, {1.0, 0.0}}, new double[][]{{-1.0, 2.0}, {0.5, 0.5}, {2.0, -1.0}}}};
    private static double[][][][] testNotContainsData = new double[][][][]{new double[][][]{new double[][]{{2.0, 0.0}, {2.0, 5.0}}, new double[][]{{2.5, -1.0}, {2.5, 0.6}, {2.1, 3456.0}}}, new double[][][]{new double[][]{{0.0, -5.0}, {2.0, -5.0}}, new double[][]{{-3.005, -6.0}, {-6534.0, -7.0}, {30476.0, -8.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {1.0, 1.0}}, new double[][]{{-1.0, -1.9}, {0.7, 0.5}, {2.0, 3.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {-1.0, 1.0}}, new double[][]{{-2.0, 4.0}, {0.5, -0.9}, {1.5, -1.0}, {5.0, -2.0}}}, new double[][][]{new double[][]{{0.0, 1.0}, {1.0, 0.0}}, new double[][]{{-2.0, 2.0}, {0.1, 0.5}, {2.6, -1.0}}}};
    private static double[][][][] testEqualsData = new double[][][][]{new double[][][]{new double[][]{{2.0, 1.0}, {2.0, 9.0}}, new double[][]{{2.0, -0.89765}, {2.0, 123.8765}}}, new double[][][]{new double[][]{{0.0, 0.0}, {1.0, 1.0}}, new double[][]{{0.5, 0.5}, {2.0, 2.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {-1.0, 1.0}}, new double[][]{{0.5, -0.5}, {2.0, -2.0}}}, new double[][][]{new double[][]{{0.0, 1.0}, {1.0, 0.0}}, new double[][]{{-1.0, 2.0}, {0.5, 0.5}}}};
    private static double[][][][] testNotEqualsData = new double[][][][]{new double[][][]{new double[][]{{2.0, 1.0}, {2.0, 9.0}}, new double[][]{{2.0, -0.89765}, {2.3, 124.8765}}}, new double[][][]{new double[][]{{0.0, 0.0}, {1.0, 1.0}}, new double[][]{{0.5, 0.5}, {2.0, 2.1}}}, new double[][][]{new double[][]{{0.0, 0.0}, {-1.0, 1.0}}, new double[][]{{0.5, -0.4}, {-2.0, -2.0}}}, new double[][][]{new double[][]{{0.0, 1.0}, {1.0, 0.0}}, new double[][]{{-2.0, 2.0}, {0.5, 0.5}}}};
    private static double[][][] testDistanceData = new double[][][]{new double[][]{{0.0, 0.0}, {0.0, 1.0}, {1.0, 356781.0}, {1.0}}, new double[][]{{0.0, 0.0}, {1.0, 1.0}, {0.5, 0.5}, {0.0}}, new double[][]{{0.0, 0.0}, {1.0, 1.0}, {1.0, 0.0}, {Math.sqrt(2.0) / 2.0}}, new double[][]{{0.0, 0.0}, {-1.0, 1.0}, {0.0, 1.0}, {Math.sqrt(2.0) / 2.0}}, new double[][]{{0.0, 1.0}, {-2.0, 0.0}, {0.0, 11.0}, {10.0 * Math.sin(Math.atan(2.0))}}};
    private static double[][][][] testIncludesSegmentData = new double[][][][]{new double[][][]{new double[][]{{2.0, 1.0}, {2.0, 9.0}}, new double[][]{{2.0, -0.89765}, {2.0, 123.8765}}}, new double[][][]{new double[][]{{0.0, 0.0}, {1.0, 1.0}}, new double[][]{{0.5, 0.5}, {2.0, 2.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {-1.0, 1.0}}, new double[][]{{0.5, -0.5}, {2.0, -2.0}}}, new double[][][]{new double[][]{{0.0, 1.0}, {1.0, 0.0}}, new double[][]{{-1.0, 2.0}, {0.5, 0.5}}}};
    private static double[][][][] testNotIncludesSegmentData = new double[][][][]{new double[][][]{new double[][]{{2.0, 1.0}, {2.0, 9.0}}, new double[][]{{3.0, -0.89765}, {2.0, 123.8765}}}, new double[][][]{new double[][]{{0.0, 0.0}, {1.0, 1.0}}, new double[][]{{0.501, 0.5}, {2.0, 2.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {-1.0, 1.0}}, new double[][]{{0.5, -0.5}, {2.0001, -2.0}}}, new double[][][]{new double[][]{{0.0, 1.0}, {1.0, 0.0}}, new double[][]{{-1.0, -1.0}, {0.5, 0.5}}}};
    private static double[][][][] testIncludesZigzagData = new double[][][][]{new double[][][]{new double[][]{{2.0, 0.0}, {2.0, 5.0}}, new double[][]{{2.0, -1.0}, {2.0, 0.5}, {2.0, 3456.0}}}, new double[][][]{new double[][]{{0.0, -5.0}, {2.0, -5.0}}, new double[][]{{-3.0, -5.0}, {-6534.0, -5.0}, {30476.0, -5.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {1.0, 1.0}}, new double[][]{{-1.0, -1.0}, {0.5, 0.5}, {2.0, 2.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {-1.0, 1.0}}, new double[][]{{-2.0, 2.0}, {0.5, -0.5}, {1.0, -1.0}, {2.0, -2.0}}}, new double[][][]{new double[][]{{0.0, 1.0}, {1.0, 0.0}}, new double[][]{{-1.0, 2.0}, {0.5, 0.5}, {2.0, -1.0}}}};
    private static double[][][][] testNotIncludesZigzagData = new double[][][][]{new double[][][]{new double[][]{{2.0, 0.0}, {2.0, 5.0}}, new double[][]{{2.0, -1.0}, {2.1, 0.5}, {2.0, 3456.0}}}, new double[][][]{new double[][]{{0.0, -5.0}, {2.0, -5.0}}, new double[][]{{-3.0, -6.0}, {-6534.0, -5.0}, {30476.0, -5.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {1.0, 1.0}}, new double[][]{{-1.0, -1.0}, {0.5, 0.5}, {2.5, 2.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {-1.0, 1.0}}, new double[][]{{-2.0, -2.0}, {0.5, -0.5}, {1.0, -1.0}, {2.0, -2.0}}}, new double[][][]{new double[][]{{0.0, 1.0}, {1.0, 0.0}}, new double[][]{{-1.0, 2.0}, {0.6, 0.5}, {2.0, -1.0}}}};
    private static double[][][][] testPointAndDirectionConstructorData = new double[][][][]{new double[][][]{new double[][]{{2.0, 0.0}, {0.0, 2.0}}, new double[][]{{2.0, -1.0}, {2.0, 0.5}, {2.0, 3456.0}}}, new double[][][]{new double[][]{{0.0, -5.0}, {3.0, 0.0}}, new double[][]{{-3.0, -5.0}, {-6534.0, -5.0}, {30476.0, -5.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {1.0, 1.0}}, new double[][]{{-1.0, -1.0}, {0.5, 0.5}, {2.0, 2.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {-1.0, 1.0}}, new double[][]{{-2.0, 2.0}, {0.5, -0.5}, {1.0, -1.0}, {2.0, -2.0}}}, new double[][][]{new double[][]{{0.0, 1.0}, {-2.0, 2.0}}, new double[][]{{-1.0, 2.0}, {0.5, 0.5}, {2.0, -1.0}}}};
    private static double[][][][] testGetParallelLineData = new double[][][][]{new double[][][]{new double[][]{{2.0, 0.0}, {2.0, 5.0}, {-10.0, 9.7}}, new double[][]{{-10.0, -1.0}, {-10.0, 0.5}, {-10.0, 3456.0}}}, new double[][][]{new double[][]{{0.0, -5.0}, {3.0, -5.0}, {-23.0, 1.275}}, new double[][]{{-3.0, 1.275}, {-6534.0, 1.275}, {30476.0, 1.275}}}, new double[][][]{new double[][]{{0.0, 0.0}, {1.0, 1.0}, {3.0, 1.0}}, new double[][]{{2.0, 0.0}, {1.0, -1.0}, {0.0, -2.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {-1.0, 1.0}, {0.0, 1.0}}, new double[][]{{-1.0, 2.0}, {1.0, 0.0}, {2.0, -1.0}, {3.0, -2.0}}}, new double[][][]{new double[][]{{0.0, 1.0}, {1.0, 0.0}, {0.0, 0.0}}, new double[][]{{-1.0, 1.0}, {-1.0, 1.0}, {-2.0, 2.0}}}};
    private static double[][][][] testGetPerpendicularLineData = new double[][][][]{new double[][][]{new double[][]{{2.0, 0.0}, {2.0, 5.0}, {-10.0, 9.7}}, new double[][]{{-1.0, 9.7}, {134.0, 9.7}, {-0.567, 9.7}}}, new double[][][]{new double[][]{{0.0, -5.0}, {3.0, -5.0}, {-23.0, 1.275}}, new double[][]{{-23.0, 101.0}, {-23.0, -33.0}, {-23.0, 0.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {1.0, 1.0}, {3.0, 1.0}}, new double[][]{{4.0, 0.0}, {2.0, 2.0}, {1.0, 3.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {-1.0, 1.0}, {0.0, 1.0}}, new double[][]{{-1.0, 0.0}, {1.0, 2.0}, {-2.0, -1.0}, {-3.0, -2.0}}}, new double[][][]{new double[][]{{0.0, 1.0}, {1.0, 0.0}, {0.0, 0.0}}, new double[][]{{1.0, 1.0}, {2.0, 2.0}, {3.0, 3.0}}}};
    private static double[][][][] testProjectionData = new double[][][][]{new double[][][]{new double[][]{{2.0, 1.0}, {2.0, 9.0}, {2.0, 100.0}}, new double[][]{{2.0, 100.0}}}, new double[][][]{new double[][]{{2.0, 1.0}, {2.0, 9.0}, {3.0, 50.0}}, new double[][]{{2.0, 50.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {1.0, 1.0}, {1.0, 0.0}}, new double[][]{{0.5, 0.5}}}, new double[][][]{new double[][]{{0.0, 0.0}, {1.0, 1.0}, {0.0, -1.0}}, new double[][]{{-0.5, -0.5}}}, new double[][][]{new double[][]{{0.0, 0.0}, {-1.0, 1.0}, {0.0, 2.0}}, new double[][]{{-1.0, 1.0}}}, new double[][][]{new double[][]{{0.0, 1.0}, {1.0, 0.0}, {0.0, 0.0}}, new double[][]{{0.5, 0.5}}}};
    private static double[][][][] testIntersectionData = new double[][][][]{new double[][][]{new double[][]{{2.0, 1.0}, {2.0, 9.0}, {10.0, 5.0}, {11.0, 5.0}}, new double[][]{{2.0, 5.0}}}, new double[][][]{new double[][]{{2.0, 1.0}, {2.0, 9.0}, {5.0, 50.0}, {5.0, 60.0}}, new double[1][]}, new double[][][]{new double[][]{{2.0, 1.0}, {2.0, 9.0}, {2.0, 50.0}, {2.0, 60.0}}, new double[][]{{2.0, 0.0}, {2.0, -1.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {0.5, 0.5}, {2.0, 0.0}, {0.0, 2.0}}, new double[][]{{1.0, 1.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {1.0, 1.0}, {10.0, 1.0}, {10.0, 2.0}}, new double[][]{{10.0, 10.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {-1.0, 1.0}, {0.0, 3.0}, {-6.0, 0.0}}, new double[][]{{-2.0, 2.0}}}, new double[][][]{new double[][]{{0.0, 1.0}, {1.0, 0.0}, {0.0, 3.0}, {-6.0, 0.0}}, new double[][]{{-1.3333333333, 2.3333333333}}}};
    private static double[][][][] testMirrorData = new double[][][][]{new double[][][]{new double[][]{{2.0, 1.0}, {2.0, 9.0}, {-1.0, 10.0}}, new double[][]{{5.0, 10.0}}}, new double[][][]{new double[][]{{12.0, 5.0}, {1.0, 5.0}, {3.0, -1.0}}, new double[][]{{3.0, 11.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {0.5, 0.5}, {2.0, 0.0}}, new double[][]{{0.0, 2.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {-1.0, 1.0}, {2.0, 3.0}}, new double[][]{{-3.0, -2.0}}}, new double[][][]{new double[][]{{1.0, 0.0}, {-1.0, 2.0}, {2.0, 3.0}}, new double[][]{{-2.0, -1.0}}}};
    private static double[][][] testAreRayConnectedTrueData = new double[][][]{new double[][]{{2.0, 1.0}, {2.0, 9.0}, {-1.0, 10.0}, {1.99, 300.0}}, new double[][]{{12.0, 5.0}, {1.0, 5.0}, {3.0, -1.0}, {-20.0, 4.5}}, new double[][]{{0.0, 0.0}, {0.5, 0.5}, {2.0, 0.0}, {3.0, 2.0}}, new double[][]{{0.0, 0.0}, {-1.0, 1.0}, {2.0, 0.0}, {-20.0, 21.0}}, new double[][]{{1.0, 0.0}, {-1.0, 2.0}, {-1.0, 1.0}, {-4.0, 4.999}}};
    private static double[][][] testAreRayConnectedFalseData = new double[][][]{new double[][]{{2.0, 1.0}, {2.0, 9.0}, {-1.0, 10.0}, {2.01, 300.0}}, new double[][]{{12.0, 5.0}, {1.0, 5.0}, {3.0, -1.0}, {-20.0, 5.5}}, new double[][]{{0.0, 0.0}, {0.5, 0.5}, {2.0, 0.0}, {3.0, 3.001}}, new double[][]{{0.0, 0.0}, {-1.0, 1.0}, {2.0, 0.0}, {-20.0, 19.999}}, new double[][]{{1.0, 0.0}, {-1.0, 2.0}, {-1.0, 1.0}, {-4.0, 5.001}}};
    private static double[][][][] testGetReflectionData = new double[][][][]{new double[][][]{new double[][]{{2.0, 1.0}, {2.0, 9.0}, {-1.0, 7.0}, {1.0, 3.0}}, new double[][]{{2.0, 3.0}}}, new double[][][]{new double[][]{{12.0, 5.0}, {1.0, 5.0}, {3.0, -1.0}, {-2.0, 1.0}}, new double[][]{{1.0, 5.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {0.5, 0.5}, {1.0, -2.0}, {4.0, 1.0}}, new double[][]{{1.0, 1.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {-1.0, 1.0}, {2.0, 0.0}, {0.0, 4.0}}, new double[][]{{0.0, 0.0}}}, new double[][][]{new double[][]{{1.0, 0.0}, {-1.0, 2.0}, {-1.0, 1.0}, {-4.0, 2.0}}, new double[][]{{-1.0, 2.0}}}};

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testContains() {
        this.testContains(testContainsData, true);
    }

    @Test
    public void testNotContains() {
        this.testContains(testNotContainsData, false);
    }

    private void testContains(double[][][][] data, boolean contains) {
        boolean allPassed = true;
        double[][][][] dArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            double[][][] testData = dArray[n2];
            double[][] input = testData[0];
            double[][] expectedResult = testData[1];
            R2 p1 = new R2(input[0][0], input[0][1]);
            R2 p2 = new R2(input[1][0], input[1][1]);
            Line2D line = new Line2D(p1, p2);
            boolean passed = true;
            double[][] dArray2 = expectedResult;
            int n3 = expectedResult.length;
            int n4 = 0;
            while (n4 < n3) {
                double[] coords = dArray2[n4];
                R2 point = new R2(coords[0], coords[1]);
                if (line.contains((Object)point) != contains) {
                    System.out.println("FAILED: Line " + line + " must " + (!contains ? "NOT " : "") + "contains point " + point);
                    passed = false;
                }
                ++n4;
            }
            if (!passed) {
                allPassed = false;
            }
            ++n2;
        }
        Assert.assertTrue((boolean)allPassed);
    }

    @Test
    public void testEquals() {
        this.testEquals(testEqualsData, true);
    }

    @Test
    public void testNotEquals() {
        this.testEquals(testNotEqualsData, false);
    }

    private void testEquals(double[][][][] data, boolean equals) {
        boolean passed = true;
        double[][][][] dArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            double[][][] testData = dArray[n2];
            double[][] input = testData[0];
            R2 p1 = new R2(input[0][0], input[0][1]);
            R2 p2 = new R2(input[1][0], input[1][1]);
            Line2D line1 = new Line2D(p1, p2);
            double[][] expectedResult = testData[1];
            R2 p3 = new R2(expectedResult[0][0], expectedResult[0][1]);
            R2 p4 = new R2(expectedResult[1][0], expectedResult[1][1]);
            Line2D line2 = new Line2D(p3, p4);
            if (line1.equals(line2) != equals) {
                System.out.println("FAILED: Line " + line1 + " must " + (!equals ? "NOT " : "") + "be equal to line " + line2);
                passed = false;
            }
            ++n2;
        }
        Assert.assertTrue((boolean)passed);
    }

    @Test
    public void testDistance() {
        boolean passed = true;
        double[][][] dArray = testDistanceData;
        int n = testDistanceData.length;
        int n2 = 0;
        while (n2 < n) {
            double[][] testData = dArray[n2];
            R2 p1 = new R2(testData[0][0], testData[0][1]);
            R2 p2 = new R2(testData[1][0], testData[1][1]);
            R2 point = new R2(testData[2][0], testData[2][1]);
            double expectedDistance = testData[3][0];
            Line2D line = new Line2D(p1, p2);
            if (!ExtMath.areClose(line.distance(point), expectedDistance, 1.0E-7)) {
                System.out.println("FAILED: distance between line " + line + " and point " + point + " must be equal to " + expectedDistance);
                passed = false;
            }
            ++n2;
        }
        Assert.assertTrue((boolean)passed);
    }

    @Test
    public void testIncludesSegment() {
        this.testIncludesSegment(testIncludesSegmentData, true);
    }

    @Test
    public void testNotIncludesSegment() {
        this.testIncludesSegment(testNotIncludesSegmentData, false);
    }

    private void testIncludesSegment(double[][][][] data, boolean includes) {
        boolean passed = true;
        double[][][][] dArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            double[][][] testData = dArray[n2];
            double[][] input = testData[0];
            R2 p1 = new R2(input[0][0], input[0][1]);
            R2 p2 = new R2(input[1][0], input[1][1]);
            Line2D line = new Line2D(p1, p2);
            double[][] expectedResult = testData[1];
            R2 p3 = new R2(expectedResult[0][0], expectedResult[0][1]);
            R2 p4 = new R2(expectedResult[1][0], expectedResult[1][1]);
            LineSegment2D segment = new LineSegment2D(p3, p4);
            if (line.includes((Object)segment) != includes) {
                System.out.println("FAILED: Line " + line + " must " + (!includes ? "NOT " : "") + "include segment " + segment);
                passed = false;
            }
            ++n2;
        }
        Assert.assertTrue((boolean)passed);
    }

    @Test
    public void testIncludesZigzag() {
        this.testIncludesZigzag(testIncludesZigzagData, true);
    }

    @Test
    public void testNotIncludesZigzag() {
        this.testIncludesZigzag(testNotIncludesZigzagData, false);
    }

    private void testIncludesZigzag(double[][][][] data, boolean includes) {
        boolean passed = true;
        double[][][][] dArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            double[][][] testData = dArray[n2];
            double[][] input = testData[0];
            double[][] expectedResult = testData[1];
            R2 p1 = new R2(input[0][0], input[0][1]);
            R2 p2 = new R2(input[1][0], input[1][1]);
            Line2D line = new Line2D(p1, p2);
            R2[] vertices = new R2[expectedResult.length];
            int i = 0;
            while (i < expectedResult.length) {
                vertices[i] = new R2(expectedResult[i][0], expectedResult[i][1]);
                ++i;
            }
            ZigzagLine2D zigzag = new ZigzagLine2D(vertices);
            if (line.includes((Object)zigzag) != includes) {
                System.out.println("FAILED: Line " + line + " must " + (!includes ? "NOT " : "") + "include zizag line " + zigzag);
                passed = false;
            }
            ++n2;
        }
        Assert.assertTrue((boolean)passed);
    }

    @Test
    public void testPointAndDirectionConstructor() {
        boolean allPassed = true;
        double[][][][] dArray = testPointAndDirectionConstructorData;
        int n = testPointAndDirectionConstructorData.length;
        int n2 = 0;
        while (n2 < n) {
            double[][][] testData = dArray[n2];
            double[][] input = testData[0];
            double[][] expectedResult = testData[1];
            R2 point = new R2(input[0][0], input[0][1]);
            R2 vector = new R2(input[1][0], input[1][1]);
            Line2D line = Line2D.getLineUsingPointAndVector(point, vector);
            boolean passed = true;
            double[][] dArray2 = expectedResult;
            int n3 = expectedResult.length;
            int n4 = 0;
            while (n4 < n3) {
                double[] coords = dArray2[n4];
                R2 p = new R2(coords[0], coords[1]);
                if (!line.contains((Object)p)) {
                    System.out.println("FAILED: Line " + line + " must contains point " + p);
                    passed = false;
                }
                ++n4;
            }
            if (!passed) {
                allPassed = false;
            }
            ++n2;
        }
        Assert.assertTrue((boolean)allPassed);
    }

    @Test
    public void testGetParallelLine() {
        boolean allPassed = true;
        double[][][][] dArray = testGetParallelLineData;
        int n = testGetParallelLineData.length;
        int n2 = 0;
        while (n2 < n) {
            double[][][] testData = dArray[n2];
            double[][] input = testData[0];
            double[][] expectedResult = testData[1];
            R2 p1 = new R2(input[0][0], input[0][1]);
            R2 p2 = new R2(input[1][0], input[1][1]);
            Line2D baseline = new Line2D(p1, p2);
            R2 p3 = new R2(input[2][0], input[2][1]);
            Line2D line = baseline.getParallel(p3);
            boolean passed = true;
            double[][] dArray2 = expectedResult;
            int n3 = expectedResult.length;
            int n4 = 0;
            while (n4 < n3) {
                double[] coords = dArray2[n4];
                R2 p = new R2(coords[0], coords[1]);
                if (!line.contains((Object)p)) {
                    System.out.println("FAILED: Line " + line + " must contains point " + p);
                    passed = false;
                }
                ++n4;
            }
            if (!passed) {
                allPassed = false;
            }
            ++n2;
        }
        Assert.assertTrue((boolean)allPassed);
    }

    @Test
    public void testGetPerpendicularlLine() {
        boolean allPassed = true;
        double[][][][] dArray = testGetPerpendicularLineData;
        int n = testGetPerpendicularLineData.length;
        int n2 = 0;
        while (n2 < n) {
            double[][][] testData = dArray[n2];
            double[][] input = testData[0];
            double[][] expectedResult = testData[1];
            R2 p1 = new R2(input[0][0], input[0][1]);
            R2 p2 = new R2(input[1][0], input[1][1]);
            Line2D baseline = new Line2D(p1, p2);
            R2 p3 = new R2(input[2][0], input[2][1]);
            Line2D line = baseline.getPerpendicular(p3);
            boolean passed = true;
            double[][] dArray2 = expectedResult;
            int n3 = expectedResult.length;
            int n4 = 0;
            while (n4 < n3) {
                double[] coords = dArray2[n4];
                R2 p = new R2(coords[0], coords[1]);
                if (!line.contains((Object)p)) {
                    System.out.println("FAILED: Line " + line + " must contains point " + p);
                    passed = false;
                }
                ++n4;
            }
            if (!passed) {
                allPassed = false;
            }
            ++n2;
        }
        Assert.assertTrue((boolean)allPassed);
    }

    @Test
    public void testProjection() {
        boolean passed = true;
        double[][][][] dArray = testProjectionData;
        int n = testProjectionData.length;
        int n2 = 0;
        while (n2 < n) {
            R2 p;
            double[][][] testData = dArray[n2];
            double[][] input = testData[0];
            double[][] expectedResult = testData[1];
            R2 p1 = new R2(input[0][0], input[0][1]);
            R2 p2 = new R2(input[1][0], input[1][1]);
            Line2D line = new Line2D(p1, p2);
            R2 p3 = new R2(input[2][0], input[2][1]);
            R2 point = line.projection(p3);
            if (!Rn.areClose(point, p = new R2(expectedResult[0][0], expectedResult[0][1]), 1.0E-7)) {
                System.out.println("FAILED: calculated projection of point " + p3 + " on line " + line + " is " + point + " but shoud be " + p);
                passed = false;
            }
            ++n2;
        }
        Assert.assertTrue((boolean)passed);
    }

    @Test
    public void testIntersection() {
        boolean passed = true;
        double[][][][] dArray = testIntersectionData;
        int n = testIntersectionData.length;
        int n2 = 0;
        while (n2 < n) {
            Line2D resLine;
            R2 p;
            double[][][] testData = dArray[n2];
            double[][] input = testData[0];
            double[][] expectedResult = testData[1];
            R2 p1 = new R2(input[0][0], input[0][1]);
            R2 p2 = new R2(input[1][0], input[1][1]);
            Line2D line1 = new Line2D(p1, p2);
            R2 p3 = new R2(input[2][0], input[2][1]);
            R2 p4 = new R2(input[3][0], input[3][1]);
            Line2D line2 = new Line2D(p3, p4);
            Object obj = line1.intersection(line2);
            if (obj instanceof R2) {
                R2 point = (R2)obj;
                if (expectedResult.length == 1) {
                    if (expectedResult[0] != null) {
                        p = new R2(expectedResult[0][0], expectedResult[0][1]);
                        if (!Rn.areClose(point, p, 1.0E-7)) {
                            System.out.println("FAILED: calculated intersection of lines " + line1 + " and " + line2 + " is point " + point + ", but shoud be point " + p);
                            passed = false;
                        }
                    } else {
                        System.out.println("FAILED: calculated intersection of lines " + line1 + " and " + line2 + " is " + point + ", but shoud be null");
                        passed = false;
                    }
                } else {
                    resLine = new Line2D(new R2(expectedResult[0][0], expectedResult[0][1]), new R2(expectedResult[1][0], expectedResult[1][1]));
                    System.out.println("FAILED: calculated intersection of lines " + line1 + " and " + line2 + " is " + point + ", but shoud be line " + resLine);
                    passed = false;
                }
            } else if (obj instanceof Line2D) {
                Line2D calcLine = (Line2D)obj;
                if (expectedResult.length == 2) {
                    resLine = new Line2D(new R2(expectedResult[0][0], expectedResult[0][1]), new R2(expectedResult[1][0], expectedResult[1][1]));
                    if (!calcLine.equals(resLine)) {
                        System.out.println("FAILED: calculated intersection of lines " + line1 + " and " + line2 + " is line " + calcLine + ", but shoud be line " + resLine);
                        passed = false;
                    }
                } else if (expectedResult[0] != null) {
                    p = new R2(expectedResult[0][0], expectedResult[0][1]);
                    System.out.println("FAILED: calculated intersection of lines " + line1 + " and " + line2 + " is line " + calcLine + ", but shoud be point " + p);
                    passed = false;
                } else {
                    System.out.println("FAILED: calculated intersection of lines " + line1 + " and " + line2 + " is line " + calcLine + ", but shoud be null");
                    passed = false;
                }
            } else if (expectedResult.length == 2) {
                Line2D resLine2 = new Line2D(new R2(expectedResult[0][0], expectedResult[0][1]), new R2(expectedResult[1][0], expectedResult[1][1]));
                System.out.println("FAILED: calculated intersection of lines " + line1 + " and " + line2 + " is null, but shoud be line " + resLine2);
                passed = false;
            } else if (expectedResult[0] != null) {
                R2 p5 = new R2(expectedResult[0][0], expectedResult[0][1]);
                System.out.println("FAILED: calculated intersection of lines " + line1 + " and " + line2 + " is null, but shoud be point " + p5);
                passed = false;
            }
            ++n2;
        }
        Assert.assertTrue((boolean)passed);
    }

    @Test
    public void testMirror() {
        boolean passed = true;
        double[][][][] dArray = testMirrorData;
        int n = testMirrorData.length;
        int n2 = 0;
        while (n2 < n) {
            R2 mirrorPoint;
            double[][][] testData = dArray[n2];
            double[][] input = testData[0];
            double[][] expectedResult = testData[1];
            R2 p1 = new R2(input[0][0], input[0][1]);
            R2 p2 = new R2(input[1][0], input[1][1]);
            Line2D line = new Line2D(p1, p2);
            R2 p = new R2(input[2][0], input[2][1]);
            R2 calcMirrorPoint = line.mirror(p);
            if (!Rn.areClose(calcMirrorPoint, mirrorPoint = new R2(expectedResult[0][0], expectedResult[0][1]), 1.0E-7)) {
                System.out.println("FAILED: for line " + line + " calculated mirror of point " + p + " is " + calcMirrorPoint + " but should be " + mirrorPoint);
                passed = false;
            }
            ++n2;
        }
        Assert.assertTrue((boolean)passed);
    }

    @Test
    public void testRayConnectedTrue() {
        this.testRayConnected(testAreRayConnectedTrueData, true);
    }

    @Test
    public void testRayConnectedFalse() {
        this.testRayConnected(testAreRayConnectedFalseData, false);
    }

    private void testRayConnected(double[][][] testAreRayConnectedData, boolean yes) {
        boolean passed = true;
        double[][][] dArray = testAreRayConnectedData;
        int n = testAreRayConnectedData.length;
        int n2 = 0;
        while (n2 < n) {
            double[][] testData = dArray[n2];
            R2 pl1 = new R2(testData[0][0], testData[0][1]);
            R2 pl2 = new R2(testData[1][0], testData[1][1]);
            Line2D line = new Line2D(pl1, pl2);
            R2 p1 = new R2(testData[2][0], testData[2][1]);
            R2 p2 = new R2(testData[3][0], testData[3][1]);
            if (line.areRayConnected(p1, p2) != yes) {
                System.out.println("FAILED: for line " + line + " points " + p1 + " and " + p2 + " are calculated as " + (yes ? "NOT " : "") + "ray-connected but should be " + (yes ? "" : "NOT ") + "ray-connected");
                passed = false;
            }
            ++n2;
        }
        Assert.assertTrue((boolean)passed);
    }

    public void testGetReflection() {
        boolean passed = true;
        double[][][][] dArray = testGetReflectionData;
        int n = testGetReflectionData.length;
        int n2 = 0;
        while (n2 < n) {
            double[][][] testData = dArray[n2];
            double[][] input = testData[0];
            double[][] expectedResult = testData[1];
            R2 pl1 = new R2(input[0][0], input[0][1]);
            R2 pl2 = new R2(input[1][0], input[1][1]);
            Line2D line = new Line2D(pl1, pl2);
            R2 p1 = new R2(input[2][0], input[2][1]);
            R2 p2 = new R2(input[3][0], input[3][1]);
            R2 calcReflectionPoint = line.getReflection(p1, p2);
            R2 reflectionPoint = new R2(expectedResult[0][0], expectedResult[0][1]);
            if (calcReflectionPoint != null && Rn.areClose(calcReflectionPoint, reflectionPoint, 1.0E-7)) {
                System.out.println("FAILED: for line " + line + " and points " + p1 + " and " + p2 + " calculated reflection point is " + calcReflectionPoint + " but should be " + reflectionPoint);
                passed = false;
            }
            ++n2;
        }
        Assert.assertTrue((boolean)passed);
    }

    @Test
    public void testLeastSquareFit_H_Line() {
        R2[] points = new R2[]{new R2(0.0, 0.0), new R2(1.0, 0.0), new R2(5.0, 0.0)};
        Line2D fitLine = new Line2D(points[0], points[1]);
        this.testLeastSquareFit(points, fitLine);
    }

    @Test
    public void testLeastSquareFit_V_Line() {
        R2[] points = new R2[]{new R2(0.0, 0.0), new R2(0.0, 1.0), new R2(0.0, 4.0)};
        Line2D fitLine = new Line2D(points[0], points[1]);
        this.testLeastSquareFit(points, fitLine);
    }

    @Test
    public void testLeastSquareFit_45deg_line() {
        R2[] points = new R2[]{new R2(0.0, 0.0), new R2(1.0, 1.0), new R2(4.0, 4.0)};
        Line2D fitLine = new Line2D(points[0], points[1]);
        this.testLeastSquareFit(points, fitLine);
    }

    @Test
    public void testLeastSquareFit_135deg_line() {
        R2[] points = new R2[]{new R2(0.0, 0.0), new R2(-1.0, 1.0), new R2(4.0, -4.0)};
        Line2D fitLine = new Line2D(points[0], points[1]);
        this.testLeastSquareFit(points, fitLine);
    }

    @Test
    public void testLeastSquareFit_H_Corridor() {
        R2[] points = new R2[]{new R2(0.0, 0.0), new R2(0.0, 2.0), new R2(1.0, 0.0), new R2(1.0, 2.0), new R2(2.0, 0.0), new R2(2.0, 2.0), new R2(3.0, 0.0), new R2(3.0, 2.0)};
        Line2D fitLine = new Line2D(new R2(0.0, 1.0), new R2(1.0, 1.0));
        this.testLeastSquareFit(points, fitLine);
    }

    @Test
    public void testLeastSquareFit_V_Corridor() {
        R2[] points = new R2[]{new R2(0.0, 0.0), new R2(2.0, 0.0), new R2(0.0, 1.0), new R2(2.0, 1.0), new R2(0.0, 2.0), new R2(2.0, 2.0), new R2(0.0, 3.0), new R2(2.0, 3.0)};
        Line2D fitLine = new Line2D(new R2(1.0, 0.0), new R2(1.0, 1.0));
        this.testLeastSquareFit(points, fitLine);
    }

    @Test
    public void testLeastSquareFit_45deg_Corridor() {
        R2[] points = new R2[]{new R2(1.0, 0.0), new R2(2.0, 1.0), new R2(3.0, 2.0), new R2(4.0, 3.0), new R2(0.0, 1.0), new R2(1.0, 2.0), new R2(2.0, 3.0), new R2(3.0, 4.0)};
        Line2D fitLine = new Line2D(new R2(0.0, 0.0), new R2(1.0, 1.0));
        this.testLeastSquareFit(points, fitLine);
    }

    @Test
    public void testLeastSquareFit_135deg_Corridor() {
        R2[] points = new R2[]{new R2(-1.0, 0.0), new R2(-2.0, 1.0), new R2(-3.0, 2.0), new R2(-4.0, 3.0), new R2(0.0, 1.0), new R2(-1.0, 2.0), new R2(-2.0, 3.0), new R2(-3.0, 4.0)};
        Line2D fitLine = new Line2D(new R2(0.0, 0.0), new R2(-1.0, 1.0));
        this.testLeastSquareFit(points, fitLine);
    }

    @Test
    public void testLeastSquareFit_H_Oval() {
        R2[] points = new R2[]{new R2(0.0, 0.0), new R2(1.0, 1.0), new R2(1.0, -1.0), new R2(2.0, 2.0), new R2(2.0, -2.0), new R2(3.0, 2.0), new R2(3.0, -2.0), new R2(4.0, 2.0), new R2(4.0, -2.0), new R2(5.0, 1.0), new R2(5.0, -1.0), new R2(6.0, 0.0)};
        Line2D fitLine = new Line2D(new R2(0.0, 0.0), new R2(1.0, 0.0));
        this.testLeastSquareFit(points, fitLine);
    }

    @Test
    public void testLeastSquareFit_V_Oval() {
        R2[] points = new R2[]{new R2(0.0, 0.0), new R2(1.0, 1.0), new R2(-1.0, 1.0), new R2(2.0, 2.0), new R2(-2.0, 2.0), new R2(2.0, 3.0), new R2(-2.0, 3.0), new R2(2.0, 4.0), new R2(-2.0, 4.0), new R2(1.0, 5.0), new R2(-1.0, 5.0), new R2(0.0, 6.0)};
        Line2D fitLine = new Line2D(new R2(0.0, 0.0), new R2(0.0, 1.0));
        this.testLeastSquareFit(points, fitLine);
    }

    @Test
    public void testLeastSquareFit_45deg_Oval() {
        R2[] points = new R2[]{new R2(0.0, 0.0), new R2(1.0, 0.0), new R2(0.0, 1.0), new R2(2.0, 0.0), new R2(0.0, 2.0), new R2(3.0, 1.0), new R2(1.0, 3.0), new R2(4.0, 2.0), new R2(2.0, 4.0), new R2(5.0, 3.0), new R2(3.0, 5.0), new R2(5.0, 4.0), new R2(4.0, 5.0), new R2(5.0, 5.0)};
        Line2D fitLine = new Line2D(new R2(0.0, 0.0), new R2(1.0, 1.0));
        this.testLeastSquareFit(points, fitLine);
    }

    @Test
    public void testLeastSquareFit_135deg_Oval() {
        R2[] points = new R2[]{new R2(0.0, 0.0), new R2(-1.0, 0.0), new R2(0.0, 1.0), new R2(-2.0, 0.0), new R2(0.0, 2.0), new R2(-3.0, 1.0), new R2(-1.0, 3.0), new R2(-4.0, 2.0), new R2(-2.0, 4.0), new R2(-5.0, 3.0), new R2(-3.0, 5.0), new R2(-5.0, 4.0), new R2(-4.0, 5.0), new R2(-5.0, 5.0)};
        Line2D fitLine = new Line2D(new R2(0.0, 0.0), new R2(-1.0, 1.0));
        this.testLeastSquareFit(points, fitLine);
    }

    private void testLeastSquareFit(R2[] points, Line2D fitLine) {
        Line2D calcFitLine = Line2D.leastSquareFitting(points);
        if (!calcFitLine.equals(fitLine)) {
            System.out.println("FAILED: calculated least square fit line  for points " + Arrays.asList(points) + " is " + calcFitLine + " but should be " + fitLine);
            Assert.assertTrue((boolean)false);
        }
    }
}

