/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.datatype.geom.test;

import edu.uml.lgdc.datatype.geom.Line2D;
import edu.uml.lgdc.datatype.geom.LineSegment2D;
import edu.uml.lgdc.datatype.geom.R2;
import edu.uml.lgdc.datatype.geom.ZigzagLine2D;
import edu.uml.lgdc.math.ExtMath;
import java.util.HashSet;
import java.util.Set;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestLineSegment2D {
    private static final double SMALL = 1.0E-7;
    private static double[][][][] testContainsData = new double[][][][]{new double[][][]{new double[][]{{2.0, 0.0}, {2.0, 5.0}}, new double[][]{{2.0, 1.0}, {2.0, 0.5}, {2.0, 5.0}}}, new double[][][]{new double[][]{{0.0, -5.0}, {2.0, -5.0}}, new double[][]{{0.0, -5.0}, {0.9, -5.0}, {1.9, -5.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {5.0, 5.0}}, new double[][]{{1.0, 1.0}, {0.5, 0.5}, {2.0, 2.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {-5.0, 5.0}}, new double[][]{{-2.0, 2.0}, {-0.5, 0.5}, {-1.0, 1.0}, {-4.0, 4.0}}}, new double[][][]{new double[][]{{0.0, 1.0}, {1.0, 0.0}}, new double[][]{{0.5, 0.5}}}};
    private static double[][][][] testNotContainsData = new double[][][][]{new double[][][]{new double[][]{{2.0, 0.0}, {2.0, 5.0}}, new double[][]{{2.5, -1.0}, {2.0, 6.0}, {2.1, 3456.0}}}, new double[][][]{new double[][]{{0.0, -5.0}, {2.0, -5.0}}, new double[][]{{-3.005, -6.0}, {-6534.0, -7.0}, {30476.0, -8.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {1.0, 1.0}}, new double[][]{{-1.0, -1.0}, {0.7, 0.5}, {2.0, 2.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {-3.0, 3.0}}, new double[][]{{-2.0, 4.0}, {0.5, -0.9}, {1.5, -1.0}, {5.0, -2.0}}}, new double[][][]{new double[][]{{0.0, 1.0}, {1.0, 0.0}}, new double[][]{{-2.0, 2.0}, {0.1, 0.5}, {2.6, -1.0}}}};
    private static double[][][][] testIncludesSegmentData = new double[][][][]{new double[][][]{new double[][]{{2.0, 1.0}, {2.0, 9.0}}, new double[][]{{2.0, 1.0}, {2.0, 5.0}, {2.0, 3.0}, {2.0, 6.0}, {2.0, 9.0}, {2.0, 7.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {5.0, 5.0}}, new double[][]{{1.0, 1.0}, {0.0, 0.0}, {0.5, 0.5}, {3.0, 3.0}, {4.0, 4.0}, {5.0, 5.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {-5.0, 5.0}}, new double[][]{{0.0, 0.0}, {-1.0, 1.0}, {-0.5, 0.5}, {-3.0, 3.0}, {-4.0, 4.0}, {-5.0, 5.0}}}, new double[][][]{new double[][]{{-2.0, 3.0}, {3.0, -2.0}}, new double[][]{{-2.0, 3.0}, {-1.0, 2.0}, {-1.0, 2.0}, {0.0, 1.0}, {3.0, -2.0}, {2.0, -1.0}}}};
    private static double[][][][] testNotIncludesSegmentData = new double[][][][]{new double[][][]{new double[][]{{2.0, 1.0}, {2.0, 9.0}}, new double[][]{{2.0, 0.0}, {2.0, 3.0}, {2.0, -1.0}, {2.0, 10.0}, {2.0, 1.0}, {3.0, 1.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {5.0, 5.0}}, new double[][]{{-1.0, -1.0}, {2.0, 2.0}, {-2.0, -2.0}, {6.0, 6.0}, {7.0, 7.0}, {3.0, 3.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {-5.0, 5.0}}, new double[][]{{1.0, -1.0}, {-1.0, 1.0}, {-3.0, 3.0}, {-6.0, 6.0}, {2.0, -2.0}, {-7.0, 7.0}}}, new double[][][]{new double[][]{{-2.0, 3.0}, {3.0, -2.0}}, new double[][]{{4.0, -3.0}, {-1.0, 2.0}, {0.0, 1.0}, {-3.0, 4.0}}}};
    private static double[][][][] testIncludesZigzagLineData = new double[][][][]{new double[][][]{new double[][]{{2.0, 1.0}, {2.0, 9.0}}, new double[][]{{2.0, 1.0}, {2.0, 3.0}, {2.0, 4.0}, {2.0, 6.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {5.0, 5.0}}, new double[][]{{0.3, 0.3}, {0.45, 0.45}, {0.5, 0.5}, {3.0, 3.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {-5.0, 5.0}}, new double[][]{{-0.3, 0.3}, {-0.45, 0.45}, {-0.5, 0.5}, {-3.0, 3.0}}}, new double[][][]{new double[][]{{-2.0, 3.0}, {3.0, -2.0}}, new double[][]{{0.0, 1.0}, {1.0, 0.0}, {2.0, -1.0}, {3.0, -2.0}}}};
    private static double[][][][] testNotIncludesZigzagLineData = new double[][][][]{new double[][][]{new double[][]{{2.0, 1.0}, {2.0, 9.0}}, new double[][]{{2.0, 0.0}, {2.0, 3.0}, {2.0, 4.0}, {2.0, 6.0}}}, new double[][][]{new double[][]{{2.0, 1.0}, {2.0, 9.0}}, new double[][]{{2.0, 1.0}, {2.01, 3.0}, {2.0, 4.0}, {2.0, 6.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {5.0, 5.0}}, new double[][]{{-1.0, -1.0}, {2.0, 2.0}, {3.0, 3.0}, {4.0, 4.0}}}, new double[][][]{new double[][]{{0.0, 0.0}, {-5.0, 5.0}}, new double[][]{{1.0, -1.0}, {-1.0, 1.0}, {-3.0, 3.0}, {-4.0, 4.0}}}, new double[][][]{new double[][]{{-2.0, 3.0}, {3.0, -2.0}}, new double[][]{{0.1, 1.0}, {1.0, 0.0}, {2.0, -1.0}, {-3.0, 2.0}}}};
    private static double[][][] testDistanceData = new double[][][]{new double[][]{{0.0, 0.0}, {0.0, 2.0}, {0.0, 3.0}, {1.0}}, new double[][]{{0.0, 0.0}, {0.0, 2.0}, {1.0, 1.0}, {1.0}}, new double[][]{{0.0, 0.0}, {0.0, 2.0}, {1.0, 3.0}, {Math.sqrt(2.0)}}};
    private static double[][][] testIntersectionWithLineIsPoint_Data = new double[][][]{new double[][]{{2.0, 1.0}, {2.0, 9.0}, {0.0, 3.0}, {5.0, 3.0}, {2.0, 3.0}}, new double[][]{{2.0, 1.0}, {2.0, 9.0}, {1.0, 0.0}, {3.0, 4.0}, {2.0, 2.0}}};
    private static double[][][] testIntersectionWithLineIsNull_Data = new double[][][]{new double[][]{{2.0, 1.0}, {2.0, 9.0}, {1.99, 0.0}, {1.99, 3.0}}, new double[][]{{2.0, 1.0}, {2.0, 9.0}, {0.0, 0.0}, {0.0, 1.0}}, new double[][]{{2.0, 1.0}, {2.0, 9.0}, {0.0, 0.0}, {3.0, 1.0}}};
    private static double[][][] testIntersectionWithLineIsSeg_Data = new double[][][]{new double[][]{{2.0, 1.0}, {2.0, 9.0}, {2.0, 0.0}, {2.0, -1.0}, {2.0, 1.0}, {2.0, 9.0}}, new double[][]{{1.0, 1.0}, {2.0, 2.0}, {3.0, 3.0}, {4.0, 4.0}, {1.0, 1.0}, {2.0, 2.0}}};
    private static double[][][] testIntersectionWithSegmentIsPoint_Data = new double[][][]{new double[][]{{2.0, 1.0}, {2.0, 9.0}, {0.0, 3.0}, {5.0, 3.0}, {2.0, 3.0}}, new double[][]{{2.0, 1.0}, {2.0, 9.0}, {1.0, 0.0}, {3.0, 4.0}, {2.0, 2.0}}};
    private static double[][][] testIntersectionWithSegmentIsNull_Data = new double[][][]{new double[][]{{2.0, 1.0}, {2.0, 9.0}, {1.99, 0.0}, {1.99, 3.0}}, new double[][]{{2.0, 1.0}, {2.0, 9.0}, {0.0, 0.0}, {2.0, 10.0}}, new double[][]{{2.0, 1.0}, {2.0, 9.0}, {0.0, 0.0}, {3.0, 1.0}}};
    private static double[][][] testIntersectionWithSegIsSeg_Data = new double[][][]{new double[][]{{2.0, 1.0}, {2.0, 9.0}, {2.0, 2.0}, {2.0, -1.0}, {2.0, 1.0}, {2.0, 2.0}}, new double[][]{{1.0, 1.0}, {2.0, 2.0}, {1.5, 1.5}, {4.0, 4.0}, {1.5, 1.5}, {2.0, 2.0}}, new double[][]{{1.0, 1.0}, {2.0, 2.0}, {0.0, 0.0}, {4.0, 4.0}, {1.0, 1.0}, {2.0, 2.0}}};
    private static double[][][][] testIntersectionWithZigzagNotNull_Data = new double[][][][]{new double[][][]{new double[][]{{2.0, 1.0}, {2.0, 9.0}, {2.0, 2.0}, {2.0, 3.0}, {3.0, 4.0}, {2.0, 4.0}, {2.0, 5.0}}, new double[][]{{2.0, 2.0}, {2.0, 3.0}}, new double[][]{{2.0, 4.0}, {2.0, 5.0}}}, new double[][][]{new double[][]{{2.0, 1.0}, {2.0, 9.0}, {2.0, 2.0}, {2.0, 3.0}, {3.0, 4.0}, {2.0, 4.0}}, new double[][]{{2.0, 2.0}, {2.0, 3.0}}, new double[][]{{2.0, 4.0}}}};

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testContains() {
        this.testContains(testContainsData, true);
    }

    @Test
    public void testNotContains() {
        this.testContains(testNotContainsData, false);
    }

    private void testContains(double[][][][] data, boolean contains) {
        boolean allPassed = true;
        double[][][][] dArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            double[][][] testData = dArray[n2];
            double[][] input = testData[0];
            double[][] expectedResult = testData[1];
            R2 p1 = new R2(input[0][0], input[0][1]);
            R2 p2 = new R2(input[1][0], input[1][1]);
            LineSegment2D segment = new LineSegment2D(p1, p2);
            boolean passed = true;
            double[][] dArray2 = expectedResult;
            int n3 = expectedResult.length;
            int n4 = 0;
            while (n4 < n3) {
                double[] coords = dArray2[n4];
                R2 point = new R2(coords[0], coords[1]);
                if (segment.contains((Object)point) != contains) {
                    System.out.println("FAILED: Segemt " + segment + " must " + (!contains ? "NOT " : "") + "contains point " + point);
                    passed = false;
                }
                ++n4;
            }
            if (!passed) {
                allPassed = false;
            }
            ++n2;
        }
        Assert.assertTrue((boolean)allPassed);
    }

    @Test
    public void testIncludesSegment() {
        this.testIncludesSegment(testIncludesSegmentData, true);
    }

    @Test
    public void testNotIncludesSegment() {
        this.testIncludesSegment(testNotIncludesSegmentData, false);
    }

    private void testIncludesSegment(double[][][][] data, boolean includes) {
        boolean passed = true;
        double[][][][] dArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            double[][][] testData = dArray[n2];
            double[][] segmentData = testData[0];
            double[][] otherSegmentsData = testData[1];
            R2 p1 = new R2(segmentData[0][0], segmentData[0][1]);
            R2 p2 = new R2(segmentData[1][0], segmentData[1][1]);
            LineSegment2D segment = new LineSegment2D(p1, p2);
            int i = 0;
            while (i < otherSegmentsData.length) {
                R2 p3 = new R2(otherSegmentsData[i][0], otherSegmentsData[i][1]);
                R2 p4 = new R2(otherSegmentsData[i + 1][0], otherSegmentsData[i + 1][1]);
                LineSegment2D otherSegment = new LineSegment2D(p3, p4);
                if (segment.includes((Object)otherSegment) != includes) {
                    System.out.println("FAILED: Segment " + segment + " must " + (!includes ? "NOT " : "") + "include segment " + otherSegment);
                    passed = false;
                }
                i += 2;
            }
            ++n2;
        }
        Assert.assertTrue((boolean)passed);
    }

    @Test
    public void testIncludesZizagLine() {
        this.testIncludesZizagLine(testIncludesZigzagLineData, true);
    }

    @Test
    public void testNotIncludesZizagLine() {
        this.testIncludesZizagLine(testNotIncludesZigzagLineData, false);
    }

    private void testIncludesZizagLine(double[][][][] data, boolean includes) {
        boolean passed = true;
        double[][][][] dArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            double[][][] testData = dArray[n2];
            double[][] segmentData = testData[0];
            double[][] zizagLineData = testData[1];
            R2 p1 = new R2(segmentData[0][0], segmentData[0][1]);
            R2 p2 = new R2(segmentData[1][0], segmentData[1][1]);
            LineSegment2D segment = new LineSegment2D(p1, p2);
            R2[] vertices = new R2[zizagLineData.length];
            int i = 0;
            while (i < zizagLineData.length) {
                vertices[i] = new R2(zizagLineData[i][0], zizagLineData[i][1]);
                ++i;
            }
            ZigzagLine2D zigzagLine = new ZigzagLine2D(vertices);
            if (segment.includes((Object)zigzagLine) != includes) {
                System.out.println("FAILED: Segment " + segment + " must " + (!includes ? "NOT " : "") + "include zigzag line " + zigzagLine);
                passed = false;
            }
            ++n2;
        }
        Assert.assertTrue((boolean)passed);
    }

    @Test
    public void testDistance() {
        boolean passed = true;
        double[][][] dArray = testDistanceData;
        int n = testDistanceData.length;
        int n2 = 0;
        while (n2 < n) {
            double[][] testData = dArray[n2];
            R2 p1 = new R2(testData[0][0], testData[0][1]);
            R2 p2 = new R2(testData[1][0], testData[1][1]);
            R2 point = new R2(testData[2][0], testData[2][1]);
            double expectedDistance = testData[3][0];
            LineSegment2D segment = new LineSegment2D(p1, p2);
            if (!ExtMath.areClose(segment.distance(point), expectedDistance, 1.0E-7)) {
                System.out.println("FAILED: distance between segment " + segment + " and point " + point + " must be equal to " + expectedDistance);
                passed = false;
            }
            ++n2;
        }
        Assert.assertTrue((boolean)passed);
    }

    @Test
    public void testIntersectionWithLineIsPoint() {
        boolean passed = true;
        double[][][] dArray = testIntersectionWithLineIsPoint_Data;
        int n = testIntersectionWithLineIsPoint_Data.length;
        int n2 = 0;
        while (n2 < n) {
            double[][] testData = dArray[n2];
            R2 p1 = new R2(testData[0][0], testData[0][1]);
            R2 p2 = new R2(testData[1][0], testData[1][1]);
            LineSegment2D segment = new LineSegment2D(p1, p2);
            R2 p3 = new R2(testData[2][0], testData[2][1]);
            R2 p4 = new R2(testData[3][0], testData[3][1]);
            Line2D line = new Line2D(p3, p4);
            R2 expectedPoint = new R2(testData[4][0], testData[4][1]);
            Object obj = segment.intersection(line);
            if (!(obj instanceof R2)) {
                if (obj == null) {
                    System.out.println("FAILED: calculated intersection of segment " + segment + " and line " + line + " is null, but shoud be point");
                } else {
                    System.out.println("FAILED: calculated intersection of segment " + segment + " and line " + line + " is segment, but shoud be point");
                }
                passed = false;
            } else if (!((R2)obj).equals(expectedPoint)) {
                System.out.println("FAILED: calculated intersection of segment " + segment + " and line " + line + " is point " + (R2)obj + ", but shoud be point " + expectedPoint);
            }
            ++n2;
        }
        Assert.assertTrue((boolean)passed);
    }

    @Test
    public void testIntersectionWithLineIsNull() {
        boolean passed = true;
        double[][][] dArray = testIntersectionWithLineIsNull_Data;
        int n = testIntersectionWithLineIsNull_Data.length;
        int n2 = 0;
        while (n2 < n) {
            double[][] testData = dArray[n2];
            R2 p1 = new R2(testData[0][0], testData[0][1]);
            R2 p2 = new R2(testData[1][0], testData[1][1]);
            LineSegment2D segment = new LineSegment2D(p1, p2);
            R2 p3 = new R2(testData[2][0], testData[2][1]);
            R2 p4 = new R2(testData[3][0], testData[3][1]);
            Line2D line = new Line2D(p3, p4);
            Object obj = segment.intersection(line);
            if (obj != null) {
                if (obj instanceof R2) {
                    System.out.println("FAILED: calculated intersection of segment " + segment + " and line " + line + " is point, but shoud be null");
                } else {
                    System.out.println("FAILED: calculated intersection of segment " + segment + " and line " + line + " is segment, but shoud be null");
                }
                passed = false;
            }
            ++n2;
        }
        Assert.assertTrue((boolean)passed);
    }

    @Test
    public void testIntersectionWithLineIsSeg() {
        boolean passed = true;
        double[][][] dArray = testIntersectionWithLineIsSeg_Data;
        int n = testIntersectionWithLineIsSeg_Data.length;
        int n2 = 0;
        while (n2 < n) {
            double[][] testData = dArray[n2];
            R2 p1 = new R2(testData[0][0], testData[0][1]);
            R2 p2 = new R2(testData[1][0], testData[1][1]);
            LineSegment2D segment = new LineSegment2D(p1, p2);
            R2 p3 = new R2(testData[2][0], testData[2][1]);
            R2 p4 = new R2(testData[3][0], testData[3][1]);
            Line2D line = new Line2D(p3, p4);
            R2 p5 = new R2(testData[4][0], testData[4][1]);
            R2 p6 = new R2(testData[5][0], testData[5][1]);
            LineSegment2D expectedSegment = new LineSegment2D(p5, p6);
            Object obj = segment.intersection(line);
            if (!(obj instanceof LineSegment2D)) {
                if (obj == null) {
                    System.out.println("FAILED: calculated intersection of segment " + segment + " and line " + line + " is null, but shoud be segment");
                } else {
                    System.out.println("FAILED: calculated intersection of segment " + segment + " and line " + line + " is point, but shoud be segment");
                }
                passed = false;
            } else if (!((LineSegment2D)obj).equals(expectedSegment)) {
                System.out.println("FAILED: calculated intersection of segment " + segment + " and line " + line + " is segment" + (LineSegment2D)obj + ", but shoud be segment " + expectedSegment);
            }
            ++n2;
        }
        Assert.assertTrue((boolean)passed);
    }

    @Test
    public void testIntersectionWithSegmentIsPoint() {
        boolean passed = true;
        double[][][] dArray = testIntersectionWithSegmentIsPoint_Data;
        int n = testIntersectionWithSegmentIsPoint_Data.length;
        int n2 = 0;
        while (n2 < n) {
            double[][] testData = dArray[n2];
            R2 p1 = new R2(testData[0][0], testData[0][1]);
            R2 p2 = new R2(testData[1][0], testData[1][1]);
            LineSegment2D segment = new LineSegment2D(p1, p2);
            R2 p3 = new R2(testData[2][0], testData[2][1]);
            R2 p4 = new R2(testData[3][0], testData[3][1]);
            LineSegment2D otherSegment = new LineSegment2D(p3, p4);
            R2 expectedPoint = new R2(testData[4][0], testData[4][1]);
            Object obj = segment.intersection(otherSegment);
            if (!(obj instanceof R2)) {
                if (obj == null) {
                    System.out.println("FAILED: calculated intersection of segment " + segment + " and segment " + otherSegment + " is null, but shoud be point");
                } else {
                    System.out.println("FAILED: calculated intersection of segment " + segment + " and segment " + otherSegment + " is segment, but shoud be point");
                }
                passed = false;
            } else if (!((R2)obj).equals(expectedPoint)) {
                System.out.println("FAILED: calculated intersection of segment " + segment + " and segment " + otherSegment + " is point " + (R2)obj + ", but shoud be point " + expectedPoint);
            }
            ++n2;
        }
        Assert.assertTrue((boolean)passed);
    }

    @Test
    public void testIntersectionWithSegmentIsNull() {
        boolean passed = true;
        double[][][] dArray = testIntersectionWithSegmentIsNull_Data;
        int n = testIntersectionWithSegmentIsNull_Data.length;
        int n2 = 0;
        while (n2 < n) {
            double[][] testData = dArray[n2];
            R2 p1 = new R2(testData[0][0], testData[0][1]);
            R2 p2 = new R2(testData[1][0], testData[1][1]);
            LineSegment2D segment = new LineSegment2D(p1, p2);
            R2 p3 = new R2(testData[2][0], testData[2][1]);
            R2 p4 = new R2(testData[3][0], testData[3][1]);
            LineSegment2D otherSegment = new LineSegment2D(p3, p4);
            Object obj = segment.intersection(otherSegment);
            if (obj != null) {
                if (obj instanceof R2) {
                    System.out.println("FAILED: calculated intersection of segment " + segment + " and segment " + otherSegment + " is point, but shoud be null");
                } else {
                    System.out.println("FAILED: calculated intersection of segment " + segment + " and segment " + otherSegment + " is segment, but shoud be null");
                }
                passed = false;
            }
            ++n2;
        }
        Assert.assertTrue((boolean)passed);
    }

    @Test
    public void testIntersectionWithSegIsSeg() {
        boolean passed = true;
        double[][][] dArray = testIntersectionWithSegIsSeg_Data;
        int n = testIntersectionWithSegIsSeg_Data.length;
        int n2 = 0;
        while (n2 < n) {
            double[][] testData = dArray[n2];
            R2 p1 = new R2(testData[0][0], testData[0][1]);
            R2 p2 = new R2(testData[1][0], testData[1][1]);
            LineSegment2D segment = new LineSegment2D(p1, p2);
            R2 p3 = new R2(testData[2][0], testData[2][1]);
            R2 p4 = new R2(testData[3][0], testData[3][1]);
            LineSegment2D otherSegment = new LineSegment2D(p3, p4);
            R2 p5 = new R2(testData[4][0], testData[4][1]);
            R2 p6 = new R2(testData[5][0], testData[5][1]);
            LineSegment2D expectedSegment = new LineSegment2D(p5, p6);
            Object obj = segment.intersection(otherSegment);
            if (!(obj instanceof LineSegment2D)) {
                if (obj == null) {
                    System.out.println("FAILED: calculated intersection of segment " + segment + " and segment " + otherSegment + " is null, but shoud be segment");
                } else {
                    System.out.println("FAILED: calculated intersection of segment " + segment + " and segment " + otherSegment + " is point, but shoud be segment");
                }
                passed = false;
            } else if (!((LineSegment2D)obj).equals(expectedSegment)) {
                System.out.println("FAILED: calculated intersection of segment " + segment + " and segment " + otherSegment + " is segment" + (LineSegment2D)obj + ", but shoud be segment " + expectedSegment);
            }
            ++n2;
        }
        Assert.assertTrue((boolean)passed);
    }

    @Test
    public void testIntersectionWithZigzagNotNull() {
        boolean passed = true;
        double[][][][] dArray = testIntersectionWithZigzagNotNull_Data;
        int n = testIntersectionWithZigzagNotNull_Data.length;
        int n2 = 0;
        while (n2 < n) {
            double[][][] testData = dArray[n2];
            double[][] input = testData[0];
            R2 p1 = new R2(input[0][0], input[0][1]);
            R2 p2 = new R2(input[1][0], input[1][1]);
            LineSegment2D segment = new LineSegment2D(p1, p2);
            R2[] vertices = new R2[input.length - 2];
            int i = 0;
            while (i < vertices.length) {
                vertices[i] = new R2(input[i + 2][0], input[i + 2][1]);
                ++i;
            }
            ZigzagLine2D zigzag = new ZigzagLine2D(vertices);
            HashSet<Object> expectedSet = new HashSet<Object>();
            int i2 = 1;
            while (i2 < testData.length) {
                double[][] points = testData[i2];
                if (points.length == 2) {
                    R2 p3 = new R2(points[0][0], points[0][1]);
                    R2 p4 = new R2(points[1][0], points[1][1]);
                    expectedSet.add(new LineSegment2D(p3, p4));
                } else {
                    expectedSet.add(new R2(points[0][0], points[0][1]));
                }
                ++i2;
            }
            Set<Object> set = segment.intersection(zigzag);
            if (set != null) {
                if (!set.equals(expectedSet)) {
                    System.out.println("FAILED: calculated intersection of segment " + segment + " and zigzag line " + zigzag + " is " + set + ", but shoud be " + expectedSet);
                    passed = false;
                }
            } else {
                System.out.println("FAILED: calculated intersection of segment " + segment + " and zigzag line " + zigzag + " is null, but shoul be  " + (LineSegment2D)((Object)set) + ", but shoud be " + set);
                passed = false;
            }
            ++n2;
        }
        Assert.assertTrue((boolean)passed);
    }
}

