/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.fileio;

import edu.uml.lgdc.fileio.FileRW;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileFilter;

public class ExtFilter
extends FileFilter
implements FilenameFilter {
    private List<String> extensions = new ArrayList<String>();
    private String description = "";
    private boolean includeDirectories;
    private boolean asteriskExtensionPresent;

    public ExtFilter(String extension) {
        this(extension, false);
    }

    public ExtFilter(String extension, boolean includeDirectories) {
        this(new String[]{extension}, includeDirectories);
    }

    public ExtFilter(String[] extArray) {
        this(extArray, false);
    }

    public ExtFilter(String[] extArray, boolean includeDirectories) {
        int i = 0;
        while (i < extArray.length) {
            this.extensions.add(extArray[i]);
            if (extArray[i].equals("*")) {
                this.asteriskExtensionPresent = true;
            }
            this.description = String.valueOf(this.description) + "*." + extArray[i] + ";";
            ++i;
        }
        this.includeDirectories = includeDirectories;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return this.accept(file.getPath());
    }

    @Override
    public boolean accept(File dir, String filename) {
        return this.accept(new File(dir, filename).getPath());
    }

    public boolean accept(String filename) {
        File file = new File(filename);
        if (!this.includeDirectories ? file.isDirectory() : file.isDirectory()) {
            return false;
        }
        if (this.asteriskExtensionPresent) {
            return true;
        }
        String extension = FileRW.getExt(filename);
        String filenameButExt = FileRW.getNameButExt(filename);
        for (String ext : this.extensions) {
            if (ext.length() != extension.length()) continue;
            if (ext.length() == 0) {
                return true;
            }
            File patternFile = new File(String.valueOf(filenameButExt) + "." + ext);
            if (!file.equals(patternFile)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

