/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.fileio;

import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.time.TimeScale;
import java.io.File;

public class FileDesc {
    public String name = null;
    public boolean isDirectory = false;
    public TimeScale humanLastModified = null;
    public long internalLastModified = -1L;
    public long size = -1L;

    public void fill(File file) {
        this.clear();
        if (file != null) {
            this.name = file.getName();
            this.isDirectory = file.isDirectory();
            this.internalLastModified = file.lastModified();
            this.size = file.length();
        }
    }

    public void fill(String line) {
        this.clear();
        int filenamePos = -1;
        if (line != null && !(line = line.trim()).startsWith("total")) {
            filenamePos = line.lastIndexOf(32);
            this.name = line.substring(++filenamePos);
            this.isDirectory = line.charAt(0) == 'd';
            String str = line.substring(filenamePos - 23, filenamePos - 14).trim();
            this.size = FC.StringToLong(str);
            str = line.substring(filenamePos - 13, filenamePos - 1).trim().toUpperCase();
            this.humanLastModified = this.getTimeFromFTPString(str);
        }
    }

    public static FileDesc create(File file) {
        FileDesc desc = new FileDesc();
        desc.fill(file);
        if (desc.name == null) {
            desc = null;
        }
        return desc;
    }

    public static FileDesc create(String line) {
        FileDesc desc = new FileDesc();
        desc.fill(line);
        if (desc.name == null) {
            desc = null;
        }
        return desc;
    }

    private TimeScale getTimeFromFTPString(String str) {
        TimeScale lastModified = null;
        int hr = 0;
        int min = 0;
        int sec = 0;
        int month = TimeScale.monthToNumber(str.substring(0, 3));
        if (month > 0) {
            int year;
            --month;
            int day = FC.StringToInteger(str.substring(4, 6));
            if (str.charAt(9) == ':') {
                hr = FC.StringToInteger(str.substring(7, 9));
                min = FC.StringToInteger(str.substring(10));
                TimeScale currTime = new TimeScale();
                year = currTime.get(1);
                if (currTime.get(2) > month) {
                    --year;
                }
            } else {
                year = FC.StringToInteger(str.substring(8));
            }
            lastModified = new TimeScale(year, month, day, hr, min, sec);
        }
        return lastModified;
    }

    private void clear() {
        this.name = null;
        this.isDirectory = false;
        this.humanLastModified = null;
        this.internalLastModified = -1L;
        this.size = -1L;
    }
}

