/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.fileio;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class FileRW
extends RandomAccessFile
implements Closeable {
    private String filePathName;
    private File file;
    private String fileName;
    public String filePath;
    public static final int BIG_ENDIAN = 1;
    public static final int LITTLE_ENDIAN = 2;
    private byte[] w;
    private int endian;

    public FileRW(String inPathName) throws IOException {
        this(inPathName, "rw");
    }

    public FileRW(String inPathName, String mode) throws IOException {
        super(inPathName, mode);
        this.init(inPathName);
    }

    private void init(String inPathName) {
        this.filePathName = inPathName;
        this.file = new File(this.filePathName);
        this.fileName = this.file.getName();
        this.filePath = this.file.getParent();
        if (this.filePath == null) {
            this.filePath = ".";
        }
        this.w = new byte[8];
        this.endian = 1;
    }

    public int getEndian() {
        return this.endian;
    }

    public void setEndian(int in) {
        this.endian = in;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPathName() {
        return this.filePath;
    }

    public String getFullFileName() {
        return this.filePathName;
    }

    public boolean ready() throws IOException {
        return this.length() - this.getFilePointer() > 0L;
    }

    public void newLine() throws IOException {
        this.writeBytes("\r\n");
    }

    public void write(String str) throws IOException {
        this.writeBytes(str);
    }

    public short readShortE() throws IOException {
        if (this.endian == 1) {
            return this.readShort();
        }
        this.readFully(this.w, 0, 2);
        return (short)((this.w[1] & 0xFF) << 8 | this.w[0] & 0xFF);
    }

    public int readIntE() throws IOException {
        if (this.endian == 1) {
            return this.readInt();
        }
        this.readFully(this.w, 0, 4);
        return this.w[3] << 24 | (this.w[2] & 0xFF) << 16 | (this.w[1] & 0xFF) << 8 | this.w[0] & 0xFF;
    }

    public void copyFromFile(String fileName) throws IOException {
        byte[] b = new byte[32000];
        try (FileRW in = null;){
            in = new FileRW(fileName, "r");
            while (in.ready()) {
                int len = in.read(b);
                this.write(b, 0, len);
            }
        }
    }

    public void copyToFile(String filename) throws IOException {
        byte[] b = new byte[32000];
        RandomAccessFile to = null;
        long savedPos = this.getFilePointer();
        try {
            new File(filename).delete();
            to = new FileRW(filename, "rw");
            while (this.ready()) {
                int len = this.read(b);
                to.write(b, 0, len);
            }
        }
        finally {
            if (to != null) {
                to.close();
            }
            this.seek(savedPos);
        }
    }

    public void copyFromStream(InputStream inputStream) throws IOException {
        byte[] b = new byte[32000];
        while (inputStream.available() > 0) {
            int len = inputStream.read(b);
            this.write(b, 0, len);
        }
    }

    public final String smartReadLine() throws IOException {
        int c;
        StringBuffer input = new StringBuffer(200);
        while ((c = this.read()) != -1 && c != 13 && c != 10) {
            input.append((char)c);
        }
        if (c == 13) {
            long offset = this.getFilePointer();
            int b = this.read();
            if (b != -1 && b != 10) {
                this.seek(offset);
            }
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    public static String getExt(String fileName) {
        String ext = "";
        int pos = fileName.lastIndexOf(46);
        if (pos >= 0 && pos < fileName.length() - 1) {
            ext = fileName.substring(pos + 1);
        }
        return ext;
    }

    public static String getNameButExt(String fileName) {
        int pos = fileName.lastIndexOf(46);
        if (pos >= 0) {
            fileName = fileName.substring(0, pos);
        }
        return fileName;
    }

    public static String getFileName(String fullFileName) {
        return new File(fullFileName).getName();
    }

    public String getFileNameOnly() {
        return FileRW.getNameButExt(this.fileName);
    }

    public static String getFileNameOnly(String fullFileName) {
        return FileRW.getNameButExt(new File(fullFileName).getName());
    }

    public static String getPath(String fullFileName) {
        String parent = new File(fullFileName).getParent();
        if (parent != null) {
            return parent;
        }
        return ".";
    }

    public static long getLength(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName == null");
        }
        return FileRW.get_Length(null, fileName);
    }

    public static long getLength(String path, String fileName) {
        if (path == null && fileName == null) {
            throw new IllegalArgumentException("path == null and fileName == null");
        }
        return FileRW.get_Length(path, fileName);
    }

    private static long get_Length(String path, String fileName) {
        File file = fileName == null ? new File(path) : new File(path, fileName);
        if (file.isFile()) {
            return file.length();
        }
        return -1L;
    }

    public static boolean deleteFile(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName == null");
        }
        return FileRW.delete_File(null, fileName);
    }

    public static boolean deleteFile(String path, String fileName) {
        if (path == null && fileName == null) {
            throw new IllegalArgumentException("path == null and fileName == null");
        }
        return FileRW.delete_File(path, fileName);
    }

    private static boolean delete_File(String path, String fileName) {
        File file = fileName != null ? new File(path, fileName) : new File(path);
        return file.delete();
    }

    public static void fileCopy(String from, String to) throws IOException {
        File target = new File(to);
        if (target.exists()) {
            if (!target.isFile()) {
                throw new IOException(String.valueOf(to) + " is not a file ");
            }
            if (!target.delete()) {
                throw new IOException("Cannot delete file " + to);
            }
        }
        try (FileRW out = null;){
            out = new FileRW(to, "rw");
            out.copyFromFile(from);
        }
    }

    public static void safeFileCopy(String from, String to) throws IOException {
        File source = new File(from);
        if (source.exists() && !source.isFile()) {
            throw new IOException(String.valueOf(from) + " is not a file");
        }
        File f2 = new File(to);
        if (f2.exists() && !f2.isFile()) {
            throw new IOException(String.valueOf(to) + " is not a file");
        }
        if (f2.equals(source)) {
            throw new IOException("Try to copy file onto itself, " + from);
        }
        String filePathNamePart = String.valueOf(to) + ".tmp";
        File f2tmp = new File(filePathNamePart);
        if (f2tmp.exists() && !f2tmp.delete()) {
            throw new IOException("Cannot delete file " + filePathNamePart);
        }
        FileRW out = null;
        boolean ok = false;
        try {
            out = new FileRW(filePathNamePart, "rw");
            out.copyFromFile(from);
            ok = true;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
                if (!ok) {
                    f2tmp.delete();
                }
            }
        }
        File f1 = new File(filePathNamePart);
        if (f2.exists() && !f2.delete()) {
            throw new IOException("Cannot delete file " + to);
        }
        if (!f1.renameTo(f2)) {
            throw new IOException("Cannot rename file " + filePathNamePart + " to " + to);
        }
    }

    public static String getSysExeExt() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("win") >= 0) {
            return ".exe";
        }
        if (osName.indexOf("mac") >= 0) {
            return ".app";
        }
        return ".bin";
    }
}

