/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.fileio;

import edu.uml.lgdc.datatype.PoolObjectDesc;
import edu.uml.lgdc.datatype.PoolOfObjects;
import edu.uml.lgdc.fileio.DateMaskStringFilter;
import edu.uml.lgdc.fileio.FileFilterType;
import edu.uml.lgdc.fileio.FileRW;
import edu.uml.lgdc.fileio.FiledescTimeFilter;
import edu.uml.lgdc.fileio.MaskBuilder;
import edu.uml.lgdc.fileio.constants.FileDeleteResult;
import edu.uml.lgdc.format.StrDecoder;
import edu.uml.lgdc.math.Search;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.time.TimeScale;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FileUtils {
    public static final int CONNECTION_TIMEOUT = 6000;
    public static final int READ_TIMEOUT = 20000;
    private static final int MAX_NUMBER_OF_BUFFERS = 20;
    private static final int DEFAULT_BUFFER_SIZE = 200000;
    private static final ByteBuffersPool byteBuffersPool = new ByteBuffersPool(20, 200000);
    private static final long STILL_TIME_COUNT_FILES = 300000L;
    private static transient int countFilesDirLevel = 0;
    private static transient boolean messageWasIssuedForThisCall = false;
    private static transient long lastTimeStampWhenMessageWasIssued = 0L;
    private static transient long thisTimeStamp = 0L;

    public static boolean fileRename(String source, String destination, String msgPrefix) {
        File f1 = new File(source);
        if (msgPrefix == null) {
            msgPrefix = "";
        }
        String during = msgPrefix.length() == 0 ? "During" : " during";
        if (!f1.exists()) {
            Console.showError(String.valueOf(msgPrefix) + during + " renaming from " + source + ", - file does not exist");
            return false;
        }
        File f2 = new File(destination);
        if (f2.exists()) {
            Console.showError(String.valueOf(msgPrefix) + during + " renaming to " + destination + ", - already exists");
            return false;
        }
        if (!f1.renameTo(f2)) {
            Console.showError(String.valueOf(msgPrefix) + during + " renaming from " + source + " to " + destination);
            return false;
        }
        return true;
    }

    public static boolean fileRename(String source, String destination, boolean deleteTarget) {
        return FileUtils.fileRename(new File(source), new File(destination), deleteTarget);
    }

    public static boolean fileRename(File source, File destination, boolean deleteTarget) {
        if (!source.exists()) {
            Console.showError("Renaming from " + source + ", - source file does not exist");
            return false;
        }
        if (deleteTarget && destination.exists() && !destination.delete()) {
            Console.showError("Renaming to file \"" + destination + "\", - can't delete existing destination file");
            return false;
        }
        if (!source.renameTo(destination)) {
            try {
                FileRW.safeFileCopy(source.getPath(), destination.getPath());
                if (!source.delete()) {
                    Console.showError("Moving to file \"" + destination + "\", - can't delete source file \"" + source + "\"");
                    return false;
                }
                return true;
            }
            catch (IOException ex) {
                Console.showError("Moving from \"" + source + "\" to \"" + destination + "\", - , see below");
                Console.printThreadStackTrace(ex);
                return false;
            }
        }
        return true;
    }

    public static boolean fileDelete(String filename) {
        return FileUtils.fileDelete(new File(filename));
    }

    public static boolean fileDelete(File file) {
        return FileUtils.fileDelete(file, false);
    }

    public static boolean fileDelete(File file, boolean returnTrueIfNotExists) {
        FileDeleteResult result = FileUtils.fileDel(file, returnTrueIfNotExists);
        if (result == FileDeleteResult.DELETED) {
            return true;
        }
        return result == FileDeleteResult.NOT_EXISTS && returnTrueIfNotExists;
    }

    public static FileDeleteResult fileDel(File file, boolean noMsgIfNotExists) {
        FileDeleteResult result;
        if (file.delete()) {
            return FileDeleteResult.DELETED;
        }
        if (!file.exists() && noMsgIfNotExists) {
            return FileDeleteResult.NOT_EXISTS;
        }
        if (file.isFile()) {
            Console.showError("Can't delete existing file \"" + file + "\", possibly access violation");
            result = FileDeleteResult.NOT_DELETED_FILE;
        } else if (file.isDirectory()) {
            Console.showError("Can't delete existing directory \"" + file + "\", possibly access violation or non-empty directory");
            result = FileDeleteResult.NOT_DELETED_DIR;
        } else {
            Console.showError("Can't delete file \"" + file + "\" it does not exist");
            result = FileDeleteResult.NOT_EXISTS;
        }
        return result;
    }

    public static boolean removeDirOrFile(File file) {
        if (file.isDirectory()) {
            return FileUtils.removeDir(file);
        }
        return file.delete();
    }

    public static boolean removeDir(File dir) {
        if (!FileUtils.removeAllDownFromDir(dir)) {
            return false;
        }
        return dir.delete();
    }

    public static boolean removeAllDownFromDir(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return false;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory() && !FileUtils.removeAllDownFromDir(file)) {
                return false;
            }
            if (!file.delete()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean removeFilesFromDir(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return false;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile() && !file.delete()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean removeDatedDir(File dir, String fileDateMask, TimeScale start, TimeScale end) {
        if (dir == null) {
            throw new IllegalArgumentException("dir == null");
        }
        if (fileDateMask == null) {
            throw new IllegalArgumentException("fileDateMask == null");
        }
        FiledescTimeFilter filter = new FiledescTimeFilter(new DateMaskStringFilter(MaskBuilder.dateByMask(fileDateMask), start, end), FileFilterType.TYPE_DIR);
        String[] names = dir.list();
        if (names == null) {
            Console.showWarn("directory " + dir + " not found");
            return false;
        }
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (filter.accept(dir, name)) {
                FileUtils.removeDir(new File(dir, name));
            }
            ++n2;
        }
        return true;
    }

    public static void streamToFile(InputStream is, File file) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException("is == null");
        }
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        int BUFFER_SIZE = 100000;
        byte[] buffer = new byte[100000];
        file.delete();
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file), 100000);){
            int bytesRead;
            while ((bytesRead = is.read(buffer)) >= 0) {
                os.write(buffer, 0, bytesRead);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String fileToString(File file) throws IOException {
        StringBuilder text = new StringBuilder(256);
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (text.length() > 0) {
                    text.append("\n").append(line);
                    continue;
                }
                text.append(line);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return text.toString();
    }

    public static void stringToFile(String str, File file) throws IOException {
        try (FileWriter writer = null;){
            writer = new FileWriter(file);
            writer.write(str);
        }
    }

    public static List<String> fileToListOfLines(File file) throws IOException {
        ArrayList<String> list = new ArrayList<String>(1024);
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                list.add(line);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return list;
    }

    public static void listOfLinesToFile(List<String> list, File file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            for (String line : list) {
                writer.write(line);
                writer.write(10);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static long countLines(String fileName) {
        return FileUtils.countLines(new File(fileName));
    }

    public static long countLines(File file) {
        long linesNumber = 0L;
        try {
            BufferedReader bufReader = new BufferedReader(new FileReader(file));
            while (bufReader.readLine() != null) {
                ++linesNumber;
            }
            bufReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return linesNumber;
    }

    public static boolean copyURLToFile(String urlName, File temp) {
        try {
            URL url = new URL(urlName);
            org.apache.commons.io.FileUtils.copyURLToFile((URL)url, (File)temp, (int)6000, (int)20000);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Could not find file " + urlName);
            return false;
        }
    }

    public static int iStream2oStream(InputStream input, OutputStream output) throws IOException {
        int totBytes = 0;
        PoolObjectDesc poolObjectDesc = null;
        try {
            int nBytes;
            poolObjectDesc = byteBuffersPool.get();
            byte[] buffer = (byte[])poolObjectDesc.object;
            while ((nBytes = input.read(buffer)) >= 0) {
                output.write(buffer, 0, nBytes);
                totBytes += nBytes;
            }
            int n = totBytes;
            return n;
        }
        finally {
            if (poolObjectDesc != null) {
                byteBuffersPool.free(poolObjectDesc);
            }
        }
    }

    public static String streamToString(InputStream input, Charset charset) throws IOException {
        StringBuilder strBuf = new StringBuilder(200000);
        int nBytes = 0;
        PoolObjectDesc poolObjectDesc = null;
        try {
            poolObjectDesc = byteBuffersPool.get();
            byte[] buffer = (byte[])poolObjectDesc.object;
            while ((nBytes = input.read(buffer)) >= 0) {
                strBuf.append(StrDecoder.run(buffer, 0, nBytes, charset));
            }
        }
        finally {
            if (poolObjectDesc != null) {
                byteBuffersPool.free(poolObjectDesc);
            }
        }
        return strBuf.toString();
    }

    public static boolean mightBeRenamed(File file1, File file2) {
        boolean mightBeRenamed = false;
        try {
            String absPath1 = file1.getCanonicalPath();
            String absPath2 = file2.getCanonicalPath();
            absPath1 = absPath1.substring(0, absPath1.indexOf(File.separatorChar) + 1);
            absPath2 = absPath2.substring(0, absPath2.indexOf(File.separatorChar) + 1);
            mightBeRenamed = new File(absPath1).equals(new File(absPath2));
        }
        catch (IOException ex) {
            Console.printThreadStackTrace(ex);
        }
        return mightBeRenamed;
    }

    public static String getNameWithoutSuffix(String name, String[] ... ends) {
        if (ends == null) {
            throw new IllegalArgumentException("ends is null");
        }
        if (ends.length == 0) {
            throw new IllegalArgumentException("ends.length == 0");
        }
        int i = 0;
        while (i < ends.length) {
            int j = 0;
            while (j < ends[i].length) {
                if (name.endsWith(ends[i][j])) {
                    return name.substring(0, name.length() - ends[i][j].length());
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static boolean canRead(File file, Map<File, Long> map, Object sync) {
        if (!file.isFile()) {
            FileUtils.remove(file, map, sync);
            return false;
        }
        if (!file.canRead()) {
            FileUtils.put(file, map, "don't have read permission for file " + file.getPath(), sync);
            return false;
        }
        if (FileUtils.isExclusivelyOwned(file.getPath())) {
            FileUtils.put(file, map, "file " + file.getPath() + " exclusively owned by another task", sync);
            return false;
        }
        FileUtils.remove(file, map, sync);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void put(File file, Map<File, Long> map, String msg, Object sync) {
        if (!map.containsKey(file)) {
            if (sync == null) {
                Console.showWarn(msg);
                map.put(file, System.currentTimeMillis());
            } else {
                Map<File, Long> map2 = map;
                synchronized (map2) {
                    Console.showWarn(msg);
                    map.put(file, System.currentTimeMillis());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void remove(File file, Map<File, Long> map, Object sync) {
        if (map.containsKey(file)) {
            if (sync == null) {
                map.remove(file);
            } else {
                Map<File, Long> map2 = map;
                synchronized (map2) {
                    map.remove(file);
                }
            }
        }
    }

    public static boolean containsOrEqual(File dir, File file) {
        String dirPathAbsolute = !dir.getPath().equals(".") ? dir.getAbsolutePath() : new File("").getAbsolutePath();
        String filePathAbsolute = file.getAbsolutePath();
        List<String> dirPathNames = FileUtils.convertToListOfNames(new File(dirPathAbsolute));
        List<String> filePathNames = FileUtils.convertToListOfNames(new File(filePathAbsolute));
        if (dirPathNames.size() > filePathNames.size()) {
            return false;
        }
        File d = null;
        File f = null;
        int i = 0;
        while (i < dirPathNames.size()) {
            d = new File(d, dirPathNames.get(i));
            f = new File(f, filePathNames.get(i));
            ++i;
        }
        return d.equals(f);
    }

    public static List<String> convertToListOfNames(File file) {
        ArrayList<String> reverseNames = new ArrayList<String>();
        do {
            String name;
            if ((name = file.getName()).length() == 0) {
                name = file.getPath();
            }
            reverseNames.add(name);
        } while ((file = file.getParentFile()) != null);
        ArrayList<String> names = new ArrayList<String>();
        int i = reverseNames.size() - 1;
        while (i >= 0) {
            names.add((String)reverseNames.get(i));
            --i;
        }
        return names;
    }

    public static boolean isExclusivelyOwned(String filename) {
        boolean owned;
        block14: {
            owned = false;
            FileRW file = null;
            try {
                try {
                    file = new FileRW(filename, "rw");
                }
                catch (IOException iOException) {
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (IOException ex) {
                            Console.printThreadStackTrace(ex);
                        }
                        file = null;
                        break block14;
                    }
                    owned = true;
                }
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (IOException ex) {
                        Console.printThreadStackTrace(ex);
                    }
                    file = null;
                } else {
                    owned = true;
                }
            }
        }
        return owned;
    }

    public static byte[] file2array(String filename) throws IOException {
        FileRW file = null;
        try {
            file = new FileRW(filename, "r");
            byte[] byArray = FileUtils.file2array(file);
            return byArray;
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static byte[] file2array(FileRW file) throws IOException {
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            throw new IOException("length of file " + file.getFullFileName() + " is greater than " + Integer.MAX_VALUE);
        }
        byte[] data = new byte[(int)length];
        file.seek(0L);
        file.read(data);
        return data;
    }

    public static void moveFile(File a, File b) throws IOException {
        org.apache.commons.io.FileUtils.moveFile((File)a, (File)b);
    }

    public static void cleanDirectory(File dir) throws IOException {
        org.apache.commons.io.FileUtils.cleanDirectory((File)dir);
    }

    public static synchronized int countFiles(String mainDir, boolean useExtFilter, boolean includeFileExt, String[] exts, boolean useDirRecursively) {
        ++countFilesDirLevel;
        int count = FileUtils.count_Files(mainDir, useExtFilter, includeFileExt, exts, false);
        if (useDirRecursively) {
            File dir = new File(mainDir);
            String[] fileList = dir.list();
            if (fileList != null) {
                int i = 0;
                while (i < fileList.length) {
                    File file = new File(dir, fileList[i]);
                    if (file.isDirectory()) {
                        count += FileUtils.countFiles(file.getPath(), useExtFilter, includeFileExt, exts, true);
                    }
                    ++i;
                }
            } else if (!messageWasIssuedForThisCall && (thisTimeStamp = System.currentTimeMillis()) - lastTimeStampWhenMessageWasIssued > 300000L) {
                System.out.println(TimeScale.prefixWithLocalTime("Method list for directory " + dir.getPath() + " returns <null>!", "  "));
                messageWasIssuedForThisCall = true;
                lastTimeStampWhenMessageWasIssued = thisTimeStamp;
            }
        }
        if (--countFilesDirLevel == 0) {
            messageWasIssuedForThisCall = false;
        }
        return count;
    }

    public static synchronized int countFiles(String mainDir, boolean useExtFilter, boolean includeFileExt, String[] exts) {
        return FileUtils.count_Files(mainDir, useExtFilter, includeFileExt, exts, false);
    }

    private static synchronized int count_Files(String mainDir, boolean useExtFilter, boolean includeFileExt, String[] exts, boolean internalCall) {
        int count = 0;
        File dir = new File(mainDir);
        String[] fileList = dir.list();
        if (fileList == null) {
            if (!(internalCall && messageWasIssuedForThisCall || (thisTimeStamp = System.currentTimeMillis()) - lastTimeStampWhenMessageWasIssued <= 300000L)) {
                System.out.println(TimeScale.prefixWithLocalTime("Method list for directory " + dir.getPath() + " returns <null>!", "  "));
                lastTimeStampWhenMessageWasIssued = thisTimeStamp;
                if (internalCall) {
                    messageWasIssuedForThisCall = true;
                }
            }
            return count;
        }
        int i = 0;
        while (i < fileList.length) {
            File file = new File(dir, fileList[i]);
            if (file.isFile() && FileUtils.isThisFileAccepted(file.getPath(), useExtFilter, includeFileExt, exts)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static boolean isThisFileAccepted(String fileName, boolean useExtFilter, boolean includeFileExt, String[] exts) {
        boolean accepted = true;
        if (useExtFilter) {
            if (includeFileExt) {
                if (Search.scanStrIgnoreCase(exts, FileRW.getExt(fileName)) == -1) {
                    accepted = false;
                }
            } else if (Search.scanStrIgnoreCase(exts, FileRW.getExt(fileName)) >= 0) {
                accepted = false;
            }
        }
        return accepted;
    }

    public static EnsureDirResult ensureDirExists(File dir) {
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                return EnsureDirResult.ENSURE_DIR_CANNOT_CREATE;
            }
        } else if (dir.isFile()) {
            return EnsureDirResult.ENSURE_DIR_EXISTS_AS_FILE;
        }
        return EnsureDirResult.ENSURE_DIR_OK;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyPartOfFile(String inputName, long offset, long length, String outputName) throws IOException {
        new File(outputName).delete();
        Throwable throwable = null;
        Object var7_6 = null;
        try {
            FileRW input = new FileRW(inputName, "r");
            try {
                try (FileRW output = new FileRW(outputName, "rw");){
                    input.seek(offset);
                    byte[] buffer = new byte[100000];
                    long leftToRead = length;
                    while (leftToRead > 0L) {
                        int canReadNow = (int)Math.min((long)buffer.length, leftToRead);
                        int numberOfBytesRead = input.read(buffer, 0, canReadNow);
                        if (numberOfBytesRead != -1) {
                            output.write(buffer, 0, numberOfBytesRead);
                            leftToRead -= (long)numberOfBytesRead;
                            continue;
                        }
                        break;
                    }
                }
                if (input == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (input == null) throw throwable;
                input.close();
                throw throwable;
            }
            input.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static void saveToDiagnostics(String errorDir, String destinationFilename, String sourceFilename) {
        try {
            Path inPath = Paths.get(sourceFilename, new String[0]);
            Path outPath = Paths.get(errorDir, destinationFilename);
            Files.copy(inPath, outPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            Console.showError("Error copying " + sourceFilename + " to Disgostics folder");
            e.printStackTrace();
        }
    }

    private static class ByteBuffersPool
    extends PoolOfObjects<byte[]> {
        private int bufferSize;

        public ByteBuffersPool(int numberOfBuffers, int bufferSize) {
            super(numberOfBuffers);
            this.bufferSize = bufferSize;
        }

        @Override
        protected byte[] createInstanceOfObject() {
            return new byte[this.bufferSize];
        }
    }

    public static enum EnsureDirResult {
        ENSURE_DIR_OK,
        ENSURE_DIR_CANNOT_CREATE,
        ENSURE_DIR_EXISTS_AS_FILE;

    }
}

