/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.fileio;

import edu.uml.lgdc.fileio.FileDesc;
import edu.uml.lgdc.fileio.FileFilterType;
import edu.uml.lgdc.fileio.StringFilter;
import java.io.File;
import java.io.FilenameFilter;

public class FiledescFilter
implements FilenameFilter {
    private StringFilter stringFilter = null;
    private FileFilterType type = FileFilterType.TYPE_ANY;

    public FiledescFilter() {
        this(null);
    }

    public FiledescFilter(StringFilter stringFilter) {
        this(stringFilter, FileFilterType.TYPE_ANY);
    }

    public FiledescFilter(StringFilter stringFilter, FileFilterType type) {
        this.stringFilter = stringFilter;
        if (type == null) {
            type = FileFilterType.TYPE_ANY;
        }
        this.type = type;
    }

    public final boolean accept(FileDesc fileDesc) {
        boolean accepted = false;
        if (!(this.stringFilter != null && !this.stringFilter.accept(fileDesc.name) || this.type == FileFilterType.TYPE_FILE && fileDesc.isDirectory || this.type == FileFilterType.TYPE_DIR && !fileDesc.isDirectory || !this.acceptOther(fileDesc))) {
            accepted = true;
        }
        return accepted;
    }

    @Override
    public boolean accept(File dir, String filename) {
        return this.accept(FileDesc.create(new File(dir, filename)));
    }

    protected boolean acceptOther(FileDesc fileDesc) {
        return true;
    }
}

